/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RuntimeValuesInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.OptimizeSparkProcContext;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPartitionPruningOptimization
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)DynamicPartitionPruningOptimization.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        ParseContext parseContext;
        if (procCtx instanceof OptimizeTezProcContext) {
            parseContext = ((OptimizeTezProcContext)procCtx).parseContext;
        } else if (procCtx instanceof OptimizeSparkProcContext) {
            parseContext = ((OptimizeSparkProcContext)procCtx).getParseContext();
        } else {
            throw new IllegalArgumentException("expected parseContext to be either OptimizeTezProcContext or OptimizeSparkProcContext, but found " + procCtx.getClass().getName());
        }
        FilterOperator filter = (FilterOperator)nd;
        FilterDesc desc = (FilterDesc)filter.getConf();
        if (!parseContext.getConf().getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING) && !parseContext.getConf().getBoolVar(HiveConf.ConfVars.SPARK_DYNAMIC_PARTITION_PRUNING)) {
            return null;
        }
        TableScanOperator ts = null;
        if (filter.getParentOperators().size() == 1 && filter.getParentOperators().get(0) instanceof TableScanOperator) {
            ts = (TableScanOperator)filter.getParentOperators().get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent: " + filter.getParentOperators().get(0));
            LOG.debug("Filter: " + desc.getPredicateString());
            LOG.debug("TableScan: " + ts);
        }
        DynamicPartitionPrunerContext removerContext = new DynamicPartitionPrunerContext();
        removerContext.dynLists.clear();
        this.collectDynamicPruningConditions(desc.getPredicate(), removerContext);
        if (ts == null) {
            for (DynamicListContext ctx : removerContext) {
                ExprNodeConstantDesc constNode = new ExprNodeConstantDesc(ctx.parent.getTypeInfo(), true);
                this.replaceExprNode(ctx, desc, constNode);
            }
            return false;
        }
        boolean semiJoin = parseContext.getConf().getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_SEMIJOIN_REDUCTION);
        for (DynamicListContext ctx : removerContext) {
            String column = ExprNodeDescUtils.extractColName(ctx.parent);
            boolean semiJoinAttempted = false;
            if (column != null) {
                String keyBaseAlias = "";
                Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
                if (table != null && table.isPartitionKey(column)) {
                    String columnType = table.getPartColByName(column).getType();
                    String alias = ((TableScanDesc)ts.getConf()).getAlias();
                    PrunedPartitionList plist = parseContext.getPrunedPartitions(alias, ts);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("alias: " + alias);
                        LOG.debug("pruned partition list: ");
                        if (plist != null) {
                            for (Partition p : plist.getPartitions()) {
                                LOG.debug(p.getCompleteName());
                            }
                        }
                    }
                    if (plist == null || plist.getPartitions().size() != 0) {
                        LOG.info("Dynamic partitioning: " + table.getCompleteName() + "." + column);
                        this.generateEventOperatorPlan(ctx, parseContext, ts, column, columnType);
                    } else {
                        LOG.debug("No partition pruning necessary.");
                    }
                } else {
                    LOG.debug("Column " + column + " is not a partition column");
                    if (semiJoin && ((TableScanDesc)ts.getConf()).getFilterExpr() != null) {
                        LOG.debug("Initiate semijoin reduction for " + column);
                        Operator op = ctx.generator;
                        while (op != null && !(op instanceof TableScanOperator)) {
                            op = op.getParentOperators().get(0);
                        }
                        String tableAlias = op == null ? "" : ((TableScanDesc)((TableScanOperator)op).getConf()).getAlias();
                        keyBaseAlias = ctx.generator.getOperatorId() + "_" + tableAlias + "_" + column;
                        semiJoinAttempted = this.generateSemiJoinOperatorPlan(ctx, parseContext, ts, keyBaseAlias);
                    }
                }
                if (semiJoinAttempted) {
                    ArrayList<ExprNodeDesc> betweenArgs = new ArrayList<ExprNodeDesc>();
                    betweenArgs.add(new ExprNodeConstantDesc(Boolean.FALSE));
                    betweenArgs.add(ctx.parent.getChildren().get(0));
                    betweenArgs.add(new ExprNodeDynamicValueDesc(new DynamicValue(keyBaseAlias + "_min", ctx.desc.getTypeInfo())));
                    betweenArgs.add(new ExprNodeDynamicValueDesc(new DynamicValue(keyBaseAlias + "_max", ctx.desc.getTypeInfo())));
                    ExprNodeGenericFuncDesc betweenNode = ExprNodeGenericFuncDesc.newInstance(FunctionRegistry.getFunctionInfo("between").getGenericUDF(), betweenArgs);
                    ArrayList<ExprNodeDesc> bloomFilterArgs = new ArrayList<ExprNodeDesc>();
                    bloomFilterArgs.add(ctx.parent.getChildren().get(0));
                    bloomFilterArgs.add(new ExprNodeDynamicValueDesc(new DynamicValue(keyBaseAlias + "_bloom_filter", (TypeInfo)TypeInfoFactory.binaryTypeInfo)));
                    ExprNodeGenericFuncDesc bloomFilterNode = ExprNodeGenericFuncDesc.newInstance(FunctionRegistry.getFunctionInfo("in_bloom_filter").getGenericUDF(), bloomFilterArgs);
                    ArrayList<ExprNodeDesc> andArgs = new ArrayList<ExprNodeDesc>();
                    andArgs.add(betweenNode);
                    andArgs.add(bloomFilterNode);
                    ExprNodeGenericFuncDesc andExpr = ExprNodeGenericFuncDesc.newInstance(FunctionRegistry.getFunctionInfo("and").getGenericUDF(), andArgs);
                    this.replaceExprNode(ctx, desc, andExpr);
                    continue;
                }
                ExprNodeConstantDesc replaceNode = new ExprNodeConstantDesc(ctx.parent.getTypeInfo(), true);
                this.replaceExprNode(ctx, desc, replaceNode);
                continue;
            }
            ExprNodeConstantDesc constNode = new ExprNodeConstantDesc(ctx.parent.getTypeInfo(), true);
            this.replaceExprNode(ctx, desc, constNode);
        }
        this.cleanTableScanFilters(ts);
        return false;
    }

    private void replaceExprNode(DynamicListContext ctx, FilterDesc desc, ExprNodeDesc node) {
        if (ctx.grandParent == null) {
            desc.setPredicate(node);
        } else {
            int i = ctx.grandParent.getChildren().indexOf(ctx.parent);
            ctx.grandParent.getChildren().remove(i);
            ctx.grandParent.getChildren().add(i, node);
        }
    }

    private void cleanTableScanFilters(TableScanOperator ts) throws SemanticException {
        if (ts == null || ts.getConf() == null || ((TableScanDesc)ts.getConf()).getFilterExpr() == null) {
            return;
        }
        DynamicPartitionPrunerContext removerContext = new DynamicPartitionPrunerContext();
        removerContext.dynLists.clear();
        this.collectDynamicPruningConditions(((TableScanDesc)ts.getConf()).getFilterExpr(), removerContext);
        for (DynamicListContext ctx : removerContext) {
            ExprNodeConstantDesc constNode = new ExprNodeConstantDesc(ctx.parent.getTypeInfo(), true);
            if (ctx.grandParent == null) {
                ((TableScanDesc)ts.getConf()).setFilterExpr(null);
                continue;
            }
            int i = ctx.grandParent.getChildren().indexOf(ctx.parent);
            ctx.grandParent.getChildren().remove(i);
            ctx.grandParent.getChildren().add(i, constNode);
        }
    }

    private void generateEventOperatorPlan(DynamicListContext ctx, ParseContext parseContext, TableScanOperator ts, String column, String columnType) {
        Operator<OperatorDesc> parentOfRS = ctx.generator.getParentOperators().get(0);
        ExprNodeDesc key = ((ReduceSinkDesc)ctx.generator.getConf()).getKeyCols().get(ctx.desc.getKeyIndex());
        ExprNodeDesc partKey = ctx.parent.getChildren().get(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("key expr: " + key);
            LOG.debug("partition key expr: " + partKey);
        }
        ArrayList<ExprNodeDesc> keyExprs = new ArrayList<ExprNodeDesc>();
        keyExprs.add(key);
        ArrayList<String> outputNames = new ArrayList<String>();
        outputNames.add(HiveConf.getColumnInternalName((int)0));
        SelectDesc select = new SelectDesc(keyExprs, outputNames);
        SelectOperator selectOp = (SelectOperator)OperatorFactory.getAndMakeChild(select, parentOfRS, new Operator[0]);
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)parseContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar((Configuration)parseContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        ArrayList<ExprNodeDesc> groupByExprs = new ArrayList<ExprNodeDesc>();
        ExprNodeColumnDesc groupByExpr = new ExprNodeColumnDesc(key.getTypeInfo(), outputNames.get(0), null, false);
        groupByExprs.add(groupByExpr);
        GroupByDesc groupBy = new GroupByDesc(GroupByDesc.Mode.HASH, outputNames, groupByExprs, new ArrayList<AggregationDesc>(), false, groupByMemoryUsage, memoryThreshold, null, false, 0, true);
        GroupByOperator groupByOp = (GroupByOperator)OperatorFactory.getAndMakeChild(groupBy, selectOp, new Operator[0]);
        HashMap<String, ExprNodeDesc> colMap = new HashMap<String, ExprNodeDesc>();
        colMap.put(outputNames.get(0), groupByExpr);
        groupByOp.setColumnExprMap(colMap);
        if (HiveConf.getVar((Configuration)parseContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            DynamicPruningEventDesc eventDesc = new DynamicPruningEventDesc();
            eventDesc.setTableScan(ts);
            eventDesc.setTable(PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyExprs, "key")));
            eventDesc.setTargetColumnName(column);
            eventDesc.setTargetColumnType(columnType);
            eventDesc.setPartKey(partKey);
            OperatorFactory.getAndMakeChild(eventDesc, groupByOp, new Operator[0]);
        } else {
            SparkPartitionPruningSinkDesc desc = new SparkPartitionPruningSinkDesc();
            desc.setTableScan(ts);
            desc.setTable(PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyExprs, "key")));
            desc.setTargetColumnName(column);
            desc.setPartKey(partKey);
            OperatorFactory.getAndMakeChild(desc, groupByOp, new Operator[0]);
        }
    }

    private boolean generateSemiJoinOperatorPlan(DynamicListContext ctx, ParseContext parseContext, TableScanOperator ts, String keyBaseAlias) throws SemanticException {
        Operator<OperatorDesc> parentOfRS = ctx.generator.getParentOperators().get(0);
        ExprNodeDesc key = ((ReduceSinkDesc)ctx.generator.getConf()).getKeyCols().get(ctx.desc.getKeyIndex());
        String internalColName = null;
        ExprNodeDesc exprNodeDesc = key;
        while (!(exprNodeDesc instanceof ExprNodeColumnDesc) && exprNodeDesc.getChildren() != null) {
            exprNodeDesc = exprNodeDesc.getChildren().get(0);
        }
        if (!(exprNodeDesc instanceof ExprNodeColumnDesc)) {
            return false;
        }
        internalColName = ((ExprNodeColumnDesc)exprNodeDesc).getColumn();
        if (parentOfRS instanceof SelectOperator) {
            ExprNodeDesc expr = parentOfRS.getColumnExprMap().get(internalColName);
            while (!(expr instanceof ExprNodeColumnDesc) && expr.getChildren() != null) {
                expr = expr.getChildren().get(0);
            }
            if (!(expr instanceof ExprNodeColumnDesc)) {
                return false;
            }
            ExprNodeColumnDesc colExpr = (ExprNodeColumnDesc)expr;
            String colName = ExprNodeDescUtils.extractColName(colExpr);
            Operator<OperatorDesc> op = parentOfRS.getParentOperators().get(0);
            while (op != null && !(op instanceof TableScanOperator)) {
                op = op.getParentOperators().get(0);
            }
            assert (op != null);
            Table table = ((TableScanDesc)((TableScanOperator)op).getConf()).getTableMetadata();
            if (table.isPartitionKey(colName)) {
                return false;
            }
        }
        ArrayList<ExprNodeDesc> keyExprs = new ArrayList<ExprNodeDesc>();
        keyExprs.add(key);
        ArrayList<String> outputNames = new ArrayList<String>();
        outputNames.add(HiveConf.getColumnInternalName((int)0));
        SelectDesc select = new SelectDesc(keyExprs, outputNames);
        ColumnInfo columnInfo = parentOfRS.getSchema().getColumnInfo(internalColName);
        ArrayList<ColumnInfo> signature = new ArrayList<ColumnInfo>();
        signature.add(columnInfo);
        RowSchema rowSchema = new RowSchema(signature);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ExprNodeDesc exprNode = null;
        exprNode = parentOfRS.getColumnExprMap() != null ? parentOfRS.getColumnExprMap().get(internalColName).clone() : new ExprNodeColumnDesc(columnInfo);
        if (exprNode instanceof ExprNodeColumnDesc) {
            ExprNodeDesc encd = exprNode;
            ((ExprNodeColumnDesc)encd).setColumn(internalColName);
        }
        colExprMap.put(internalColName, exprNode);
        SelectOperator selectOp = (SelectOperator)OperatorFactory.getAndMakeChild(select, rowSchema, colExprMap, parentOfRS, new Operator[0]);
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)parseContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar((Configuration)parseContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        ArrayList groupByExprs = new ArrayList();
        ArrayList<ObjectInspector> aggFnOIs = new ArrayList<ObjectInspector>();
        aggFnOIs.add(key.getWritableObjectInspector());
        ArrayList<ExprNodeDesc> params = new ArrayList<ExprNodeDesc>();
        params.add(new ExprNodeColumnDesc(key.getTypeInfo(), outputNames.get(0), "", false));
        ArrayList<AggregationDesc> aggs = new ArrayList<AggregationDesc>();
        try {
            AggregationDesc min = new AggregationDesc("min", FunctionRegistry.getGenericUDAFEvaluator("min", aggFnOIs, false, false), params, false, GenericUDAFEvaluator.Mode.PARTIAL1);
            AggregationDesc max = new AggregationDesc("max", FunctionRegistry.getGenericUDAFEvaluator("max", aggFnOIs, false, false), params, false, GenericUDAFEvaluator.Mode.PARTIAL1);
            AggregationDesc bloomFilter = new AggregationDesc("bloom_filter", FunctionRegistry.getGenericUDAFEvaluator("bloom_filter", aggFnOIs, false, false), params, false, GenericUDAFEvaluator.Mode.PARTIAL1);
            GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator bloomFilterEval = (GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator)bloomFilter.getGenericUDAFEvaluator();
            bloomFilterEval.setSourceOperator(selectOp);
            bloomFilterEval.setMaxEntries(parseContext.getConf().getLongVar(HiveConf.ConfVars.TEZ_MAX_BLOOM_FILTER_ENTRIES));
            bloomFilterEval.setMinEntries(parseContext.getConf().getLongVar(HiveConf.ConfVars.TEZ_MIN_BLOOM_FILTER_ENTRIES));
            bloomFilterEval.setFactor(parseContext.getConf().getFloatVar(HiveConf.ConfVars.TEZ_BLOOM_FILTER_FACTOR));
            bloomFilter.setGenericUDAFWritableEvaluator(bloomFilterEval);
            aggs.add(min);
            aggs.add(max);
            aggs.add(bloomFilter);
        }
        catch (SemanticException e) {
            LOG.error("Error creating min/max aggregations on key", (Throwable)e);
            throw new IllegalStateException("Error creating min/max aggregations on key", e);
        }
        ArrayList<String> gbOutputNames = new ArrayList<String>();
        gbOutputNames.add(SemanticAnalyzer.getColumnInternalName(0));
        gbOutputNames.add(SemanticAnalyzer.getColumnInternalName(1));
        gbOutputNames.add(SemanticAnalyzer.getColumnInternalName(2));
        GroupByDesc groupBy = new GroupByDesc(GroupByDesc.Mode.HASH, gbOutputNames, new ArrayList<ExprNodeDesc>(), aggs, false, groupByMemoryUsage, memoryThreshold, null, false, 0, false);
        ArrayList<ColumnInfo> groupbyColInfos = new ArrayList<ColumnInfo>();
        groupbyColInfos.add(new ColumnInfo(gbOutputNames.get(0), key.getTypeInfo(), "", false));
        groupbyColInfos.add(new ColumnInfo(gbOutputNames.get(1), key.getTypeInfo(), "", false));
        groupbyColInfos.add(new ColumnInfo(gbOutputNames.get(2), key.getTypeInfo(), "", false));
        GroupByOperator groupByOp = (GroupByOperator)OperatorFactory.getAndMakeChild(groupBy, new RowSchema(groupbyColInfos), (Operator)selectOp, new Operator[0]);
        groupByOp.setColumnExprMap(new HashMap<String, ExprNodeDesc>());
        int colPos = 0;
        ArrayList<ExprNodeDesc> rsValueCols = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < aggs.size() - 1; ++i) {
            ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc(key.getTypeInfo(), gbOutputNames.get(colPos++), "", false);
            rsValueCols.add(colExpr);
        }
        ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.binaryTypeInfo, gbOutputNames.get(colPos++), "", false);
        rsValueCols.add(colExpr);
        ReduceSinkDesc rsDesc = PlanUtils.getReduceSinkDesc(new ArrayList<ExprNodeDesc>(), rsValueCols, gbOutputNames, false, -1, 0, 1, AcidUtils.Operation.NOT_ACID);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(groupByOp.getSchema()), (Operator)groupByOp, new Operator[0]);
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        rsOp.setColumnExprMap(columnExprMap);
        ArrayList<AggregationDesc> aggsFinal = new ArrayList<AggregationDesc>();
        try {
            ArrayList<ObjectInspector> minFinalFnOIs = new ArrayList<ObjectInspector>();
            ArrayList<ObjectInspector> maxFinalFnOIs = new ArrayList<ObjectInspector>();
            ArrayList<ObjectInspector> bloomFilterFinalFnOIs = new ArrayList<ObjectInspector>();
            ArrayList<ExprNodeDesc> minFinalParams = new ArrayList<ExprNodeDesc>();
            ArrayList<ExprNodeDesc> maxFinalParams = new ArrayList<ExprNodeDesc>();
            ArrayList<ExprNodeDesc> bloomFilterFinalParams = new ArrayList<ExprNodeDesc>();
            minFinalFnOIs.add(rsValueCols.get(0).getWritableObjectInspector());
            maxFinalFnOIs.add(rsValueCols.get(1).getWritableObjectInspector());
            bloomFilterFinalFnOIs.add(rsValueCols.get(2).getWritableObjectInspector());
            minFinalParams.add(new ExprNodeColumnDesc(rsValueCols.get(0).getTypeInfo(), (Object)((Object)Utilities.ReduceField.VALUE) + "." + gbOutputNames.get(0), "", false));
            maxFinalParams.add(new ExprNodeColumnDesc(rsValueCols.get(1).getTypeInfo(), (Object)((Object)Utilities.ReduceField.VALUE) + "." + gbOutputNames.get(1), "", false));
            bloomFilterFinalParams.add(new ExprNodeColumnDesc(rsValueCols.get(2).getTypeInfo(), (Object)((Object)Utilities.ReduceField.VALUE) + "." + gbOutputNames.get(2), "", false));
            AggregationDesc min = new AggregationDesc("min", FunctionRegistry.getGenericUDAFEvaluator("min", minFinalFnOIs, false, false), minFinalParams, false, GenericUDAFEvaluator.Mode.FINAL);
            AggregationDesc max = new AggregationDesc("max", FunctionRegistry.getGenericUDAFEvaluator("max", maxFinalFnOIs, false, false), maxFinalParams, false, GenericUDAFEvaluator.Mode.FINAL);
            AggregationDesc bloomFilter = new AggregationDesc("bloom_filter", FunctionRegistry.getGenericUDAFEvaluator("bloom_filter", bloomFilterFinalFnOIs, false, false), bloomFilterFinalParams, false, GenericUDAFEvaluator.Mode.FINAL);
            GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator bloomFilterEval = (GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator)bloomFilter.getGenericUDAFEvaluator();
            bloomFilterEval.setSourceOperator(selectOp);
            bloomFilterEval.setMaxEntries(parseContext.getConf().getLongVar(HiveConf.ConfVars.TEZ_MAX_BLOOM_FILTER_ENTRIES));
            bloomFilterEval.setMinEntries(parseContext.getConf().getLongVar(HiveConf.ConfVars.TEZ_MIN_BLOOM_FILTER_ENTRIES));
            bloomFilterEval.setFactor(parseContext.getConf().getFloatVar(HiveConf.ConfVars.TEZ_BLOOM_FILTER_FACTOR));
            bloomFilter.setGenericUDAFWritableEvaluator(bloomFilterEval);
            aggsFinal.add(min);
            aggsFinal.add(max);
            aggsFinal.add(bloomFilter);
        }
        catch (SemanticException e) {
            LOG.error("Error creating min/max aggregations on key", (Throwable)e);
            throw new IllegalStateException("Error creating min/max aggregations on key", e);
        }
        GroupByDesc groupByDescFinal = new GroupByDesc(GroupByDesc.Mode.FINAL, gbOutputNames, new ArrayList<ExprNodeDesc>(), aggsFinal, false, groupByMemoryUsage, memoryThreshold, null, false, 0, false);
        GroupByOperator groupByOpFinal = (GroupByOperator)OperatorFactory.getAndMakeChild(groupByDescFinal, new RowSchema(rsOp.getSchema()), (Operator)rsOp, new Operator[0]);
        groupByOpFinal.setColumnExprMap(new HashMap<String, ExprNodeDesc>());
        if (parseContext.getContext().getExplainConfig() != null && parseContext.getContext().getExplainConfig().isFormatted()) {
            ArrayList<String> outputOperators = new ArrayList<String>();
            outputOperators.add(groupByOpFinal.getOperatorId());
            ((ReduceSinkDesc)rsOp.getConf()).setOutputOperators(outputOperators);
        }
        ReduceSinkDesc rsDescFinal = PlanUtils.getReduceSinkDesc(new ArrayList<ExprNodeDesc>(), rsValueCols, gbOutputNames, false, -1, 0, 1, AcidUtils.Operation.NOT_ACID);
        ReduceSinkOperator rsOpFinal = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsDescFinal, new RowSchema(groupByOpFinal.getSchema()), (Operator)groupByOpFinal, new Operator[0]);
        rsOpFinal.setColumnExprMap(columnExprMap);
        LOG.debug("DynamicMinMaxPushdown: Saving RS to TS mapping: " + rsOpFinal + ": " + ts);
        parseContext.getRsOpToTsOpMap().put(rsOpFinal, ts);
        if (parseContext.getContext().getExplainConfig() != null && parseContext.getContext().getExplainConfig().isFormatted()) {
            ArrayList<String> outputOperators = new ArrayList<String>();
            outputOperators.add(ts.getOperatorId());
            ((ReduceSinkDesc)rsOpFinal.getConf()).setOutputOperators(outputOperators);
        }
        RuntimeValuesInfo runtimeValuesInfo = new RuntimeValuesInfo();
        TableDesc rsFinalTableDesc = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(rsValueCols, "_col"));
        ArrayList<String> dynamicValueIDs = new ArrayList<String>();
        dynamicValueIDs.add(keyBaseAlias + "_min");
        dynamicValueIDs.add(keyBaseAlias + "_max");
        dynamicValueIDs.add(keyBaseAlias + "_bloom_filter");
        runtimeValuesInfo.setTableDesc(rsFinalTableDesc);
        runtimeValuesInfo.setDynamicValueIDs(dynamicValueIDs);
        runtimeValuesInfo.setColExprs(rsValueCols);
        runtimeValuesInfo.setTsColExpr(ctx.parent.getChildren().get(0));
        parseContext.getRsToRuntimeValuesInfoMap().put(rsOpFinal, runtimeValuesInfo);
        return true;
    }

    private Map<Node, Object> collectDynamicPruningConditions(ExprNodeDesc pred, NodeProcessorCtx ctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> exprRules = new LinkedHashMap<Rule, NodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeDynamicListDesc.class.getName() + "%"), new DynamicPartitionPrunerProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, exprRules, ctx);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(pred);
        HashMap<Node, Object> outputMap = new HashMap<Node, Object>();
        egw.startWalking(startNodes, outputMap);
        return outputMap;
    }

    private static class DynamicPartitionPrunerContext
    implements NodeProcessorCtx,
    Iterable<DynamicListContext> {
        public List<DynamicListContext> dynLists = new ArrayList<DynamicListContext>();

        private DynamicPartitionPrunerContext() {
        }

        public void addDynamicList(ExprNodeDynamicListDesc desc, ExprNodeDesc parent, ExprNodeDesc grandParent, ReduceSinkOperator generator) {
            this.dynLists.add(new DynamicListContext(desc, parent, grandParent, generator));
        }

        @Override
        public Iterator<DynamicListContext> iterator() {
            return this.dynLists.iterator();
        }
    }

    private static class DynamicListContext {
        public ExprNodeDynamicListDesc desc;
        public ExprNodeDesc parent;
        public ExprNodeDesc grandParent;
        public ReduceSinkOperator generator;

        public DynamicListContext(ExprNodeDynamicListDesc desc, ExprNodeDesc parent, ExprNodeDesc grandParent, ReduceSinkOperator generator) {
            this.desc = desc;
            this.parent = parent;
            this.grandParent = grandParent;
            this.generator = generator;
        }
    }

    private static class DynamicPartitionPrunerProc
    implements NodeProcessor {
        private DynamicPartitionPrunerProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeDynamicListDesc desc = (ExprNodeDynamicListDesc)nd;
            DynamicPartitionPrunerContext context = (DynamicPartitionPrunerContext)procCtx;
            ExprNodeDesc parent = (ExprNodeDesc)stack.get(stack.size() - 2);
            ExprNodeDesc grandParent = stack.size() >= 3 ? (ExprNodeDesc)stack.get(stack.size() - 3) : null;
            context.addDynamicList(desc, parent, grandParent, (ReduceSinkOperator)desc.getSource());
            return context;
        }
    }
}

