/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

class KllDirectFloatsSketch
extends KllFloatsSketch {
    private WritableMemory wmem;
    private MemoryRequestServer memReqSvr;

    KllDirectFloatsSketch(KllSketch.SketchStructure sketchStructure, WritableMemory wmem, MemoryRequestServer memReqSvr, KllMemoryValidate memVal) {
        super(sketchStructure);
        this.wmem = wmem;
        this.memReqSvr = memReqSvr;
        this.readOnly = wmem != null && wmem.isReadOnly() || sketchStructure != KllSketch.SketchStructure.UPDATABLE;
        this.levelsArr = memVal.levelsArr;
    }

    static KllDirectFloatsSketch newDirectUpdatableInstance(int k, int m, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        KllPreambleUtil.setMemoryPreInts(dstMem, KllSketch.SketchStructure.UPDATABLE.getPreInts());
        KllPreambleUtil.setMemorySerVer(dstMem, KllSketch.SketchStructure.UPDATABLE.getSerVer());
        KllPreambleUtil.setMemoryFamilyID(dstMem, Family.KLL.getID());
        KllPreambleUtil.setMemoryK(dstMem, k);
        KllPreambleUtil.setMemoryM(dstMem, m);
        KllPreambleUtil.setMemoryN(dstMem, 0L);
        KllPreambleUtil.setMemoryMinK(dstMem, k);
        KllPreambleUtil.setMemoryNumLevels(dstMem, 1);
        int offset = 20;
        dstMem.putIntArray((long)offset, new int[]{k, k}, 0, 2);
        dstMem.putFloatArray((long)(offset += 8), new float[]{Float.NaN, Float.NaN}, 0, 2);
        dstMem.putFloatArray((long)(offset += 8), new float[k], 0, k);
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)dstMem, KllSketch.SketchType.FLOATS_SKETCH, null);
        WritableMemory wMem = dstMem;
        return new KllDirectFloatsSketch(KllSketch.SketchStructure.UPDATABLE, wMem, memReqSvr, memVal);
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "NaN";
        }
        return Float.toString(this.getFloatItemsArray()[index]);
    }

    @Override
    public int getK() {
        return KllPreambleUtil.getMemoryK((Memory)this.wmem);
    }

    @Override
    public float getMaxItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 4;
        return this.wmem.getFloat((long)offset);
    }

    @Override
    float getMaxItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Float.NaN;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 4;
        return this.wmem.getFloat((long)offset);
    }

    @Override
    String getMaxItemAsString() {
        float maxItem = this.getMaxItemInternal();
        return Float.toString(maxItem);
    }

    @Override
    public float getMinItem() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wmem.getFloat((long)offset);
    }

    @Override
    float getMinItemInternal() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY || this.isEmpty()) {
            return Float.NaN;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.getFloatSingleItem();
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        return this.wmem.getFloat((long)offset);
    }

    @Override
    String getMinItemAsString() {
        float minItem = this.getMinItemInternal();
        return Float.toString(minItem);
    }

    @Override
    void setMaxItem(float item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 4;
        this.wmem.putFloat((long)offset, item);
    }

    @Override
    void setMinItem(float item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wmem.putFloat((long)offset, item);
    }

    @Override
    public long getN() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return 0L;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return 1L;
        }
        return KllPreambleUtil.getMemoryN((Memory)this.wmem);
    }

    @Override
    float[] getFloatItemsArray() {
        int k = this.getK();
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new float[k];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            float[] itemsArr = new float[k];
            itemsArr[k - 1] = this.getFloatSingleItem();
            return itemsArr;
        }
        int capacityItems = KllHelper.computeTotalItemCapacity(k, this.getM(), this.getNumLevels());
        float[] floatItemsArr = new float[capacityItems];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        int shift = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.levelsArr[0] : 0;
        int numItems = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? this.getNumRetained() : capacityItems;
        this.wmem.getFloatArray((long)offset, floatItemsArr, shift, numItems);
        return floatItemsArr;
    }

    @Override
    float[] getFloatRetainedItemsArray() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new float[0];
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return new float[]{this.getFloatSingleItem()};
        }
        int numRetained = this.getNumRetained();
        float[] floatItemsArr = new float[numRetained];
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8 + (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 0 : this.levelsArr[0] * 4);
        this.wmem.getFloatArray((long)offset, floatItemsArr, 0, numRetained);
        return floatItemsArr;
    }

    @Override
    float getFloatSingleItem() {
        if (!this.isSingleItem()) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            return this.wmem.getFloat(8L);
        }
        int offset = this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL ? 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8 : 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (2 + this.getK() - 1) * 4;
        return this.wmem.getFloat((long)offset);
    }

    @Override
    int getM() {
        return KllPreambleUtil.getMemoryM((Memory)this.wmem);
    }

    @Override
    MemoryRequestServer getMemoryRequestServer() {
        return this.memReqSvr;
    }

    @Override
    int getMinK() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_FULL || this.sketchStructure == KllSketch.SketchStructure.UPDATABLE) {
            return KllPreambleUtil.getMemoryMinK((Memory)this.wmem);
        }
        return this.getK();
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] bytesOut = new byte[8];
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            ByteArrayUtil.putFloatLE(bytesOut, 0, Float.NaN);
            ByteArrayUtil.putFloatLE(bytesOut, 4, Float.NaN);
            return bytesOut;
        }
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            int offset = 8;
            this.wmem.getByteArray((long)offset, bytesOut, 0, 4);
            ByteArrayUtil.copyBytes(bytesOut, 0, bytesOut, 4, 4);
            return bytesOut;
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure);
        this.wmem.getByteArray((long)offset, bytesOut, 0, 4);
        this.wmem.getByteArray((long)(offset + 4), bytesOut, 4, 4);
        return bytesOut;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.sketchStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            return new byte[0];
        }
        float[] fltArr = this.getFloatRetainedItemsArray();
        byte[] fltByteArr = new byte[fltArr.length * 4];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])fltByteArr);
        wmem2.putFloatArray(0L, fltArr, 0, fltArr.length);
        return fltByteArr;
    }

    @Override
    byte[] getTotalItemsByteArr() {
        float[] fltArr = this.getFloatItemsArray();
        byte[] fltByteArr = new byte[fltArr.length * 4];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])fltByteArr);
        wmem2.putFloatArray(0L, fltArr, 0, fltArr.length);
        return fltByteArr;
    }

    @Override
    WritableMemory getWritableMemory() {
        return this.wmem;
    }

    @Override
    void incN(int increment) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryN(this.wmem, KllPreambleUtil.getMemoryN((Memory)this.wmem) + (long)increment);
    }

    @Override
    void incNumLevels() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int numLevels = KllPreambleUtil.getMemoryNumLevels((Memory)this.wmem);
        KllPreambleUtil.setMemoryNumLevels(this.wmem, ++numLevels);
    }

    @Override
    boolean isLevelZeroSorted() {
        return KllPreambleUtil.getMemoryLevelZeroSortedFlag((Memory)this.wmem);
    }

    @Override
    void setFloatItemsArray(float[] floatItems) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + 8;
        this.wmem.putFloatArray((long)offset, floatItems, 0, floatItems.length);
    }

    @Override
    void setFloatItemsArrayAt(int index, float item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 4;
        this.wmem.putFloat((long)offset, item);
    }

    @Override
    void setFloatItemsArrayAt(int index, float[] items, int srcOffset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int offset = 20 + this.getLevelsArrSizeBytes(this.sketchStructure) + (index + 2) * 4;
        this.wmem.putFloatArray((long)offset, items, srcOffset, length);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryLevelZeroSortedFlag(this.wmem, sorted);
    }

    @Override
    void setMinK(int minK) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryMinK(this.wmem, minK);
    }

    @Override
    void setN(long n) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryN(this.wmem, n);
    }

    @Override
    void setNumLevels(int numLevels) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllPreambleUtil.setMemoryNumLevels(this.wmem, numLevels);
    }

    @Override
    void setWritableMemory(WritableMemory wmem) {
        this.wmem = wmem;
    }

    static final class KllDirectCompactFloatsSketch
    extends KllDirectFloatsSketch {
        KllDirectCompactFloatsSketch(KllSketch.SketchStructure sketchStructure, Memory srcMem, KllMemoryValidate memVal) {
            super(sketchStructure, (WritableMemory)srcMem, null, memVal);
        }
    }
}

