/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.IntArrayPairIterator;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.memory.Memory;

final class HeapAuxHashMap
implements AuxHashMap {
    private final int lgConfigK;
    private int lgAuxArrInts;
    private int auxCount;
    private int[] auxIntArr;

    HeapAuxHashMap(int lgAuxArrInts, int lgConfigK) {
        this.lgConfigK = lgConfigK;
        this.lgAuxArrInts = lgAuxArrInts;
        this.auxIntArr = new int[1 << lgAuxArrInts];
    }

    HeapAuxHashMap(HeapAuxHashMap that) {
        this.lgConfigK = that.lgConfigK;
        this.lgAuxArrInts = that.lgAuxArrInts;
        this.auxCount = that.auxCount;
        this.auxIntArr = (int[])that.auxIntArr.clone();
    }

    static final HeapAuxHashMap heapify(Memory mem, long offset, int lgConfigK, int auxCount, boolean srcCompact) {
        int lgAuxArrInts = srcCompact ? PreambleUtil.computeLgArr(mem, auxCount, lgConfigK) : PreambleUtil.extractLgArr(mem);
        HeapAuxHashMap auxMap = new HeapAuxHashMap(lgAuxArrInts, lgConfigK);
        int configKmask = (1 << lgConfigK) - 1;
        if (srcCompact) {
            for (int i = 0; i < auxCount; ++i) {
                int pair = PreambleUtil.extractInt(mem, offset + (long)(i << 2));
                int slotNo = HllUtil.getPairLow26(pair) & configKmask;
                int value = HllUtil.getPairValue(pair);
                auxMap.mustAdd(slotNo, value);
            }
        } else {
            int auxArrInts = 1 << lgAuxArrInts;
            for (int i = 0; i < auxArrInts; ++i) {
                int pair = PreambleUtil.extractInt(mem, offset + (long)(i << 2));
                if (pair == 0) continue;
                int slotNo = HllUtil.getPairLow26(pair) & configKmask;
                int value = HllUtil.getPairValue(pair);
                auxMap.mustAdd(slotNo, value);
            }
        }
        return auxMap;
    }

    @Override
    public HeapAuxHashMap copy() {
        return new HeapAuxHashMap(this);
    }

    @Override
    public int getAuxCount() {
        return this.auxCount;
    }

    @Override
    public int[] getAuxIntArr() {
        return this.auxIntArr;
    }

    @Override
    public int getCompactSizeBytes() {
        return this.auxCount << 2;
    }

    @Override
    public PairIterator getIterator() {
        return new IntArrayPairIterator(this.auxIntArr, this.lgConfigK);
    }

    @Override
    public int getLgAuxArrInts() {
        return this.lgAuxArrInts;
    }

    @Override
    public int getUpdatableSizeBytes() {
        return 4 << this.lgAuxArrInts;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public boolean isOffHeap() {
        return false;
    }

    @Override
    public void mustAdd(int slotNo, int value) {
        int index = HeapAuxHashMap.find(this.auxIntArr, this.lgAuxArrInts, this.lgConfigK, slotNo);
        int pair = HllUtil.pair(slotNo, value);
        if (index >= 0) {
            String pairStr = HllUtil.pairString(pair);
            throw new SketchesStateException("Found a slotNo that should not be there: " + pairStr);
        }
        this.auxIntArr[index ^ 0xFFFFFFFF] = pair;
        ++this.auxCount;
        this.checkGrow();
    }

    @Override
    public int mustFindValueFor(int slotNo) {
        int index = HeapAuxHashMap.find(this.auxIntArr, this.lgAuxArrInts, this.lgConfigK, slotNo);
        if (index >= 0) {
            return HllUtil.getPairValue(this.auxIntArr[index]);
        }
        throw new SketchesStateException("SlotNo not found: " + slotNo);
    }

    @Override
    public void mustReplace(int slotNo, int value) {
        int idx = HeapAuxHashMap.find(this.auxIntArr, this.lgAuxArrInts, this.lgConfigK, slotNo);
        if (idx >= 0) {
            this.auxIntArr[idx] = HllUtil.pair(slotNo, value);
            return;
        }
        String pairStr = HllUtil.pairString(HllUtil.pair(slotNo, value));
        throw new SketchesStateException("Pair not found: " + pairStr);
    }

    private static final int find(int[] auxArr, int lgAuxArrInts, int lgConfigK, int slotNo) {
        int stride;
        int probe;
        assert (lgAuxArrInts < lgConfigK);
        int auxArrMask = (1 << lgAuxArrInts) - 1;
        int configKmask = (1 << lgConfigK) - 1;
        int loopIndex = probe = slotNo & auxArrMask;
        do {
            int arrVal;
            if ((arrVal = auxArr[probe]) == 0) {
                return ~probe;
            }
            if (slotNo != (arrVal & configKmask)) continue;
            return probe;
        } while ((probe = probe + (stride = slotNo >>> lgAuxArrInts | 1) & auxArrMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    private void checkGrow() {
        if (4 * this.auxCount > 3 * this.auxIntArr.length) {
            this.growAuxSpace();
        }
    }

    private void growAuxSpace() {
        int[] oldArray = this.auxIntArr;
        int configKmask = (1 << this.lgConfigK) - 1;
        this.auxIntArr = new int[1 << ++this.lgAuxArrInts];
        for (int i = 0; i < oldArray.length; ++i) {
            int fetched = oldArray[i];
            if (fetched == 0) continue;
            int idx = HeapAuxHashMap.find(this.auxIntArr, this.lgAuxArrInts, this.lgConfigK, fetched & configKmask);
            this.auxIntArr[idx ^ 0xFFFFFFFF] = fetched;
        }
    }
}

