/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index.bitmap;

import org.apache.hadoop.hive.ql.index.bitmap.BitmapQuery;

public class BitmapOuterQuery
implements BitmapQuery {
    private String alias;
    private BitmapQuery lhs;
    private BitmapQuery rhs;
    private String queryStr;

    public BitmapOuterQuery(String alias, BitmapQuery lhs, BitmapQuery rhs) {
        this.alias = alias;
        this.lhs = lhs;
        this.rhs = rhs;
        this.constructQueryStr();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String toString() {
        return this.queryStr;
    }

    private void constructQueryStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("(SELECT ");
        sb.append(this.lhs.getAlias());
        sb.append(".`_bucketname`, ");
        sb.append(this.rhs.getAlias());
        sb.append(".`_offset`, ");
        sb.append("EWAH_BITMAP_AND(");
        sb.append(this.lhs.getAlias());
        sb.append(".`_bitmaps`, ");
        sb.append(this.rhs.getAlias());
        sb.append(".`_bitmaps`) AS `_bitmaps` FROM ");
        sb.append(this.lhs.toString());
        sb.append(" JOIN ");
        sb.append(this.rhs.toString());
        sb.append(" ON ");
        sb.append(this.lhs.getAlias());
        sb.append(".`_bucketname` = ");
        sb.append(this.rhs.getAlias());
        sb.append(".`_bucketname` AND ");
        sb.append(this.lhs.getAlias());
        sb.append(".`_offset` = ");
        sb.append(this.rhs.getAlias());
        sb.append(".`_offset`) ");
        sb.append(this.alias);
        this.queryStr = sb.toString();
    }
}

