/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.expressions;

import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.connector.expressions.ApplyTransform;
import org.apache.spark.sql.connector.expressions.BucketTransform;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.DaysTransform;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.MonthsTransform;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.SortValue;
import org.apache.spark.sql.connector.expressions.SortedBucketTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.expressions.YearsTransform;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.util.ArrayImplicits$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class LogicalExpressions$ {
    public static final LogicalExpressions$ MODULE$ = new LogicalExpressions$();

    public <T> LiteralValue<T> literal(T value) {
        Literal internalLit = Literal$.MODULE$.apply(value);
        return this.literal(value, internalLit.dataType());
    }

    public <T> LiteralValue<T> literal(T value, DataType dataType) {
        return new LiteralValue<T>(value, dataType);
    }

    public NamedReference parseReference(String name) {
        return new FieldReference(CatalystSqlParser$.MODULE$.parseMultipartIdentifier(name));
    }

    public NamedReference reference(Seq<String> nameParts) {
        return new FieldReference(nameParts);
    }

    public Transform apply(String name, Seq<Expression> arguments) {
        return new ApplyTransform(name, arguments);
    }

    public BucketTransform bucket(int numBuckets, NamedReference[] references2) {
        return new BucketTransform(this.literal(BoxesRunTime.boxToInteger((int)numBuckets), (DataType)IntegerType$.MODULE$), (Seq<NamedReference>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)references2).toImmutableArraySeq());
    }

    public SortedBucketTransform bucket(int numBuckets, NamedReference[] references2, NamedReference[] sortedCols) {
        return new SortedBucketTransform(this.literal(BoxesRunTime.boxToInteger((int)numBuckets), (DataType)IntegerType$.MODULE$), (Seq<NamedReference>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)references2).toImmutableArraySeq(), (Seq<NamedReference>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)sortedCols).toImmutableArraySeq());
    }

    public ClusterByTransform clusterBy(NamedReference[] references2) {
        return new ClusterByTransform((Seq<NamedReference>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)references2).toImmutableArraySeq());
    }

    public IdentityTransform identity(NamedReference reference) {
        return new IdentityTransform(reference);
    }

    public YearsTransform years(NamedReference reference) {
        return new YearsTransform(reference);
    }

    public MonthsTransform months(NamedReference reference) {
        return new MonthsTransform(reference);
    }

    public DaysTransform days(NamedReference reference) {
        return new DaysTransform(reference);
    }

    public HoursTransform hours(NamedReference reference) {
        return new HoursTransform(reference);
    }

    public SortOrder sort(Expression reference, SortDirection direction, NullOrdering nullOrdering) {
        return new SortValue(reference, direction, nullOrdering);
    }

    private LogicalExpressions$() {
    }
}

