/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.ResolvedPartitionSpec;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ToPrettyString;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.LeafExecNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.ShowTablePartitionExec$;
import org.apache.spark.sql.execution.datasources.v2.V2CommandExec;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LinkedHashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0012$\u0001JB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t5\u0002\u0011\t\u0012)A\u0005\u001f\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005e\u0001\tE\t\u0015!\u0003^\u0011!)\u0007A!f\u0001\n\u00031\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B4\t\u0011-\u0004!Q3A\u0005\u00021D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006I!\u001c\u0005\tc\u0002\u0011)\u001a!C\u0001e\"A\u0011\u0010\u0001B\tB\u0003%1\u000fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\u0006\u0001!\t&a\u0002\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0001\u0003\u0003B\u0011\"a\u0016\u0001#\u0003%\t!!\u0017\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005}\u0003\"CA2\u0001E\u0005I\u0011AA3\u0011%\tI\u0007AI\u0001\n\u0003\tY\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r!I\u0011\u0011\u0011\u0001\u0002\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C\u0001\u0003\u001bC\u0011\"!'\u0001\u0003\u0003%\t%a'\t\u0013\u0005%\u0006!!A\u0005\u0002\u0005-\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u0011%\tY\fAA\u0001\n\u0003\nilB\u0005\u0002B\u000e\n\t\u0011#\u0001\u0002D\u001aA!eIA\u0001\u0012\u0003\t)\r\u0003\u0004{9\u0011\u0005\u0011Q\u001c\u0005\n\u0003?d\u0012\u0011!C#\u0003CD\u0011\"a9\u001d\u0003\u0003%\t)!:\t\u0013\u0005EH$!A\u0005\u0002\u0006M\b\"\u0003B\u00039\u0005\u0005I\u0011\u0002B\u0004\u0005Y\u0019\u0006n\\<UC\ndW\rU1si&$\u0018n\u001c8Fq\u0016\u001c'B\u0001\u0013&\u0003\t1(G\u0003\u0002'O\u0005YA-\u0019;bg>,(oY3t\u0015\tA\u0013&A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!fK\u0001\u0004gFd'B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M)\u0001aM\u001c<\u0003B\u0011A'N\u0007\u0002G%\u0011ag\t\u0002\u000e-J\u001au.\\7b]\u0012,\u00050Z2\u0011\u0005aJT\"A\u0014\n\u0005i:#\u0001\u0004'fC\u001a,\u00050Z2O_\u0012,\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0005*s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019\u000b\u0014A\u0002\u001fs_>$h(C\u0001?\u0013\tIU(A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%\u0001D*fe&\fG.\u001b>bE2,'BA%>\u0003\u0019yW\u000f\u001e9viV\tq\nE\u0002C!JK!!\u0015'\u0003\u0007M+\u0017\u000f\u0005\u0002T16\tAK\u0003\u0002V-\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t9\u0016&\u0001\u0005dCR\fG._:u\u0013\tIFKA\u0005BiR\u0014\u0018NY;uK\u00069q.\u001e;qkR\u0004\u0013aB2bi\u0006dwnZ\u000b\u0002;B\u0011aLY\u0007\u0002?*\u00111\f\u0019\u0006\u0003C&\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005\r|&\u0001\u0004+bE2,7)\u0019;bY><\u0017\u0001C2bi\u0006dwn\u001a\u0011\u0002\u0017Q\f'\r\\3J]\u0012,g\u000e^\u000b\u0002OB\u0011a\f[\u0005\u0003S~\u0013!\"\u00133f]RLg-[3s\u00031!\u0018M\u00197f\u0013:$WM\u001c;!\u0003\u0015!\u0018M\u00197f+\u0005i\u0007C\u00010o\u0013\tywLA\u000eTkB\u0004xN\u001d;t!\u0006\u0014H/\u001b;j_:l\u0015M\\1hK6,g\u000e^\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0002\u0011A\f'\u000f^*qK\u000e,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mZ\u000b\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003qV\u0014QCU3t_24X\r\u001a)beRLG/[8o'B,7-A\u0005qCJ$8\u000b]3dA\u00051A(\u001b8jiz\"\u0002\u0002`?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0003i\u0001AQ!T\u0006A\u0002=CQaW\u0006A\u0002uCQ!Z\u0006A\u0002\u001dDQa[\u0006A\u00025DQ!]\u0006A\u0002M\f1A];o)\t\tI\u0001\u0005\u0003C!\u0006-\u0001\u0003BA\u0007\u0003\u001fi\u0011AV\u0005\u0004\u0003#1&aC%oi\u0016\u0014h.\u00197S_^\f\u0001dZ3u)\u0006\u0014G.\u001a)beRLG/[8o\t\u0016$\u0018-\u001b7t)!\t9\"a\n\u0002,\u0005=\u0002\u0003BA\r\u0003CqA!a\u0007\u0002\u001eA\u0011A)P\u0005\u0004\u0003?i\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0005\u0015\"AB*ue&twMC\u0002\u0002 uBa!!\u000b\u000e\u0001\u00049\u0017A\u0003;bE2,\u0017\nZ3oi\"1\u0011QF\u0007A\u00025\fa\u0002]1si&$\u0018n\u001c8UC\ndW\rC\u0003r\u001b\u0001\u00071/\u0001\u0003d_BLHc\u0003?\u00026\u0005]\u0012\u0011HA\u001e\u0003{Aq!\u0014\b\u0011\u0002\u0003\u0007q\nC\u0004\\\u001dA\u0005\t\u0019A/\t\u000f\u0015t\u0001\u0013!a\u0001O\"91N\u0004I\u0001\u0002\u0004i\u0007bB9\u000f!\u0003\u0005\ra]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019EK\u0002P\u0003\u000bZ#!a\u0012\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#j\u0014AC1o]>$\u0018\r^5p]&!\u0011QKA&\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYFK\u0002^\u0003\u000b\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002b)\u001aq-!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\r\u0016\u0004[\u0006\u0015\u0013AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003[R3a]A#\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000f\t\u0005\u0003k\ny(\u0004\u0002\u0002x)!\u0011\u0011PA>\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0014\u0001\u00026bm\u0006LA!a\t\u0002x\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0011\t\u0004y\u0005\u001d\u0015bAAE{\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qRAK!\ra\u0014\u0011S\u0005\u0004\u0003'k$aA!os\"I\u0011q\u0013\f\u0002\u0002\u0003\u0007\u0011QQ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0005CBAP\u0003K\u000by)\u0004\u0002\u0002\"*\u0019\u00111U\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0006\u0005&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!,\u00024B\u0019A(a,\n\u0007\u0005EVHA\u0004C_>dW-\u00198\t\u0013\u0005]\u0005$!AA\u0002\u0005=\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u001d\u0002:\"I\u0011qS\r\u0002\u0002\u0003\u0007\u0011QQ\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u0016q\u0018\u0005\n\u0003/S\u0012\u0011!a\u0001\u0003\u001f\u000bac\u00155poR\u000b'\r\\3QCJ$\u0018\u000e^5p]\u0016CXm\u0019\t\u0003iq\u0019R\u0001HAd\u0003'\u0004\"\"!3\u0002P>kv-\\:}\u001b\t\tYMC\u0002\u0002Nv\nqA];oi&lW-\u0003\u0003\u0002R\u0006-'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8okA!\u0011Q[An\u001b\t\t9N\u0003\u0003\u0002Z\u0006m\u0014AA5p\u0013\rY\u0015q\u001b\u000b\u0003\u0003\u0007\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\nQ!\u00199qYf$2\u0002`At\u0003S\fY/!<\u0002p\")Qj\ba\u0001\u001f\")1l\ba\u0001;\")Qm\ba\u0001O\")1n\ba\u0001[\")\u0011o\ba\u0001g\u00069QO\\1qa2LH\u0003BA{\u0005\u0003\u0001R\u0001PA|\u0003wL1!!?>\u0005\u0019y\u0005\u000f^5p]BAA(!@P;\u001el7/C\u0002\u0002\u0000v\u0012a\u0001V;qY\u0016,\u0004\u0002\u0003B\u0002A\u0005\u0005\t\u0019\u0001?\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\nA!\u0011Q\u000fB\u0006\u0013\u0011\u0011i!a\u001e\u0003\r=\u0013'.Z2u\u0001")
public class ShowTablePartitionExec
extends V2CommandExec
implements LeafExecNode {
    private final Seq<Attribute> output;
    private final TableCatalog catalog;
    private final Identifier tableIndent;
    private final SupportsPartitionManagement table;
    private final ResolvedPartitionSpec partSpec;

    public static Option<Tuple5<Seq<Attribute>, TableCatalog, Identifier, SupportsPartitionManagement, ResolvedPartitionSpec>> unapply(ShowTablePartitionExec x$0) {
        return ShowTablePartitionExec$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple5<Seq<Attribute>, TableCatalog, Identifier, SupportsPartitionManagement, ResolvedPartitionSpec>, ShowTablePartitionExec> tupled() {
        return ShowTablePartitionExec$.MODULE$.tupled();
    }

    public static Function1<Seq<Attribute>, Function1<TableCatalog, Function1<Identifier, Function1<SupportsPartitionManagement, Function1<ResolvedPartitionSpec, ShowTablePartitionExec>>>>> curried() {
        return ShowTablePartitionExec$.MODULE$.curried();
    }

    @Override
    public AttributeSet producedAttributes() {
        return LeafExecNode.producedAttributes$(this);
    }

    @Override
    public String verboseStringWithOperatorId() {
        return LeafExecNode.verboseStringWithOperatorId$(this);
    }

    public final Seq<SparkPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public TableCatalog catalog() {
        return this.catalog;
    }

    public Identifier tableIndent() {
        return this.tableIndent;
    }

    public SupportsPartitionManagement table() {
        return this.table;
    }

    public ResolvedPartitionSpec partSpec() {
        return this.partSpec;
    }

    @Override
    public Seq<InternalRow> run() {
        ArrayBuffer rows = new ArrayBuffer();
        String information = this.getTablePartitionDetails(this.tableIndent(), this.table(), this.partSpec());
        rows.$plus$eq((Object)this.toCatalystRow((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CatalogV2Implicits$.MODULE$.NamespaceHelper(this.tableIndent().namespace()).quoted(), this.tableIndent().name(), BoxesRunTime.boxToBoolean((boolean)false), information + "\n"})));
        return rows.toSeq();
    }

    private String getTablePartitionDetails(Identifier tableIdent, SupportsPartitionManagement partitionTable, ResolvedPartitionSpec partSpec) {
        LinkedHashMap results = new LinkedHashMap();
        StructType partitionSchema = partitionTable.partitionSchema();
        Tuple2 tuple2 = new Tuple2((Object)partSpec.names(), (Object)partSpec.ident());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq names = (Seq)tuple2._1();
        InternalRow ident = (InternalRow)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)names, (Object)ident);
        Seq names2 = (Seq)tuple22._1();
        InternalRow ident2 = (InternalRow)tuple22._2();
        InternalRow[] partitionIdentifiers = partitionTable.listPartitionIdentifiers((String[])names2.toArray(ClassTag$.MODULE$.apply(String.class)), ident2);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])partitionIdentifiers))) {
            throw QueryCompilationErrors$.MODULE$.notExistPartitionError(tableIdent, ident2, partitionSchema);
        }
        Predef$.MODULE$.assert(partitionIdentifiers.length == 1);
        InternalRow row = (InternalRow)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])partitionIdentifiers));
        int len = partitionSchema.length();
        String[] partitions = new String[len];
        String timeZoneId = this.conf().sessionLocalTimeZone();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            DataType dataType = partitionSchema.apply(i).dataType();
            Object partValueUTF8String = new ToPrettyString((Expression)new Literal(row.get(i, dataType), dataType), (Option)new Some((Object)timeZoneId)).eval(null);
            String partValueStr = partValueUTF8String == null ? "null" : partValueUTF8String.toString();
            partitions$1[i] = ExternalCatalogUtils$.MODULE$.escapePathName(partitionSchema.apply(i).name()) + "=" + ExternalCatalogUtils$.MODULE$.escapePathName(partValueStr);
        });
        String partitionValues = Predef$.MODULE$.wrapRefArray((Object[])partitions).mkString("[", ", ", "]");
        results.put((Object)"Partition Values", (Object)String.valueOf(partitionValues));
        Map metadata = partitionTable.loadPartitionMetadata(ident2);
        if (!metadata.isEmpty()) {
            String metadataValues = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(metadata).asScala().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (value.isEmpty()) {
                        return key;
                    }
                    return key + ": " + value;
                }
                throw new MatchError((Object)tuple2);
            })).mkString("{", ", ", "}");
            v0 = results.put((Object)"Partition Parameters", (Object)metadataValues);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return ((IterableOnceOps)results.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (value.isEmpty()) {
                    return key;
                }
                return key + ": " + value;
            }
            throw new MatchError((Object)tuple2);
        })).mkString("", "\n", "");
    }

    public ShowTablePartitionExec copy(Seq<Attribute> output, TableCatalog catalog, Identifier tableIndent, SupportsPartitionManagement table, ResolvedPartitionSpec partSpec) {
        return new ShowTablePartitionExec(output, catalog, tableIndent, table, partSpec);
    }

    public Seq<Attribute> copy$default$1() {
        return this.output();
    }

    public TableCatalog copy$default$2() {
        return this.catalog();
    }

    public Identifier copy$default$3() {
        return this.tableIndent();
    }

    public SupportsPartitionManagement copy$default$4() {
        return this.table();
    }

    public ResolvedPartitionSpec copy$default$5() {
        return this.partSpec();
    }

    public String productPrefix() {
        return "ShowTablePartitionExec";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.output();
            }
            case 1: {
                return this.catalog();
            }
            case 2: {
                return this.tableIndent();
            }
            case 3: {
                return this.table();
            }
            case 4: {
                return this.partSpec();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShowTablePartitionExec;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "output";
            }
            case 1: {
                return "catalog";
            }
            case 2: {
                return "tableIndent";
            }
            case 3: {
                return "table";
            }
            case 4: {
                return "partSpec";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShowTablePartitionExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShowTablePartitionExec showTablePartitionExec = (ShowTablePartitionExec)x$1;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = showTablePartitionExec.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        TableCatalog tableCatalog = this.catalog();
        TableCatalog tableCatalog2 = showTablePartitionExec.catalog();
        if (tableCatalog == null) {
            if (tableCatalog2 != null) {
                return false;
            }
        } else if (!tableCatalog.equals(tableCatalog2)) return false;
        Identifier identifier = this.tableIndent();
        Identifier identifier2 = showTablePartitionExec.tableIndent();
        if (identifier == null) {
            if (identifier2 != null) {
                return false;
            }
        } else if (!identifier.equals(identifier2)) return false;
        SupportsPartitionManagement supportsPartitionManagement = this.table();
        SupportsPartitionManagement supportsPartitionManagement2 = showTablePartitionExec.table();
        if (supportsPartitionManagement == null) {
            if (supportsPartitionManagement2 != null) {
                return false;
            }
        } else if (!supportsPartitionManagement.equals(supportsPartitionManagement2)) return false;
        ResolvedPartitionSpec resolvedPartitionSpec = this.partSpec();
        ResolvedPartitionSpec resolvedPartitionSpec2 = showTablePartitionExec.partSpec();
        if (resolvedPartitionSpec == null) {
            if (resolvedPartitionSpec2 != null) {
                return false;
            }
        } else if (!resolvedPartitionSpec.equals(resolvedPartitionSpec2)) return false;
        if (!showTablePartitionExec.canEqual(this)) return false;
        return true;
    }

    public ShowTablePartitionExec(Seq<Attribute> output, TableCatalog catalog, Identifier tableIndent, SupportsPartitionManagement table, ResolvedPartitionSpec partSpec) {
        this.output = output;
        this.catalog = catalog;
        this.tableIndent = tableIndent;
        this.table = table;
        this.partSpec = partSpec;
        LeafLike.$init$((LeafLike)this);
        LeafExecNode.$init$(this);
    }
}

