/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;

abstract class StorageDescriptorBuilder<T> {
    private static final String SERDE_LIB = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private static final String INPUT_FORMAT = "org.apache.hadoop.hive.ql.io.HiveInputFormat";
    private static final String OUTPUT_FORMAT = "org.apache.hadoop.hive.ql.io.HiveOutputFormat";
    private String location;
    private String inputFormat = "org.apache.hadoop.hive.ql.io.HiveInputFormat";
    private String outputFormat = "org.apache.hadoop.hive.ql.io.HiveOutputFormat";
    private String serdeName;
    private String serdeLib = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private List<FieldSchema> cols;
    private int numBuckets = 0;
    private Map<String, String> storageDescriptorParams = new HashMap<String, String>();
    private Map<String, String> serdeParams = new HashMap<String, String>();
    private boolean compressed = false;
    private boolean storedAsSubDirectories;
    private List<String> bucketCols = new ArrayList<String>();
    private List<String> skewedColNames;
    private List<Order> sortCols = new ArrayList<Order>();
    private List<List<String>> skewedColValues;
    private Map<List<String>, String> skewedColValueLocationMaps;
    private T child;

    protected StorageDescriptorBuilder() {
        this.skewedColNames = new ArrayList<String>();
        this.skewedColValues = new ArrayList<List<String>>();
        this.skewedColValueLocationMaps = new HashMap<List<String>, String>();
    }

    protected StorageDescriptor buildSd() throws MetaException {
        if (this.cols == null) {
            throw new MetaException("You must provide the columns");
        }
        SerDeInfo serdeInfo = new SerDeInfo(this.serdeName, this.serdeLib, this.serdeParams);
        StorageDescriptor sd = new StorageDescriptor(this.cols, this.location, this.inputFormat, this.outputFormat, this.compressed, this.numBuckets, serdeInfo, this.bucketCols, this.sortCols, this.storageDescriptorParams);
        sd.setStoredAsSubDirectories(this.storedAsSubDirectories);
        if (this.skewedColNames != null) {
            SkewedInfo skewed = new SkewedInfo(this.skewedColNames, this.skewedColValues, this.skewedColValueLocationMaps);
            sd.setSkewedInfo(skewed);
        }
        return sd;
    }

    protected void setChild(T child) {
        this.child = child;
    }

    public T setLocation(String location) {
        this.location = location;
        return this.child;
    }

    public T setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
        return this.child;
    }

    public T setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        return this.child;
    }

    public T setSerdeName(String serdeName) {
        this.serdeName = serdeName;
        return this.child;
    }

    public T setSerdeLib(String serdeLib) {
        this.serdeLib = serdeLib;
        return this.child;
    }

    public T setCols(List<FieldSchema> cols) {
        this.cols = cols;
        return this.child;
    }

    public T addCol(String name, String type, String comment) {
        if (this.cols == null) {
            this.cols = new ArrayList<FieldSchema>();
        }
        this.cols.add(new FieldSchema(name, type, comment));
        return this.child;
    }

    public T addCol(String name, String type) {
        return this.addCol(name, type, "");
    }

    public T setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
        return this.child;
    }

    public T setStorageDescriptorParams(Map<String, String> storageDescriptorParams) {
        this.storageDescriptorParams = storageDescriptorParams;
        return this.child;
    }

    public T addStorageDescriptorParam(String key, String value) {
        if (this.storageDescriptorParams == null) {
            this.storageDescriptorParams = new HashMap<String, String>();
        }
        this.storageDescriptorParams.put(key, value);
        return this.child;
    }

    public T setSerdeParams(Map<String, String> serdeParams) {
        this.serdeParams = serdeParams;
        return this.child;
    }

    public T addSerdeParam(String key, String value) {
        if (this.serdeParams == null) {
            this.serdeParams = new HashMap<String, String>();
        }
        this.serdeParams.put(key, value);
        return this.child;
    }

    public T setCompressed(boolean compressed) {
        this.compressed = compressed;
        return this.child;
    }

    public T setStoredAsSubDirectories(boolean storedAsSubDirectories) {
        this.storedAsSubDirectories = storedAsSubDirectories;
        return this.child;
    }

    public T setBucketCols(List<String> bucketCols) {
        this.bucketCols = bucketCols;
        return this.child;
    }

    public T addBucketCol(String bucketCol) {
        if (this.bucketCols == null) {
            this.bucketCols = new ArrayList<String>();
        }
        this.bucketCols.add(bucketCol);
        return this.child;
    }

    public T setSkewedColNames(List<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
        return this.child;
    }

    public T addSkewedColName(String skewedColName) {
        if (this.skewedColNames == null) {
            this.skewedColNames = new ArrayList<String>();
        }
        this.skewedColNames.add(skewedColName);
        return this.child;
    }

    public T setSortCols(List<Order> sortCols) {
        this.sortCols = sortCols;
        return this.child;
    }

    public T addSortCol(String col, int order) {
        if (this.sortCols == null) {
            this.sortCols = new ArrayList<Order>();
        }
        this.sortCols.add(new Order(col, order));
        return this.child;
    }

    public T setSkewedColValues(List<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
        return this.child;
    }

    public T setSkewedColValueLocationMaps(Map<List<String>, String> skewedColValueLocationMaps) {
        this.skewedColValueLocationMaps = skewedColValueLocationMaps;
        return this.child;
    }
}

