/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.internal;

import java.util.concurrent.Executor;
import org.sparkproject.connect.grpc.CallOptions;
import org.sparkproject.connect.grpc.ClientStreamTracer;
import org.sparkproject.connect.grpc.InternalChannelz;
import org.sparkproject.connect.grpc.InternalLogId;
import org.sparkproject.connect.grpc.Metadata;
import org.sparkproject.connect.grpc.MethodDescriptor;
import org.sparkproject.connect.grpc.Status;
import org.sparkproject.connect.grpc.internal.ClientStream;
import org.sparkproject.connect.grpc.internal.ClientStreamListener;
import org.sparkproject.connect.grpc.internal.ClientTransport;
import org.sparkproject.connect.grpc.internal.FailingClientStream;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.util.concurrent.ListenableFuture;
import org.sparkproject.guava.util.concurrent.SettableFuture;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error);
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

