/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterCharColumnBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private byte[] left;
    private byte[] right;

    public FilterCharColumnBetween(int colNum, HiveChar left, HiveChar right) {
        this.colNum = colNum;
        this.left = left.getStrippedValue().getBytes();
        this.right = right.getStrippedValue().getBytes();
    }

    public FilterCharColumnBetween() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] length = inputColVector.length;
        int[] start = inputColVector.start;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (StringExpr.compare((byte[])vector[0], (int)start[0], (int)length[0], (byte[])this.left, (int)0, (int)this.left.length) < 0 || StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])vector[0], (int)start[0], (int)length[0]) < 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (StringExpr.compare((byte[])this.left, (int)0, (int)this.left.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0 || StringExpr.compare((byte[])vector[i], (int)start[i], (int)length[i], (byte[])this.right, (int)0, (int)this.right.length) > 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (StringExpr.compare((byte[])this.left, (int)0, (int)this.left.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0 || StringExpr.compare((byte[])vector[i], (int)start[i], (int)length[i], (byte[])this.right, (int)0, (int)this.right.length) > 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (StringExpr.compare((byte[])vector[0], (int)start[0], (int)length[0], (byte[])this.left, (int)0, (int)this.left.length) < 0 || StringExpr.compare((byte[])this.right, (int)0, (int)this.right.length, (byte[])vector[0], (int)start[0], (int)length[0]) < 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || StringExpr.compare((byte[])this.left, (int)0, (int)this.left.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0 || StringExpr.compare((byte[])vector[i], (int)start[i], (int)length[i], (byte[])this.right, (int)0, (int)this.right.length) > 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || StringExpr.compare((byte[])this.left, (int)0, (int)this.left.length, (byte[])vector[i], (int)start[i], (int)length[i]) > 0 || StringExpr.compare((byte[])vector[i], (int)start[i], (int)length[i], (byte[])this.right, (int)0, (int)this.right.length) > 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public byte[] getLeftValue() {
        return this.left;
    }

    public void setLeftValue(byte[] value) {
        this.left = value;
    }

    public byte[] getRightValue() {
        return this.right;
    }

    public void setRightValue(byte[] value) {
        this.right = value;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", left " + FilterCharColumnBetween.displayUtf8Bytes(this.left) + ", right " + FilterCharColumnBetween.displayUtf8Bytes(this.right);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("Char"), VectorExpressionDescriptor.ArgumentType.getType("Char"), VectorExpressionDescriptor.ArgumentType.getType("Char")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

