/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLength;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;

@Description(name="length", value="_FUNC_(str | binary) - Returns the length of str or number of bytes in binary data", extended="Example:\n  > SELECT _FUNC_('Facebook') FROM src LIMIT 1;\n  8")
@VectorizedExpressions(value={StringLength.class})
public class GenericUDFLength
extends GenericUDF {
    private final IntWritable result = new IntWritable();
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.StringConverter stringConverter;
    private transient PrimitiveObjectInspectorConverter.BinaryConverter binaryConverter;
    private transient boolean isInputString;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("LENGTH requires 1 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("LENGTH only takes primitive types, got " + this.argumentOI.getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        PrimitiveObjectInspector.PrimitiveCategory inputType = this.argumentOI.getPrimitiveCategory();
        WritableIntObjectInspector outputOI = null;
        switch (inputType) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.isInputString = true;
                this.stringConverter = new PrimitiveObjectInspectorConverter.StringConverter(this.argumentOI);
                break;
            }
            case BINARY: {
                this.isInputString = false;
                this.binaryConverter = new PrimitiveObjectInspectorConverter.BinaryConverter(this.argumentOI, (SettableBinaryObjectInspector)PrimitiveObjectInspectorFactory.writableBinaryObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException(" LENGTH() only takes STRING/CHAR/VARCHAR/BINARY types as first argument, got " + inputType);
            }
        }
        outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        byte[] data = null;
        if (this.isInputString) {
            String val = null;
            if (arguments[0] != null) {
                val = (String)this.stringConverter.convert(arguments[0].get());
            }
            if (val == null) {
                return null;
            }
            data = val.getBytes();
            int len = 0;
            for (int i = 0; i < data.length; ++i) {
                if (!GenericUDFUtils.isUtfStartByte(data[i])) continue;
                ++len;
            }
            this.result.set(len);
            return this.result;
        }
        BytesWritable val = null;
        if (arguments[0] != null) {
            val = (BytesWritable)this.binaryConverter.convert(arguments[0].get());
        }
        if (val == null) {
            return null;
        }
        this.result.set(val.getLength());
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("length", children);
    }
}

