/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

@Description(name="struct", value="_FUNC_(col1, col2, col3, ...) - Creates a struct with the given field values")
public class GenericUDFStruct
extends GenericUDF {
    private transient Object[] ret;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int numFields = arguments.length;
        this.ret = new Object[numFields];
        ArrayList<String> fname = new ArrayList<String>(numFields);
        for (int f = 1; f <= numFields; ++f) {
            fname.add("col" + f);
        }
        boolean constantStruct = true;
        for (int i = 0; i < arguments.length; ++i) {
            ObjectInspector oi = arguments[i];
            if (!(constantStruct &= oi.getCategory() == ObjectInspector.Category.PRIMITIVE && oi instanceof ConstantObjectInspector)) continue;
            this.ret[i] = ((ConstantObjectInspector)oi).getWritableConstantValue();
        }
        if (constantStruct) {
            return ObjectInspectorFactory.getStandardConstantStructObjectInspector(fname, Arrays.asList(arguments), Arrays.asList(this.ret));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fname, Arrays.asList(arguments));
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 0; i < arguments.length; ++i) {
            this.ret[i] = arguments[i].get();
        }
        return this.ret;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("struct", children, ",");
    }
}

