/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import coursierapi.shaded.commonscompress.archivers.zip.ZipExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ZipShort;
import java.util.zip.ZipException;

public class ResourceAlignmentExtraField
implements ZipExtraField {
    public static final ZipShort ID = new ZipShort(41246);
    private short alignment;
    private boolean allowMethodChange;
    private int padding;

    @Override
    public byte[] getCentralDirectoryData() {
        return ZipShort.getBytes(this.alignment | (this.allowMethodChange ? 32768 : 0));
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return new ZipShort(2);
    }

    @Override
    public ZipShort getHeaderId() {
        return ID;
    }

    @Override
    public byte[] getLocalFileDataData() {
        byte[] content = new byte[2 + this.padding];
        ZipShort.putShort(this.alignment | (this.allowMethodChange ? 32768 : 0), content, 0);
        return content;
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(2 + this.padding);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] buffer, int offset, int length) throws ZipException {
        if (length < 2) {
            throw new ZipException("Too short content for ResourceAlignmentExtraField (0xa11e): " + length);
        }
        int alignmentValue = ZipShort.getValue(buffer, offset);
        this.alignment = (short)(alignmentValue & Short.MAX_VALUE);
        this.allowMethodChange = (alignmentValue & 0x8000) != 0;
    }

    @Override
    public void parseFromLocalFileData(byte[] buffer, int offset, int length) throws ZipException {
        this.parseFromCentralDirectoryData(buffer, offset, length);
        this.padding = length - 2;
    }
}

