/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.text.deltamerge;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.text.deltamerge.InlineDeltaMergeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class DeltaMergeUtils {
    public static List<AbstractDelta<String>> mergeInlineDeltas(InlineDeltaMergeInfo deltaMergeInfo, Predicate<List<String>> replaceEquality) {
        List<AbstractDelta<String>> originalDeltas = deltaMergeInfo.getDeltas();
        if (originalDeltas.size() < 2) {
            return originalDeltas;
        }
        ArrayList<AbstractDelta<String>> newDeltas = new ArrayList<AbstractDelta<String>>();
        newDeltas.add(originalDeltas.get(0));
        for (int i = 1; i < originalDeltas.size(); ++i) {
            AbstractDelta previousDelta = (AbstractDelta)newDeltas.get(newDeltas.size() - 1);
            AbstractDelta<String> currentDelta = originalDeltas.get(i);
            List<String> equalities = deltaMergeInfo.getOrigList().subList(previousDelta.getSource().getPosition() + previousDelta.getSource().size(), currentDelta.getSource().getPosition());
            if (replaceEquality.test(equalities)) {
                ArrayList<Object> allSourceLines = new ArrayList<Object>();
                allSourceLines.addAll(previousDelta.getSource().getLines());
                allSourceLines.addAll(equalities);
                allSourceLines.addAll(currentDelta.getSource().getLines());
                ArrayList<Object> allTargetLines = new ArrayList<Object>();
                allTargetLines.addAll(previousDelta.getTarget().getLines());
                allTargetLines.addAll(equalities);
                allTargetLines.addAll(currentDelta.getTarget().getLines());
                ChangeDelta replacement = new ChangeDelta(new Chunk(previousDelta.getSource().getPosition(), allSourceLines), new Chunk(previousDelta.getTarget().getPosition(), allTargetLines));
                newDeltas.remove(newDeltas.size() - 1);
                newDeltas.add(replacement);
                continue;
            }
            newDeltas.add(currentDelta);
        }
        return newDeltas;
    }

    private DeltaMergeUtils() {
    }
}

