/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.protocol.Encodable;

public record StreamChunkId(long streamId, int chunkIndex) implements Encodable
{
    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeLong(this.streamId);
        buffer.writeInt(this.chunkIndex);
    }

    public static StreamChunkId decode(ByteBuf buffer) {
        assert (buffer.readableBytes() >= 12);
        long streamId = buffer.readLong();
        int chunkIndex = buffer.readInt();
        return new StreamChunkId(streamId, chunkIndex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.streamId, this.chunkIndex);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof StreamChunkId) {
            StreamChunkId o = (StreamChunkId)other;
            return this.streamId == o.streamId && this.chunkIndex == o.chunkIndex;
        }
        return false;
    }

    @Override
    public String toString() {
        return "StreamChunkId[streamId=" + this.streamId + ",chunkIndex=" + this.chunkIndex + "]";
    }
}

