/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.stream.Collectors;

public enum AvroCompressionCodec {
    UNCOMPRESSED("null", false),
    DEFLATE("deflate", true),
    SNAPPY("snappy", false),
    BZIP2("bzip2", false),
    XZ("xz", true),
    ZSTANDARD("zstandard", true);

    private final String codecName;
    private final boolean supportCompressionLevel;
    private static final EnumMap<AvroCompressionCodec, String> codecNameMap;

    private AvroCompressionCodec(String codecName, boolean supportCompressionLevel) {
        this.codecName = codecName;
        this.supportCompressionLevel = supportCompressionLevel;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public boolean getSupportCompressionLevel() {
        return this.supportCompressionLevel;
    }

    public static AvroCompressionCodec fromString(String s) {
        return AvroCompressionCodec.valueOf(s.toUpperCase(Locale.ROOT));
    }

    public String lowerCaseName() {
        return codecNameMap.get((Object)this);
    }

    static {
        codecNameMap = Arrays.stream(AvroCompressionCodec.values()).collect(Collectors.toMap(codec -> codec, codec -> codec.name().toLowerCase(Locale.ROOT), (oldValue, newValue) -> oldValue, () -> new EnumMap(AvroCompressionCodec.class)));
    }
}

