/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalVariantType$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.DirectCopyColumnType;
import org.apache.spark.unsafe.types.VariantVal;

public final class VARIANT$
extends ColumnType<VariantVal>
implements DirectCopyColumnType<VariantVal> {
    public static final VARIANT$ MODULE$ = new VARIANT$();

    static {
        DirectCopyColumnType.$init$(MODULE$);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$execution$columnar$DirectCopyColumnType$$super$append(InternalRow row, int ordinal, ByteBuffer buffer) {
        super.append(row, ordinal, buffer);
    }

    @Override
    public void extract(ByteBuffer buffer, InternalRow row, int ordinal) {
        DirectCopyColumnType.extract$(this, buffer, row, ordinal);
    }

    @Override
    public void append(InternalRow row, int ordinal, ByteBuffer buffer) {
        DirectCopyColumnType.append$(this, row, ordinal, buffer);
    }

    @Override
    public PhysicalDataType dataType() {
        return PhysicalVariantType$.MODULE$;
    }

    @Override
    public int defaultSize() {
        return 2048;
    }

    @Override
    public int actualSize(InternalRow row, int ordinal) {
        VariantVal v = this.getField(row, ordinal);
        return 8 + v.getValue().length + v.getMetadata().length;
    }

    @Override
    public VariantVal getField(InternalRow row, int ordinal) {
        return row.getVariant(ordinal);
    }

    @Override
    public void setField(InternalRow row, int ordinal, VariantVal value) {
        row.update(ordinal, (Object)value);
    }

    @Override
    public void append(VariantVal v, ByteBuffer buffer) {
        int valueSize = v.getValue().length;
        int metadataSize = v.getMetadata().length;
        ByteBufferHelper$.MODULE$.putInt(buffer, valueSize);
        ByteBufferHelper$.MODULE$.putInt(buffer, metadataSize);
        ByteBufferHelper$.MODULE$.copyMemory(ByteBuffer.wrap(v.getValue()), buffer, valueSize);
        ByteBufferHelper$.MODULE$.copyMemory(ByteBuffer.wrap(v.getMetadata()), buffer, metadataSize);
    }

    @Override
    public VariantVal extract(ByteBuffer buffer) {
        int valueSize = ByteBufferHelper$.MODULE$.getInt(buffer);
        int metadataSize = ByteBufferHelper$.MODULE$.getInt(buffer);
        ByteBuffer valueBuffer = ByteBuffer.allocate(valueSize);
        ByteBufferHelper$.MODULE$.copyMemory(buffer, valueBuffer, valueSize);
        ByteBuffer metadataBuffer = ByteBuffer.allocate(metadataSize);
        ByteBufferHelper$.MODULE$.copyMemory(buffer, metadataBuffer, metadataSize);
        return new VariantVal(valueBuffer.array(), metadataBuffer.array());
    }

    private VARIANT$() {
    }
}

