/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JsonInferSchema;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TextInputJsonDataSource$
extends JsonDataSource {
    public static final TextInputJsonDataSource$ MODULE$ = new TextInputJsonDataSource$();
    private static final boolean isSplitable = true;

    @Override
    public boolean isSplitable() {
        return isSplitable;
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        Dataset<String> json = this.createBaseDataset(sparkSession, inputPaths, parsedOptions);
        return this.inferFromDataset(json, parsedOptions);
    }

    public StructType inferFromDataset(Dataset<String> json, JSONOptions parsedOptions) {
        org.apache.spark.sql.classic.Dataset<String> sampled = JsonUtils$.MODULE$.sample(ClassicConversions$.MODULE$.castToImpl(json), parsedOptions);
        RDD<InternalRow> rdd = sampled.queryExecution().toRdd();
        Function2 rowParser = (Function2)parsedOptions.encoding().map((Function1 & Serializable)enc -> (Function2 & Serializable)(x$1, x$2) -> CreateJacksonParser$.MODULE$.internalRow(enc, x$1, x$2)).getOrElse((Function0 & Serializable)() -> (Function2 & Serializable)(x$3, x$4) -> CreateJacksonParser$.MODULE$.internalRow(x$3, x$4));
        return (StructType)SQLExecution$.MODULE$.withSQLConfPropagated(ClassicConversions$.MODULE$.castToImpl(json.sparkSession()), (Function0 & Serializable)() -> {
            JsonInferSchema qual$1 = new JsonInferSchema(parsedOptions);
            RDD x$1 = rdd;
            Function2 x$2 = rowParser;
            boolean x$3 = qual$1.infer$default$3();
            return qual$1.infer(x$1, x$2, x$3);
        });
    }

    private Dataset<String> createBaseDataset(SparkSession sparkSession, Seq<FileStatus> inputPaths, JSONOptions parsedOptions) {
        SparkSession x$1 = sparkSession;
        Seq x$2 = (Seq)inputPaths.map((Function1 & Serializable)x$5 -> x$5.getPath().toString());
        String x$3 = TextFileFormat.class.getName();
        CaseInsensitiveMap x$4 = parsedOptions.parameters().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSource$.MODULE$.GLOB_PATHS_KEY()), (Object)"false")})));
        Option<StructType> x$52 = DataSource$.MODULE$.apply$default$4();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$3, (Seq<String>)x$2, x$52, x$6, x$7, (Map<String, String>)x$4, x$8);
        boolean x$9 = false;
        boolean x$10 = qual$1.resolveRelation$default$2();
        return sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(false, x$10)).select("value", (Seq)Nil$.MODULE$).as(Encoders$.MODULE$.STRING());
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, JacksonParser parser, StructType schema) {
        HadoopFileLinesReader linesReader = (HadoopFileLinesReader)Utils$.MODULE$.createResourceUninterruptiblyIfInTaskThread((Function0 & Serializable)() -> new HadoopFileLinesReader(file, (Option<byte[]>)parser.options().lineSeparatorInRead(), conf));
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable)x$7 -> {
            linesReader.close();
            return BoxedUnit.UNIT;
        }));
        Function2 textParser = (Function2)parser.options().encoding().map((Function1 & Serializable)enc -> (Function2 & Serializable)(x$8, x$9) -> CreateJacksonParser$.MODULE$.text(enc, x$8, x$9)).getOrElse((Function0 & Serializable)() -> (Function2 & Serializable)(x$10, x$11) -> CreateJacksonParser$.MODULE$.text(x$10, x$11));
        FailureSafeParser safeParser = new FailureSafeParser((Function1 & Serializable)input -> parser.parse(input, textParser, (Function1 & Serializable)value -> MODULE$.textToUTF8String((Text)value)), parser.options().parseMode(), schema, parser.options().columnNameOfCorruptRecord());
        return linesReader.flatMap((Function1 & Serializable)input -> safeParser.parse(input));
    }

    private UTF8String textToUTF8String(Text value) {
        return UTF8String.fromBytes((byte[])value.getBytes(), (int)0, (int)value.getLength());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TextInputJsonDataSource$.class);
    }

    private TextInputJsonDataSource$() {
    }
}

