/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.stat;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.stat.StatFunctions$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class StatFunctions$
implements Logging {
    public static final StatFunctions$ MODULE$ = new StatFunctions$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<Seq<Object>> multipleApproxQuantiles(Dataset<Row> df, Seq<String> cols, Seq<Object> probabilities, double relativeError) {
        Predef$.MODULE$.require(relativeError >= 0.0, (Function0 & Serializable)() -> "Relative Error must be non-negative but got " + relativeError);
        Predef$.MODULE$.require(probabilities.forall((Function1)(JFunction1.mcZD.sp & Serializable)p -> p >= 0.0 && p <= 1.0), (Function0 & Serializable)() -> "percentile should be in the range [0.0, 1.0]");
        Seq columns = (Seq)cols.map((Function1 & Serializable)colName -> {
            NamedExpression field = df.resolve((String)colName);
            Predef$.MODULE$.require(((Expression)field).dataType() instanceof NumericType, (Function0 & Serializable)() -> "Quantile calculation for column " + colName + " with data type " + ((Expression)field).dataType() + " is not supported.");
            return functions$.MODULE$.col(colName).cast((DataType)DoubleType$.MODULE$);
        });
        int accuracy = relativeError == 0.0 ? Integer.MAX_VALUE : (int)scala.math.package$.MODULE$.min(Integer.MAX_VALUE, (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(1.0 / relativeError)));
        Seq[] results = (Seq[])Array$.MODULE$.fill(cols.size(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty(), ClassTag$.MODULE$.apply(Seq.class));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.posexplode(functions$.MODULE$.array(columns)).as((Seq)new .colon.colon((Object)"index", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$)))})).where(functions$.MODULE$.isnull(functions$.MODULE$.col("value")).unary_$bang().$amp$amp((Object)functions$.MODULE$.isnan(functions$.MODULE$.col("value")).unary_$bang())).groupBy("index", (Seq)Nil$.MODULE$).agg(functions$.MODULE$.approx_percentile(functions$.MODULE$.col("value"), functions$.MODULE$.lit(probabilities), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)accuracy))), (Seq)Nil$.MODULE$).collect()), (Function1 & Serializable)row -> {
            StatFunctions$.$anonfun$multipleApproxQuantiles$7(results, row);
            return BoxedUnit.UNIT;
        });
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)results).toImmutableArraySeq();
    }

    public double pearsonCorrelation(Dataset<Row> df, Seq<String> cols) {
        return ((Row)this.calculateCorrImpl(df, cols, this.calculateCorrImpl$default$3()).head()).getDouble(0);
    }

    public Dataset<Row> calculateCorrImpl(Dataset<Row> df, Seq<String> cols, String method) {
        SeqOps seqOps;
        String string = method;
        String string2 = "pearson";
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Currently only the calculation of the Pearson Correlation coefficient is supported.");
        Predef$.MODULE$.require(cols.length() == 2, (Function0 & Serializable)() -> "Currently correlation calculation is supported between two columns.");
        Seq seq = (Seq)cols.map((Function1 & Serializable)c -> {
            DataType dataType = ((Expression)df.resolve((String)c)).dataType();
            Predef$.MODULE$.require(dataType instanceof NumericType, (Function0 & Serializable)() -> "Currently correlation calculation for columns with dataType " + dataType.catalogString() + " not supported.");
            return functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col(c)), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0))).otherwise((Object)functions$.MODULE$.col(c).cast((DataType)DoubleType$.MODULE$));
        });
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new MatchError((Object)seq);
        }
        Column col1 = (Column)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        Column col2 = (Column)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)col1, (Object)col2);
        Column col12 = (Column)tuple2._1();
        Column col22 = (Column)tuple2._2();
        Column correlation = functions$.MODULE$.corr(col12, col22);
        return df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(functions$.MODULE$.isnull(correlation), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)Double.NaN))).otherwise((Object)correlation).as("corr")}));
    }

    public String calculateCorrImpl$default$3() {
        return "pearson";
    }

    public double calculateCov(Dataset<Row> df, Seq<String> cols) {
        return ((Row)this.calculateCovImpl(df, cols).head()).getDouble(0);
    }

    public Dataset<Row> calculateCovImpl(Dataset<Row> df, Seq<String> cols) {
        SeqOps seqOps;
        Predef$.MODULE$.require(cols.length() == 2, (Function0 & Serializable)() -> "Currently covariance calculation is supported between two columns.");
        Seq seq = (Seq)cols.map((Function1 & Serializable)c -> {
            DataType dataType = ((Expression)df.resolve((String)c)).dataType();
            Predef$.MODULE$.require(dataType instanceof NumericType, (Function0 & Serializable)() -> "Currently covariance calculation for columns with dataType " + dataType.catalogString() + " not supported.");
            return functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col(c)), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0))).otherwise((Object)functions$.MODULE$.col(c).cast((DataType)DoubleType$.MODULE$));
        });
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new MatchError((Object)seq);
        }
        Column col1 = (Column)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        Column col2 = (Column)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)col1, (Object)col2);
        Column col12 = (Column)tuple2._1();
        Column col22 = (Column)tuple2._2();
        Column covariance = functions$.MODULE$.covar_samp(col12, col22);
        return df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(functions$.MODULE$.isnull(covariance), (Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0))).otherwise((Object)covariance).as("cov")}));
    }

    public Dataset<Row> crossTabulate(Dataset<Row> df, String col1, String col2) {
        return df.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col(col1)), (Object)"null").otherwise((Object)functions$.MODULE$.col(col1).cast("string")).as(col1 + "_" + col2)})).pivot(functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col(col2)), (Object)"null").otherwise((Object)functions$.MODULE$.regexp_replace(functions$.MODULE$.col(col2).cast("string"), "`", ""))).count().na().fill(0L);
    }

    public Dataset<Row> summary(Dataset<?> ds, Seq<String> statistics) {
        String[] selectedStatistics = statistics.nonEmpty() ? (String[])statistics.toArray(ClassTag$.MODULE$.apply(String.class)) : (String[])((Object[])new String[]{"count", "mean", "stddev", "min", "25%", "50%", "75%", "max"});
        double[] percentiles = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])selectedStatistics), (Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)a.endsWith("%")))), (Function1 & Serializable)p -> BoxesRunTime.boxToDouble((double)StatFunctions$.$anonfun$summary$2(p)), (ClassTag)ClassTag$.MODULE$.Double());
        Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(percentiles), (Function1)(JFunction1.mcZD.sp & Serializable)p -> p >= 0.0 && p <= 1.0), (Function0 & Serializable)() -> "Percentiles must be in the range [0, 1]");
        ObjectRef mapColumns = ObjectRef.create((Object)((Seq)package$.MODULE$.Seq().empty()));
        ObjectRef columnNames = ObjectRef.create((Object)((Seq)package$.MODULE$.Seq().empty()));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ds.schema().fields()), (Function1 & Serializable)field -> {
            StatFunctions$.$anonfun$summary$5(percentiles, selectedStatistics, mapColumns, columnNames, field);
            return BoxedUnit.UNIT;
        });
        if (((Seq)mapColumns.elem).isEmpty()) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_sql_execution_stat_StatFunctions$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_stat_StatFunctions$$typecreator1$1() {
                }
            }
            return ds.sparkSession().createDataFrame((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])selectedStatistics), (Function1 & Serializable)_1 -> new Tuple1(_1), ClassTag$.MODULE$.apply(Tuple1.class))).toImmutableArraySeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_stat_StatFunctions$$typecreator1$1())).withColumnRenamed("_1", "summary");
        }
        Seq valueColumns = (Seq)((Seq)columnNames.elem).map((Function1 & Serializable)columnName -> functions$.MODULE$.element_at(functions$.MODULE$.col(columnName), (Object)functions$.MODULE$.col("summary")).as(columnName));
        return ds.select((Seq)mapColumns.elem).withColumn("summary", functions$.MODULE$.explode(functions$.MODULE$.lit((Object)selectedStatistics))).select((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new Column[]{functions$.MODULE$.col("summary")}), (IterableOnce)valueColumns, ClassTag$.MODULE$.apply(Column.class))).toImmutableArraySeq());
    }

    public static final /* synthetic */ void $anonfun$multipleApproxQuantiles$7(Seq[] results$1, Row row) {
        Seq quantiles;
        int index = row.getInt(0);
        results$1[index] = quantiles = row.getSeq(1);
    }

    public static final /* synthetic */ double $anonfun$summary$2(String p) {
        double d;
        try {
            d = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(p), "%"))) / 100.0;
        }
        catch (NumberFormatException e) {
            throw QueryExecutionErrors$.MODULE$.cannotParseStatisticAsPercentileError(p, e);
        }
        return d;
    }

    public static final /* synthetic */ void $anonfun$summary$6(ObjectRef aggColumns$1, Column column$1, ObjectRef casted$1, Column percentilesCol$1, IntRef percentileIndex$1, String stats) {
        block11: {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.lit((Object)stats));
            String string = stats.toLowerCase(Locale.ROOT);
            switch (string == null ? 0 : string.hashCode()) {
                case -1197226255: {
                    if (!"approx_count_distinct".equals(string)) break;
                    aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.approx_count_distinct(column$1));
                    break block11;
                }
                case -892408046: {
                    if (!"stddev".equals(string)) break;
                    aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.stddev((Column)casted$1.elem));
                    break block11;
                }
                case 107876: {
                    if (!"max".equals(string)) break;
                    aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.max(column$1));
                    break block11;
                }
                case 108114: {
                    if (!"min".equals(string)) break;
                    aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.min(column$1));
                    break block11;
                }
                case 3347397: {
                    if (!"mean".equals(string)) break;
                    aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.avg((Column)casted$1.elem));
                    break block11;
                }
                case 94851343: {
                    if (!"count".equals(string)) break;
                    aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.count(column$1));
                    break block11;
                }
                case 166449196: {
                    if (!"count_distinct".equals(string)) break;
                    aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.count_distinct(column$1, (Seq)Nil$.MODULE$));
                    break block11;
                }
            }
            if (string.endsWith("%")) {
                aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.get(percentilesCol$1, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)percentileIndex$1.elem))));
                ++percentileIndex$1.elem;
            } else {
                throw QueryExecutionErrors$.MODULE$.statisticNotRecognizedError(stats);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$summary$5(double[] percentiles$1, String[] selectedStatistics$1, ObjectRef mapColumns$1, ObjectRef columnNames$1, StructField field) {
        if (field.dataType() instanceof NumericType || field.dataType() instanceof StringType) {
            Column column = functions$.MODULE$.col(field.name());
            ObjectRef casted = ObjectRef.create((Object)column);
            if (field.dataType() instanceof StringType) {
                casted.elem = column.try_cast((DataType)DoubleType$.MODULE$);
            }
            Column percentilesCol = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.doubleArrayOps(percentiles$1)) ? functions$.MODULE$.percentile_approx((Column)casted.elem, functions$.MODULE$.lit((Object)percentiles$1), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY()))) : null;
            ObjectRef aggColumns = ObjectRef.create((Object)((Seq)package$.MODULE$.Seq().empty()));
            IntRef percentileIndex = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])selectedStatistics$1), (Function1 & Serializable)stats -> {
                StatFunctions$.$anonfun$summary$6(aggColumns, column, casted, percentilesCol, percentileIndex, stats);
                return BoxedUnit.UNIT;
            });
            mapColumns$1.elem = (Seq)((Seq)mapColumns$1.elem).$colon$plus((Object)functions$.MODULE$.map((Seq)((Seq)aggColumns.elem).map((Function1 & Serializable)x$3 -> x$3.cast((DataType)StringType$.MODULE$))).as(field.name()));
            columnNames$1.elem = (Seq)((Seq)columnNames$1.elem).$colon$plus((Object)field.name());
            return;
        }
    }

    private StatFunctions$() {
    }
}

