/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

public final class CompactibleFileStreamLog$ {
    public static final CompactibleFileStreamLog$ MODULE$ = new CompactibleFileStreamLog$();
    private static final String COMPACT_FILE_SUFFIX = ".compact";
    private static final int COMPACT_LATENCY_WARN_THRESHOLD_MS = 2000;

    public String COMPACT_FILE_SUFFIX() {
        return COMPACT_FILE_SUFFIX;
    }

    public int COMPACT_LATENCY_WARN_THRESHOLD_MS() {
        return COMPACT_LATENCY_WARN_THRESHOLD_MS;
    }

    public long getBatchIdFromFileName(String fileName) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(fileName), this.COMPACT_FILE_SUFFIX())));
    }

    public boolean isCompactionBatch(long batchId, int compactInterval) {
        return (batchId + 1L) % (long)compactInterval == 0L;
    }

    public Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval) {
        Predef$.MODULE$.assert(this.isCompactionBatch(compactionBatchId, compactInterval), (Function0 & Serializable)() -> compactionBatchId + " is not a compaction batch");
        return new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(0L, compactionBatchId - (long)compactInterval))).until((Object)BoxesRunTime.boxToLong((long)compactionBatchId));
    }

    public Seq<Object> getAllValidBatches(long batchId, long compactInterval) {
        Predef$.MODULE$.assert(batchId >= 0L);
        long start = package$.MODULE$.max(0L, (batchId + 1L) / compactInterval * compactInterval - 1L);
        return new RichLong(Predef$.MODULE$.longWrapper(start)).to((Object)BoxesRunTime.boxToLong((long)batchId));
    }

    public long nextCompactionBatchId(long batchId, long compactInterval) {
        return (batchId + compactInterval + 1L) / compactInterval * compactInterval - 1L;
    }

    public int deriveCompactInterval(int defaultInterval, int latestCompactBatchId) {
        if (latestCompactBatchId + 1 <= defaultInterval) {
            return latestCompactBatchId + 1;
        }
        if (defaultInterval < (latestCompactBatchId + 1) / 2) {
            return BoxesRunTime.unboxToInt((Object)CompactibleFileStreamLog$.properDivisors$1(defaultInterval, latestCompactBatchId + 1).head());
        }
        return latestCompactBatchId + 1;
    }

    private static final LazyList properDivisors$1(int min, int n) {
        return (LazyList)((LazyList)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(min), n / 2).to(IterableFactory$.MODULE$.toFactory((IterableFactory)scala.package$.MODULE$.LazyList()))).filter((Function1)(JFunction1.mcZI.sp & Serializable)i -> n % i == 0).$colon$plus((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private CompactibleFileStreamLog$() {
    }
}

