/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitLog;
import org.apache.spark.sql.execution.streaming.operators.stateful.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV2$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\u000e\u001c\u0001)B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0001B\u0003%a\tC\u0003O\u0001\u0011\u0005q\nC\u0004V\u0001\t\u0007I\u0011\u0002,\t\ru\u0003\u0001\u0015!\u0003X\u0011\u001dq\u0006A1A\u0005\n}Ca\u0001\u0019\u0001!\u0002\u0013A\u0004bB1\u0001\u0005\u0004%Ia\u0018\u0005\u0007E\u0002\u0001\u000b\u0011\u0002\u001d\t\u000f\r\u0004!\u0019!C\u0005I\"11\u000e\u0001Q\u0001\n\u0015Dq\u0001\u001c\u0001C\u0002\u0013%q\f\u0003\u0004n\u0001\u0001\u0006I\u0001\u000f\u0005\b]\u0002\u0011\r\u0011\"\u0003`\u0011\u0019y\u0007\u0001)A\u0005q!A\u0001\u000f\u0001EC\u0002\u0013%\u0011\u000fC\u0003v\u0001\u0011Ea\u000fC\u0004}\u0001\t\u0007I\u0011C?\t\u000f\u0005\r\u0001\u0001)A\u0005}\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\n\u0001\t\u0013\tIC\u0001\u0012Pa\u0016\u0014\u0018\r^8s'R\fG/Z'fi\u0006$\u0017\r^1We\u0019KG.Z'b]\u0006<WM\u001d\u0006\u00039u\tQa\u001d;bi\u0016T!AH\u0010\u0002\u0013M$(/Z1nS:<'B\u0001\u0011\"\u0003%)\u00070Z2vi&|gN\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b$\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001c4\u0005\u001daunZ4j]\u001e\f!c\u00195fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]B\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0003MNT!!P\u0013\u0002\r!\fGm\\8q\u0013\ty$H\u0001\u0003QCRD\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001\"D\u001b\u0005\t\u0013B\u0001#\"\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003A\u0019H/\u0019;f'R|'/Z,sSR,'\u000f\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006A1\u000f^1uK\u001a,HN\u0003\u0002L;\u0005Iq\u000e]3sCR|'o]\u0005\u0003\u001b\"\u0013\u0001c\u0015;bi\u0016\u001cFo\u001c:f/JLG/\u001a:\u0002\rqJg.\u001b;?)\u0011\u0001&k\u0015+\u0011\u0005E\u0003Q\"A\u000e\t\u000b]\"\u0001\u0019\u0001\u001d\t\u000b\u0001#\u0001\u0019A!\t\u000b\u0015#\u0001\u0019\u0001$\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001X!\tA6,D\u0001Z\u0015\tQF(\u0001\u0003d_:4\u0017B\u0001/Z\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006Y\u0001.\u00193p_B\u001cuN\u001c4!\u0003M\u0019H/\u0019;f\u0007\",7m\u001b9pS:$\b+\u0019;i+\u0005A\u0014\u0001F:uCR,7\t[3dWB|\u0017N\u001c;QCRD\u0007%A\u0007ti\u0006$Xm\u00149JIB\u000bG\u000f[\u0001\u000fgR\fG/Z(q\u0013\u0012\u0004\u0016\r\u001e5!\u0003%\u0019w.\\7ji2{w-F\u0001f!\t1\u0017.D\u0001h\u0015\tAW$A\u0007dQ\u0016\u001c7\u000e]8j]RLgnZ\u0005\u0003U\u001e\u0014\u0011bQ8n[&$Hj\\4\u0002\u0015\r|W.\\5u\u0019><\u0007%A\bti\u0006$XmU2iK6\f\u0007+\u0019;i\u0003A\u0019H/\u0019;f'\u000eDW-\\1QCRD\u0007%A\bnKR\fG-\u0019;b\t&\u0014\b+\u0019;i\u0003AiW\r^1eCR\fG)\u001b:QCRD\u0007%\u0001\u0002g[V\t!\u000f\u0005\u0002gg&\u0011Ao\u001a\u0002\u0016\u0007\",7m\u001b9pS:$h)\u001b7f\u001b\u0006t\u0017mZ3s\u0003-I7OQ1uG\"4\u0015\u000e\\3\u0015\u0005]T\bC\u0001\u0017y\u0013\tIXFA\u0004C_>dW-\u00198\t\u000bm\u0014\u0002\u0019\u0001\u001d\u0002\tA\fG\u000f[\u0001\u0011E\u0006$8\r\u001b$jY\u0016\u001ch)\u001b7uKJ,\u0012A \t\u0003s}L1!!\u0001;\u0005)\u0001\u0016\r\u001e5GS2$XM]\u0001\u0012E\u0006$8\r\u001b$jY\u0016\u001ch)\u001b7uKJ\u0004\u0013!\u00049bi\"$vNQ1uG\"LE\r\u0006\u0003\u0002\n\u0005=\u0001c\u0001\u0017\u0002\f%\u0019\u0011QB\u0017\u0003\t1{gn\u001a\u0005\u0006wV\u0001\r\u0001O\u0001\u0013aV\u0014x-Z'fi\u0006$\u0017\r^1GS2,7\u000f\u0006\u0002\u0002\u0016A\u0019A&a\u0006\n\u0007\u0005eQF\u0001\u0003V]&$\u0018\u0001\u00064j]\u0012$\u0006N]3tQ>dGMQ1uG\"LE\r\u0006\u0002\u0002\n\u0005\tB-\u001a7fi\u0016\u001c6\r[3nC\u001aKG.Z:\u0015\t\u0005U\u00111\u0005\u0005\b\u0003KA\u0002\u0019AA\u0005\u0003A!\bN]3tQ>dGMQ1uG\"LE-A\neK2,G/Z'fi\u0006$\u0017\r^1GS2,7\u000f\u0006\u0003\u0002\n\u0005-\u0002bBA\u00133\u0001\u0007\u0011\u0011\u0002")
public class OperatorStateMetadataV2FileManager
implements Logging {
    private CheckpointFileManager fm;
    private Configuration hadoopConf;
    private final Path stateCheckpointPath;
    private final Path stateOpIdPath;
    private final CommitLog commitLog;
    private final Path stateSchemaPath;
    private final Path metadataDirPath;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path stateCheckpointPath() {
        return this.stateCheckpointPath;
    }

    private Path stateOpIdPath() {
        return this.stateOpIdPath;
    }

    private CommitLog commitLog() {
        return this.commitLog;
    }

    private Path stateSchemaPath() {
        return this.stateSchemaPath;
    }

    private Path metadataDirPath() {
        return this.metadataDirPath;
    }

    private CheckpointFileManager fm$lzycompute() {
        OperatorStateMetadataV2FileManager operatorStateMetadataV2FileManager = this;
        synchronized (operatorStateMetadataV2FileManager) {
            if (!this.bitmap$0) {
                this.fm = CheckpointFileManager$.MODULE$.create(this.metadataDirPath(), this.hadoopConf());
                this.bitmap$0 = true;
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if (!this.bitmap$0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    private long pathToBatchId(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
    }

    public void purgeMetadataFiles() {
        long thresholdBatchId = this.findThresholdBatchId();
        if (thresholdBatchId != 0L) {
            long earliestBatchIdKept = this.deleteMetadataFiles(thresholdBatchId);
            this.deleteSchemaFiles(earliestBatchIdKept - 1L);
            return;
        }
    }

    private long findThresholdBatchId() {
        return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.longArrayOps(this.commitLog().listBatchesOnDisk())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    private void deleteSchemaFiles(long thresholdBatchId) {
        if (thresholdBatchId <= 0L) {
            return;
        }
        Path[] schemaFiles = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(this.stateSchemaPath())), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))), (Function1 & Serializable)x$4 -> x$4.getPath(), ClassTag$.MODULE$.apply(Path.class));
        Path[] filesBeforeThreshold = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])schemaFiles), (Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)OperatorStateMetadataV2FileManager.$anonfun$deleteSchemaFiles$2(thresholdBatchId, path)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])filesBeforeThreshold), (Function1 & Serializable)path -> {
            OperatorStateMetadataV2FileManager.$anonfun$deleteSchemaFiles$5(this, path);
            return BoxedUnit.UNIT;
        });
    }

    private long deleteMetadataFiles(long thresholdBatchId) {
        FileStatus[] metadataFiles = this.fm().list(this.metadataDirPath(), this.batchFilesFilter());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles))) {
            return -1L;
        }
        long[] sortedBatchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)this.pathToBatchId(file.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 <= thresholdBatchId)), (Ordering)Ordering.Long$.MODULE$);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(sortedBatchIds))) {
            return -1L;
        }
        long latestBatchId = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(sortedBatchIds)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles), (Function1 & Serializable)batchFile -> {
            OperatorStateMetadataV2FileManager.$anonfun$deleteMetadataFiles$3(this, latestBatchId, batchFile);
            return BoxedUnit.UNIT;
        });
        return 0L;
    }

    public static final /* synthetic */ boolean $anonfun$deleteSchemaFiles$2(long thresholdBatchId$1, Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])path.getName().split("_")))))).toOption().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 <= thresholdBatchId$1);
    }

    public static final /* synthetic */ void $anonfun$deleteSchemaFiles$5(OperatorStateMetadataV2FileManager $this, Path path) {
        $this.fm().delete(path);
    }

    public static final /* synthetic */ void $anonfun$deleteMetadataFiles$3(OperatorStateMetadataV2FileManager $this, long latestBatchId$1, FileStatus batchFile) {
        long batchId = $this.pathToBatchId(batchFile.getPath());
        if (batchId < latestBatchId$1) {
            $this.fm().delete(batchFile.getPath());
            return;
        }
    }

    public OperatorStateMetadataV2FileManager(Path checkpointLocation, SparkSession sparkSession, StateStoreWriter stateStoreWriter) {
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.stateCheckpointPath = new Path(checkpointLocation, "state");
        this.stateOpIdPath = new Path(this.stateCheckpointPath(), Long.toString(stateStoreWriter.getStateInfo().operatorId()));
        this.commitLog = new CommitLog(sparkSession, new Path(checkpointLocation, "commits").toString());
        this.stateSchemaPath = stateStoreWriter.stateSchemaDirPath(stateStoreWriter.stateSchemaDirPath$default$1());
        this.metadataDirPath = OperatorStateMetadataV2$.MODULE$.metadataDirPath(this.stateOpIdPath());
        this.batchFilesFilter = path -> this.isBatchFile(path);
    }
}

