/*
 * Decompiled with CFR 0.152.
 */
package io.github.retronym.java9rtexport;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;

public class Copy {
    public static void copyDirectory(final Path path, final Path path2) throws IOException {
        Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                String string = path.relativize(path3).toString();
                if (!Files.exists(path2.getFileSystem().getPath(string, new String[0]), new LinkOption[0])) {
                    Files.createDirectory(path2.getFileSystem().getPath(string, new String[0]), new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                String string = path.relativize(path3).toString();
                Files.copy(path3, path2.getFileSystem().getPath(string, new String[0]), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path3, IOException iOException) throws IOException {
                throw iOException;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path3, IOException iOException) throws IOException {
                if (iOException != null) {
                    throw iOException;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

