/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.impl.ResourceHandler;
import io.fabric8.kubernetes.client.impl.ResourceHandlerImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class Handlers {
    private final Map<Class<?>, ResourceHandler<?, ?>> resourceHandlers = new ConcurrentHashMap();
    private final Map<List<String>, ResourceDefinitionContext> genericDefinitions = new ConcurrentHashMap<List<String>, ResourceDefinitionContext>();

    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> void register(Class<T> type, Function<Client, HasMetadataOperation<T, L, R>> operationConstructor) {
        if (this.resourceHandlers.put(type, new ResourceHandlerImpl(type, operationConstructor)) != null) {
            throw new AssertionError((Object)String.format("%s already registered", type.getName()));
        }
    }

    public <T extends HasMetadata> void unregister(Class<T> type) {
        this.resourceHandlers.remove(type);
    }

    public <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(T meta, Client client) {
        GenericKubernetesResource gkr;
        ResourceDefinitionContext rdc;
        Class<?> type = meta.getClass();
        if (type.equals(GenericKubernetesResource.class) && (rdc = this.getResourceDefinitionContext((gkr = (GenericKubernetesResource)meta).getApiVersion(), gkr.getKind(), client)) != null) {
            return new ResourceHandlerImpl(GenericKubernetesResource.class, GenericKubernetesResourceList.class, rdc);
        }
        ResourceHandler<?, V> result = this.get(type);
        if (result == null) {
            throw new KubernetesClientException("Could not find a registered handler for item: [" + String.valueOf(meta) + "].");
        }
        return result;
    }

    public ResourceDefinitionContext getResourceDefinitionContext(String apiVersion, String kind, Client client) {
        Class clazz = ((BaseClient)client.adapt(BaseClient.class)).getKubernetesSerialization().getRegisteredKubernetesResource(apiVersion, kind);
        ResourceDefinitionContext rdc = null;
        if (clazz != null) {
            rdc = ResourceDefinitionContext.fromResourceType((Class)clazz);
        } else {
            if (kind == null || apiVersion == null) {
                return null;
            }
            String api = ApiVersionUtil.trimGroupOrNull((String)apiVersion);
            if (api == null) {
                return null;
            }
            String version = ApiVersionUtil.trimVersion((String)apiVersion);
            rdc = this.genericDefinitions.computeIfAbsent(Arrays.asList(kind, apiVersion), k -> {
                APIResourceList resourceList = client.getApiResources(apiVersion);
                if (resourceList == null) {
                    return null;
                }
                return resourceList.getResources().stream().filter(r -> kind.equals(r.getKind())).findFirst().map(resource -> new ResourceDefinitionContext.Builder().withGroup(api).withKind(kind).withNamespaced(Boolean.TRUE.equals(resource.getNamespaced())).withPlural(resource.getName()).withVersion(version).build()).orElse(null);
            });
        }
        return rdc;
    }

    private <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(Class<T> type) {
        if (type.equals(GenericKubernetesResource.class)) {
            return null;
        }
        return this.resourceHandlers.computeIfAbsent(type, k -> new ResourceHandlerImpl(type, null));
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> HasMetadataOperation<T, L, R> getOperation(Class<T> type, Class<L> listType, Client client) {
        ResourceHandler resourceHandler = this.get(type);
        if (resourceHandler == null) {
            throw new IllegalStateException();
        }
        return resourceHandler.operation(client, listType);
    }

    public <T extends HasMetadata> HasMetadataOperation<T, ?, Resource<T>> getNonListingOperation(Class<T> type, Client client) {
        return this.getOperation(type, KubernetesResourceUtil.inferListType(type), client);
    }

    public <T extends HasMetadata> NamespacedInOutCreateable<T, T> getNamespacedHasMetadataCreateOnlyOperation(Class<T> type, Client client) {
        HasMetadataOperation<T, ?, Resource<T>> operation = this.getNonListingOperation(type, client);
        return operation::inNamespace;
    }
}

