/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.Client$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t4Qa\u0003\u0007\u0001%aA\u0001\"\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015A\u0005\u0001\"\u0001J\u000f\u0019iE\u0002#\u0001\u0013\u001d\u001a11\u0002\u0004E\u0001%=CQ!\u0011\u0005\u0005\u0002ACQ!\u0015\u0005\u0005\u0002I\u0013aa\u00117jK:$(BA\u0007\u000f\u0003\u0019\u0019XOY7ji*\u0011q\u0002E\u0001\u0004Wb\u001a(BA\t\u0013\u0003\u0019!W\r\u001d7ps*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014xmE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0013\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0013\"\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001C\u0001\u0015*\u001b\u0005q\u0011B\u0001\u0016\u000f\u0005QYUOY3s]\u0016$Xm\u001d#sSZ,'oQ8oM\u00069!-^5mI\u0016\u0014\bCA\u0017/\u001b\u0005a\u0011BA\u0018\r\u0005]YUOY3s]\u0016$Xm\u001d#sSZ,'OQ;jY\u0012,'/\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0011!gO\u0007\u0002g)\u0011A'N\u0001\u0007G2LWM\u001c;\u000b\u0005Y:\u0014AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0001(O\u0001\bM\u0006\u0014'/[29\u0015\u0005Q\u0014AA5p\u0013\ta4G\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u00069q/\u0019;dQ\u0016\u0014\bCA\u0017@\u0013\t\u0001EBA\fM_\u001e<\u0017N\\4Q_\u0012\u001cF/\u0019;vg^\u000bGo\u00195fe\u00061A(\u001b8jiz\"Ra\u0011#F\r\u001e\u0003\"!\f\u0001\t\u000b\u0015*\u0001\u0019A\u0014\t\u000b-*\u0001\u0019\u0001\u0017\t\u000bA*\u0001\u0019A\u0019\t\u000bu*\u0001\u0019\u0001 \u0002\u0007I,h\u000eF\u0001K!\tQ2*\u0003\u0002M7\t!QK\\5u\u0003\u0019\u0019E.[3oiB\u0011Q\u0006C\n\u0003\u0011e!\u0012AT\u0001\rgV\u0014W.[:tS>t\u0017\n\u001a\u000b\u0004'z\u0003\u0007C\u0001+\\\u001d\t)\u0016\f\u0005\u0002W75\tqK\u0003\u0002YM\u00051AH]8pizJ!AW\u000e\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035nAQa\u0018\u0006A\u0002M\u000b\u0011B\\1nKN\u0004\u0018mY3\t\u000b\u0005T\u0001\u0019A*\u0002\u001b\u0011\u0014\u0018N^3s!>$g*Y7f\u0001")
public class Client
implements Logging {
    private final KubernetesDriverConf conf;
    private final KubernetesDriverBuilder builder;
    private final KubernetesClient kubernetesClient;
    private final LoggingPodStatusWatcher watcher;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String submissionId(String namespace, String driverPodName) {
        return Client$.MODULE$.submissionId(namespace, driverPodName);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void run() {
        KubernetesDriverSpec resolvedDriverSpec = this.builder.buildFromFeatures(this.conf, this.kubernetesClient);
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameDriver();
        scala.collection.immutable.Map<String, String> confFilesMap = KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf.sparkConf(), resolvedDriverSpec.systemProperties());
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)confFilesMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key()), (Object)this.conf.namespace()))), KubernetesClientUtils$.MODULE$.buildConfigMap$default$3());
        Container resolvedDriverContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent)((ContainerFluent.EnvNested)new ContainerBuilder(resolvedDriverSpec.pod().container()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Pod resolvedDriverPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(resolvedDriverSpec.pod().pod()).editSpec().addToContainers(new Container[]{resolvedDriverContainer}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withNewConfigMap().withItems(CollectionConverters$.MODULE$.SeqHasAsJava(KubernetesClientUtils$.MODULE$.buildKeyToPathObjects(confFilesMap)).asJava()).withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        String driverPodName = resolvedDriverPod.getMetadata().getName();
        Seq<HasMetadata> preKubernetesResources = resolvedDriverSpec.driverPreKubernetesResources();
        try {
            this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).forceConflicts().serverSideApply();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Please check \"kubectl auth can-i create [resource]\" first. It should be yes. And please also check your feature step implementation.");
                this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).delete();
                throw throwable2;
            }
            throw throwable;
        }
        ObjectRef watch = ObjectRef.create(null);
        Pod createdDriverPod = null;
        try {
            createdDriverPod = (Pod)((CreateOrReplaceable)((AnyNamespaceOperation)this.kubernetesClient.pods().inNamespace(this.conf.namespace())).resource((Object)resolvedDriverPod)).create();
        }
        catch (Throwable throwable) {
            Throwable throwable4;
            Throwable throwable5 = throwable;
            if (throwable5 != null && NonFatal$.MODULE$.apply(throwable4 = throwable5)) {
                this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).delete();
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Please check \"kubectl auth can-i create pod\" first. It should be yes.");
                throw throwable4;
            }
            throw throwable;
        }
        try {
            KubernetesUtils$.MODULE$.addOwnerReference(createdDriverPod, preKubernetesResources);
            this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).forceConflicts().serverSideApply();
        }
        catch (Throwable throwable) {
            Throwable throwable6;
            Throwable throwable7 = throwable;
            if (throwable7 != null && NonFatal$.MODULE$.apply(throwable6 = throwable7)) {
                ((Deletable)this.kubernetesClient.pods().resource((Object)createdDriverPod)).delete();
                this.kubernetesClient.resourceList((HasMetadata[])preKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).delete();
                throw throwable6;
            }
            throw throwable;
        }
        try {
            Seq otherKubernetesResources = (Seq)resolvedDriverSpec.driverKubernetesResources().$plus$plus((IterableOnce)new .colon.colon((Object)configMap, (List)Nil$.MODULE$));
            KubernetesUtils$.MODULE$.addOwnerReference(createdDriverPod, (Seq<HasMetadata>)otherKubernetesResources);
            this.kubernetesClient.resourceList((HasMetadata[])otherKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).forceConflicts().serverSideApply();
        }
        catch (Throwable throwable) {
            Throwable throwable8;
            Throwable throwable9 = throwable;
            if (throwable9 != null && NonFatal$.MODULE$.apply(throwable8 = throwable9)) {
                ((Deletable)this.kubernetesClient.pods().resource((Object)createdDriverPod)).delete();
                throw throwable8;
            }
            throw throwable;
        }
        String sId = Client$.MODULE$.submissionId(this.conf.namespace(), driverPodName);
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()))) {
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                do {
                    PodResource podWithName = (PodResource)((Nameable)$this.kubernetesClient.pods().inNamespace($this.conf.namespace())).withName(driverPodName);
                    $this.watcher.reset();
                    watch$1.elem = podWithName.watch((Watcher)$this.watcher);
                    $this.watcher.eventReceived(Watcher.Action.MODIFIED, podWithName.get());
                } while (!$this.watcher.watchOrStop(sId));
                ((Watch)watch$1.elem).close();
                throw Breaks$.MODULE$.break();
            });
            return;
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deployed Spark application ", " with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.APP_NAME, $this.conf.appName())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application ID ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.APP_ID, $this.conf.appId())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"submission ID ", " into Kubernetes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SUBMISSION_ID, sId)})))));
    }

    public Client(KubernetesDriverConf conf, KubernetesDriverBuilder builder, KubernetesClient kubernetesClient, LoggingPodStatusWatcher watcher) {
        this.conf = conf;
        this.builder = builder;
        this.kubernetesClient = kubernetesClient;
        this.watcher = watcher;
        Logging.$init$((Logging)this);
    }
}

