/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.ScalarScalaUDF;
import org.apache.spark.connect.proto.WriteStreamOperationStart;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.RemoteStreamingQuery$;
import org.apache.spark.sql.connect.StreamingQuery;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.ForeachWriterPacket;
import org.apache.spark.sql.execution.streaming.AvailableNowTrigger$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryListener$QueryStartedEvent$;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.util.SparkSerDeUtils$;
import org.sparkproject.com.google.protobuf.ByteString;
import scala.Function2;
import scala.MatchError;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001\u0002\r\u001a\u0005\u0011B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0007}\u0001!\taG \t\u000b\t\u0003A\u0011A\"\t\u000b\t\u0003A\u0011A%\t\u000bY\u0003A\u0011A,\t\u000bq\u0003A\u0011A/\t\u000b}\u0003A\u0011\u00011\t\u000b\r\u0004A\u0011\u00013\t\u000bE\u0004A\u0011\u0001:\t\u000bU\u0004A\u0011\u0001<\t\u000bm\u0004A\u0011\u0001?\t\rm\u0004A\u0011AA\u0005\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005U\u0003\u0001\"\u0001\u0002d!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005BB;\u0001\t\u0003\n9\u000b\u0003\u0004v\u0001\u0011\u0005\u00131\u0017\u0005\u0007k\u0002!\t%!/\t\u000f\u0005-\u0002\u0001\"\u0011\u0002F\"I\u0011q\u001c\u0001C\u0002\u0013%\u0011\u0011\u001d\u0005\t\u0003s\u0004\u0001\u0015!\u0003\u0002d\n\u0001B)\u0019;b'R\u0014X-Y7Xe&$XM\u001d\u0006\u00035m\tqaY8o]\u0016\u001cGO\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001!\u0006\u0002&[M\u0011\u0001A\n\t\u0004O)ZS\"\u0001\u0015\u000b\u0005%Z\u0012!C:ue\u0016\fW.\u001b8h\u0013\tA\u0002\u0006\u0005\u0002-[1\u0001A!\u0002\u0018\u0001\u0005\u0004y#!\u0001+\u0012\u0005A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$a\u0002(pi\"Lgn\u001a\t\u0003c]J!\u0001\u000f\u001a\u0003\u0007\u0005s\u00170\u0001\u0002egB\u00191\bP\u0016\u000e\u0003eI!!P\r\u0003\u000f\u0011\u000bG/Y:fi\u00061A(\u001b8jiz\"\"\u0001Q!\u0011\u0007m\u00021\u0006C\u0003:\u0005\u0001\u0007!(\u0001\u0006pkR\u0004X\u000f^'pI\u0016$\"\u0001R#\u000e\u0003\u0001AQAQ\u0002A\u0002\u0019\u0003\"aJ$\n\u0005!C#AC(viB,H/T8eKR\u0011AI\u0013\u0005\u0006\u0005\u0012\u0001\ra\u0013\t\u0003\u0019Ns!!T)\u0011\u00059\u0013T\"A(\u000b\u0005A\u001b\u0013A\u0002\u001fs_>$h(\u0003\u0002Se\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011&'A\u0004ue&<w-\u001a:\u0015\u0005\u0011C\u0006\"\u0002,\u0006\u0001\u0004I\u0006CA\u0014[\u0013\tY\u0006FA\u0004Ue&<w-\u001a:\u0002\u0013E,XM]=OC6,GC\u0001#_\u0011\u0015af\u00011\u0001L\u0003\u00191wN]7biR\u0011A)\u0019\u0005\u0006E\u001e\u0001\raS\u0001\u0007g>,(oY3\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0003\t\u0016DQA\u001a\u0005A\u0002\u001d\f\u0001bY8m\u001d\u0006lWm\u001d\t\u0004c!\\\u0015BA53\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0003\u0011-\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002q[\n9a/\u0019:be\u001e\u001c\u0018!C2mkN$XM\u001d\"z)\t!5\u000fC\u0003g\u0013\u0001\u0007q\r\u000b\u0002\nW\u00061q\u000e\u001d;j_:$2\u0001R<z\u0011\u0015A(\u00021\u0001L\u0003\rYW-\u001f\u0005\u0006u*\u0001\raS\u0001\u0006m\u0006dW/Z\u0001\b_B$\u0018n\u001c8t)\t!U\u0010C\u0003|\u0017\u0001\u0007a\u0010E\u0003\u0000\u0003\u000bY5*\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0005\u0005!aA'baR\u0019A)a\u0003\t\rmd\u0001\u0019AA\u0007!\u0019\ty!!\u0007L\u00176\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0003vi&d'BAA\f\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0011\u0011C\u0001\bM>\u0014X-Y2i)\r!\u0015q\u0004\u0005\b\u0003Ci\u0001\u0019AA\u0012\u0003\u00199(/\u001b;feB)\u0011QEA\u0014W5\t1$C\u0002\u0002*m\u0011QBR8sK\u0006\u001c\u0007n\u0016:ji\u0016\u0014\u0018\u0001\u00044pe\u0016\f7\r\u001b\"bi\u000eDGc\u0001#\u00020!9\u0011\u0011\u0007\bA\u0002\u0005M\u0012\u0001\u00034v]\u000e$\u0018n\u001c8\u0011\u0013E\n)$!\u000f\u0002>\u0005\r\u0013bAA\u001ce\tIa)\u001e8di&|gN\r\t\u0006\u0003K\tYdK\u0005\u0003{m\u00012!MA \u0013\r\t\tE\r\u0002\u0005\u0019>tw\rE\u00022\u0003\u000bJ1!a\u00123\u0005\u0011)f.\u001b;)\u00079\tY\u0005\u0005\u0003\u0002N\u0005ESBAA(\u0015\tqW$\u0003\u0003\u0002T\u0005=#\u0001C#w_24\u0018N\\4\u0002\u000bM$\u0018M\u001d;\u0015\t\u0005e\u0013q\f\t\u0004w\u0005m\u0013bAA/3\tq1\u000b\u001e:fC6LgnZ)vKJL\bBBA1\u001f\u0001\u00071*\u0001\u0003qCRDGCAA-Q\u0015\u0001\u0012qMA=!\u0015\t\u0014\u0011NA7\u0013\r\tYG\r\u0002\u0007i\"\u0014xn^:\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cRA!a\u001d\u0002\u0012\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005]\u0014\u0011\u000f\u0002\u0011)&lWm\\;u\u000bb\u001cW\r\u001d;j_:\fT!JA>\u0003+SC!! \u0002\bB!\u0011qPAC\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006U\u0011\u0001\u00027b]\u001eL1\u0001VAAW\t\tI\t\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty)\\\u0001\u0005[\u0016$\u0018-\u0003\u0003\u0002\u0014\u00065%A\u00033fM\u0006,H\u000e^!sO\u0006\u0012\u0011qS\u0001\u0001\u0003\u001d!x\u000eV1cY\u0016$B!!\u0017\u0002\u001e\"1\u0011qT\tA\u0002-\u000b\u0011\u0002^1cY\u0016t\u0015-\\3)\u0007E\tY\u0005K\u0003\u0012\u0003O\n)+M\u0003&\u0003w\n)\nF\u0003E\u0003S\u000bY\u000bC\u0003y%\u0001\u00071\n\u0003\u0004{%\u0001\u0007\u0011Q\u0016\t\u0004c\u0005=\u0016bAAYe\t9!i\\8mK\u0006tG#\u0002#\u00026\u0006]\u0006\"\u0002=\u0014\u0001\u0004Y\u0005B\u0002>\u0014\u0001\u0004\ti\u0004F\u0003E\u0003w\u000bi\fC\u0003y)\u0001\u00071\n\u0003\u0004{)\u0001\u0007\u0011q\u0018\t\u0004c\u0005\u0005\u0017bAAbe\t1Ai\\;cY\u0016$2\u0001RAd\u0011\u001d\t\t$\u0006a\u0001\u0003\u0013\u0004\u0002\"a3\u0002V\u0006e\u0012\u0011\\\u0007\u0003\u0003\u001bTA!!\r\u0002P*!\u0011qCAi\u0015\r\t\u0019.H\u0001\u0004CBL\u0017\u0002BAl\u0003\u001b\u0014QBV8jI\u001a+hn\u0019;j_:\u0014\u0004\u0003BA@\u00037LA!!\u0011\u0002\u0002\"\u001aQ#a\u0013\u0002\u0017MLgn\u001b\"vS2$WM]\u000b\u0003\u0003G\u0004B!!:\u0002t:!\u0011q]Ax\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018!\u00029s_R|'B\u0001\u000e\u001e\u0013\u0011\t\t0!;\u00023]\u0013\u0018\u000e^3TiJ,\u0017-\\(qKJ\fG/[8o'R\f'\u000f^\u0005\u0005\u0003k\f9PA\u0004Ck&dG-\u001a:\u000b\t\u0005E\u0018\u0011^\u0001\rg&t7NQ;jY\u0012,'\u000f\t\u0015\u0004\u0001\u0005-\u0003")
public final class DataStreamWriter<T>
extends org.apache.spark.sql.streaming.DataStreamWriter<T> {
    private final Dataset<T> ds;
    private final WriteStreamOperationStart.Builder sinkBuilder;

    @Override
    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    @Override
    public DataStreamWriter<T> clusterBy(String ... colNames) {
        return this.clusterBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    @Override
    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.sinkBuilder().setOutputMode(outputMode.toString().toLowerCase(Locale.ROOT));
        return this;
    }

    @Override
    public DataStreamWriter<T> outputMode(String outputMode) {
        this.sinkBuilder().setOutputMode(outputMode);
        return this;
    }

    @Override
    public DataStreamWriter<T> trigger(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger2;
            long intervalMs = processingTimeTrigger.intervalMs();
            this.sinkBuilder().setProcessingTimeInterval(intervalMs + " milliseconds");
        } else if (AvailableNowTrigger$.MODULE$.equals(trigger2)) {
            this.sinkBuilder().setAvailableNow(true);
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            this.sinkBuilder().setOnce(true);
        } else if (trigger2 instanceof ContinuousTrigger) {
            ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
            long intervalMs = continuousTrigger.intervalMs();
            this.sinkBuilder().setContinuousCheckpointInterval(intervalMs + " milliseconds");
        } else {
            throw new MatchError((Object)trigger2);
        }
        return this;
    }

    @Override
    public DataStreamWriter<T> queryName(String queryName) {
        this.sinkBuilder().setQueryName(queryName);
        return this;
    }

    @Override
    public DataStreamWriter<T> format(String source) {
        this.sinkBuilder().setFormat(source);
        return this;
    }

    @Override
    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.sinkBuilder().clearPartitioningColumnNames();
        this.sinkBuilder().addAllPartitioningColumnNames(CollectionConverters$.MODULE$.SeqHasAsJava(colNames).asJava());
        return this;
    }

    @Override
    public DataStreamWriter<T> clusterBy(Seq<String> colNames) {
        this.sinkBuilder().clearClusteringColumnNames();
        this.sinkBuilder().addAllClusteringColumnNames(CollectionConverters$.MODULE$.SeqHasAsJava(colNames).asJava());
        return this;
    }

    @Override
    public DataStreamWriter<T> option(String key, String value) {
        this.sinkBuilder().putOptions(key, value);
        return this;
    }

    @Override
    public DataStreamWriter<T> options(Map<String, String> options) {
        this.options(CollectionConverters$.MODULE$.MapHasAsJava(options).asJava());
        return this;
    }

    @Override
    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.sinkBuilder().putAllOptions(options);
        return this;
    }

    @Override
    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        byte[] serialized = SparkSerDeUtils$.MODULE$.serialize((Object)new ForeachWriterPacket(writer, this.ds.agnosticEncoder()));
        ScalarScalaUDF.Builder scalaWriterBuilder = ScalarScalaUDF.newBuilder().setPayload(ByteString.copyFrom(serialized));
        this.sinkBuilder().getForeachWriterBuilder().setScalaFunction(scalaWriterBuilder);
        return this;
    }

    @Override
    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<org.apache.spark.sql.Dataset<T>, Object, BoxedUnit> function) {
        byte[] serializedFn = SparkSerDeUtils$.MODULE$.serialize((Object)new ForeachWriterPacket(function, this.ds.agnosticEncoder()));
        this.sinkBuilder().getForeachBatchBuilder().getScalaFunctionBuilder().setPayload(ByteString.copyFrom(serializedFn)).setOutputType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(NullType$.MODULE$, DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())).setNullable(true);
        return this;
    }

    @Override
    public StreamingQuery start(String path) {
        this.sinkBuilder().setPath(path);
        return this.start();
    }

    @Override
    public StreamingQuery start() throws TimeoutException {
        ExecutePlanResponse resp;
        block0: {
            Command startCmd = Command.newBuilder().setWriteStreamOperationStart(this.sinkBuilder().build()).build();
            resp = (ExecutePlanResponse)this.ds.sparkSession().execute(startCmd).head();
            if (!resp.getWriteStreamOperationStartResult().hasQueryStartedEventJson()) break block0;
            StreamingQueryListener.QueryStartedEvent event = StreamingQueryListener$QueryStartedEvent$.MODULE$.fromJson(resp.getWriteStreamOperationStartResult().getQueryStartedEventJson());
            this.ds.sparkSession().streams().streamingQueryListenerBus().postToAll(event);
        }
        return RemoteStreamingQuery$.MODULE$.fromStartCommandResponse(this.ds.sparkSession(), resp);
    }

    @Override
    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        this.sinkBuilder().setTableName(tableName);
        return this.start();
    }

    @Override
    public DataStreamWriter<T> option(String key, boolean value) {
        return (DataStreamWriter)super.option(key, value);
    }

    @Override
    public DataStreamWriter<T> option(String key, long value) {
        return (DataStreamWriter)super.option(key, value);
    }

    @Override
    public DataStreamWriter<T> option(String key, double value) {
        return (DataStreamWriter)super.option(key, value);
    }

    @Override
    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<org.apache.spark.sql.Dataset<T>, Long> function) {
        return (DataStreamWriter)super.foreachBatch(function);
    }

    private WriteStreamOperationStart.Builder sinkBuilder() {
        return this.sinkBuilder;
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        this.sinkBuilder = WriteStreamOperationStart.newBuilder().setInput(ds.plan().getRoot());
    }
}

