/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.connect.proto.CommonInlineUserDefinedFunction;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.ScalarScalaUDF;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.UdfPacket;
import org.apache.spark.sql.expressions.SparkUserDefinedFunction;
import org.apache.spark.sql.expressions.UserDefinedAggregator;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.util.ClosureCleaner$;
import org.apache.spark.util.SparkClassUtils$;
import org.apache.spark.util.SparkSerDeUtils$;
import org.sparkproject.com.google.protobuf.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class UdfToProtoUtils$ {
    public static final UdfToProtoUtils$ MODULE$ = new UdfToProtoUtils$();
    private static final String LAMBDA_DESERIALIZATION_ERR_MSG = "cannot assign instance of java.lang.invoke.SerializedLambda to field";

    private String LAMBDA_DESERIALIZATION_ERR_MSG() {
        return LAMBDA_DESERIALIZATION_ERR_MSG;
    }

    private void checkDeserializable(byte[] bytes) {
        try {
            SparkSerDeUtils$.MODULE$.deserialize(bytes, SparkClassUtils$.MODULE$.getContextOrSparkClassLoader());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            ClassCastException classCastException;
            Throwable throwable3 = throwable;
            if (throwable3 instanceof ClassCastException && (classCastException = (ClassCastException)throwable3).getMessage().contains(this.LAMBDA_DESERIALIZATION_ERR_MSG())) {
                throw new SparkException("UDF cannot be executed on a Spark cluster: it cannot be deserialized. This is very likely to be caused by the lambda function (the UDF) having a self-reference. This is not supported by java serialization.");
            }
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new SparkException("UDF cannot be executed on a Spark cluster: it cannot be deserialized.", throwable2);
            }
            throw throwable;
        }
    }

    public ByteString toUdfPacketBytes(Object function, Seq<AgnosticEncoder<?>> inputEncoders, AgnosticEncoder<?> outputEncoder) {
        ClosureCleaner$.MODULE$.clean(function, true, (Map)Map$.MODULE$.empty());
        byte[] bytes = SparkSerDeUtils$.MODULE$.serialize((Object)new UdfPacket(function, inputEncoders, outputEncoder));
        this.checkDeserializable(bytes);
        return ByteString.copyFrom(bytes);
    }

    public CommonInlineUserDefinedFunction toProto(UserDefinedFunction udf, Seq<Expression> arguments, boolean isDistinct) {
        CommonInlineUserDefinedFunction.Builder invokeUdf = CommonInlineUserDefinedFunction.newBuilder().setDeterministic(udf.deterministic()).setIsDistinct(isDistinct).addAllArguments(CollectionConverters$.MODULE$.SeqHasAsJava(arguments).asJava());
        ScalarScalaUDF.Builder protoUdf = invokeUdf.getScalarScalaUdfBuilder().setNullable(udf.nullable());
        UserDefinedFunction userDefinedFunction = udf;
        if (userDefinedFunction instanceof SparkUserDefinedFunction) {
            SparkUserDefinedFunction sparkUserDefinedFunction = (SparkUserDefinedFunction)userDefinedFunction;
            AgnosticEncoder outputEncoder = (AgnosticEncoder)sparkUserDefinedFunction.outputEncoder().map((Function1 & Serializable)e -> AgnosticEncoders$.MODULE$.agnosticEncoderFor(e)).getOrElse((Function0 & Serializable)() -> RowEncoder$.MODULE$.encoderForDataType(sparkUserDefinedFunction.dataType(), false));
            Nil$ inputEncoders = sparkUserDefinedFunction.inputEncoders().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty())) ? Nil$.MODULE$ : (Seq)sparkUserDefinedFunction.inputEncoders().map((Function1 & Serializable)e -> AgnosticEncoders$.MODULE$.agnosticEncoderFor((Encoder)e.get()));
            inputEncoders.foreach((Function1 & Serializable)e -> protoUdf.addInputTypes(DataTypeProtoConverter$.MODULE$.toConnectProtoType(e.dataType(), DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())));
            protoUdf.setPayload(this.toUdfPacketBytes(sparkUserDefinedFunction.f(), (Seq<AgnosticEncoder<?>>)inputEncoders, outputEncoder)).setOutputType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(outputEncoder.dataType(), DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())).setAggregate(false);
            sparkUserDefinedFunction.givenName().foreach((Function1 & Serializable)value -> invokeUdf.setFunctionName((String)value));
        } else if (userDefinedFunction instanceof UserDefinedAggregator) {
            AgnosticEncoder inputEncoder;
            UserDefinedAggregator userDefinedAggregator = (UserDefinedAggregator)userDefinedFunction;
            AgnosticEncoder outputEncoder = AgnosticEncoders$.MODULE$.agnosticEncoderFor(userDefinedAggregator.aggregator().outputEncoder());
            AgnosticEncoder agnosticEncoder = inputEncoder = AgnosticEncoders$.MODULE$.agnosticEncoderFor(userDefinedAggregator.inputEncoder());
            protoUdf.setPayload(this.toUdfPacketBytes(userDefinedAggregator.aggregator(), (Seq<AgnosticEncoder<?>>)Nil$.MODULE$.$colon$colon(agnosticEncoder), outputEncoder)).addInputTypes(DataTypeProtoConverter$.MODULE$.toConnectProtoType(inputEncoder.dataType(), DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())).setOutputType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(outputEncoder.dataType(), DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())).setAggregate(true);
            userDefinedAggregator.givenName().foreach((Function1 & Serializable)value -> invokeUdf.setFunctionName((String)value));
        } else {
            throw new MatchError((Object)userDefinedFunction);
        }
        return invokeUdf.build();
    }

    public Seq<Expression> toProto$default$2() {
        return Nil$.MODULE$;
    }

    public boolean toProto$default$3() {
        return false;
    }

    private UdfToProtoUtils$() {
    }
}

