/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.com.google.protobuf.util;

import java.util.Map;
import org.sparkproject.com.google.protobuf.ListValue;
import org.sparkproject.com.google.protobuf.NullValue;
import org.sparkproject.com.google.protobuf.Struct;
import org.sparkproject.com.google.protobuf.Value;

public final class Values {
    private static final Value NULL_VALUE = Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    private static final Value TRUE_VALUE = Value.newBuilder().setBoolValue(true).build();
    private static final Value FALSE_VALUE = Value.newBuilder().setBoolValue(false).build();
    private static final Value EMPTY_STR_VALUE = Value.newBuilder().setStringValue("").build();

    public static Value ofNull() {
        return NULL_VALUE;
    }

    public static Value of(boolean value) {
        return value ? TRUE_VALUE : FALSE_VALUE;
    }

    public static Value of(double value) {
        return Value.newBuilder().setNumberValue(value).build();
    }

    public static Value of(String value) {
        return value.isEmpty() ? EMPTY_STR_VALUE : Value.newBuilder().setStringValue(value).build();
    }

    public static Value of(Struct value) {
        return Value.newBuilder().setStructValue(value).build();
    }

    public static Value of(ListValue value) {
        return Value.newBuilder().setListValue(value).build();
    }

    public static Value of(Iterable<Value> values) {
        return Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(values)).build();
    }

    public static Value of(Map<String, Value> values) {
        return Value.newBuilder().setStructValue(Struct.newBuilder().putAllFields(values)).build();
    }

    private Values() {
    }
}

