/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector.complex.impl;

import org.sparkproject.org.apache.arrow.vector.Float4Vector;
import org.sparkproject.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import org.sparkproject.org.apache.arrow.vector.holders.Float4Holder;
import org.sparkproject.org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;

public class Float4WriterImpl
extends AbstractFieldWriter {
    final Float4Vector vector;

    public Float4WriterImpl(Float4Vector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(Float4Holder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableFloat4Holder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeFloat4(float value) {
        this.vector.setSafe(this.idx(), 1, value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

