/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import io.fabric8.zjsonpatch.CompatibilityFlags;
import io.fabric8.zjsonpatch.CopyingApplyProcessor;
import io.fabric8.zjsonpatch.JsonPatchException;
import io.fabric8.zjsonpatch.JsonPatchProcessor;
import io.fabric8.zjsonpatch.JsonPointer;
import io.fabric8.zjsonpatch.JsonPointerEvaluationException;
import io.fabric8.zjsonpatch.Operation;
import java.util.EnumSet;

public class JsonPatch {
    private static final String OP = "op";
    public static final String VALUE = "value";
    private static final String PATH = "path";
    public static final String FROM = "from";

    private JsonPatch() {
    }

    private static JsonNode getPatchStringAttr(JsonNode jsonNode, String attr) {
        JsonNode child = JsonPatch.getPatchAttr(jsonNode, attr);
        if (!child.isTextual()) {
            throw new JsonPatchException("Invalid JSON Patch payload (non-text '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNode getPatchAttr(JsonNode jsonNode, String attr) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            throw new JsonPatchException("Invalid JSON Patch payload (missing '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNode getPatchAttrWithDefault(JsonNode jsonNode, String attr, JsonNode defaultValue) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            return defaultValue;
        }
        return child;
    }

    private static void process(JsonNode patch, JsonPatchProcessor processor, EnumSet<CompatibilityFlags> flags) {
        if (!patch.isArray()) {
            throw new JsonPatchException("Invalid JSON Patch payload (not an array)");
        }
        for (JsonNode jsonNode : patch) {
            if (!jsonNode.isObject()) {
                throw new JsonPatchException("Invalid JSON Patch payload (not an object)");
            }
            Operation operation = Operation.fromRfcName(JsonPatch.getPatchStringAttr(jsonNode, OP).textValue());
            JsonPointer path = JsonPointer.parse(JsonPatch.getPatchStringAttr(jsonNode, PATH).textValue());
            try {
                switch (operation) {
                    case REMOVE: {
                        processor.remove(path);
                        break;
                    }
                    case ADD: {
                        JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, VALUE) : JsonPatch.getPatchAttrWithDefault(jsonNode, VALUE, (JsonNode)NullNode.getInstance());
                        processor.add(path, value.deepCopy());
                        break;
                    }
                    case REPLACE: {
                        JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, VALUE) : JsonPatch.getPatchAttrWithDefault(jsonNode, VALUE, (JsonNode)NullNode.getInstance());
                        processor.replace(path, value.deepCopy());
                        break;
                    }
                    case MOVE: {
                        JsonPointer fromPath = JsonPointer.parse(JsonPatch.getPatchStringAttr(jsonNode, FROM).textValue());
                        processor.move(fromPath, path);
                        break;
                    }
                    case COPY: {
                        JsonPointer fromPath = JsonPointer.parse(JsonPatch.getPatchStringAttr(jsonNode, FROM).textValue());
                        processor.copy(fromPath, path);
                        break;
                    }
                    case TEST: {
                        JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, VALUE) : JsonPatch.getPatchAttrWithDefault(jsonNode, VALUE, (JsonNode)NullNode.getInstance());
                        processor.test(path, value.deepCopy());
                        break;
                    }
                }
            }
            catch (JsonPointerEvaluationException e) {
                throw new JsonPatchException(e.getMessage(), operation, e.getPath());
            }
        }
    }

    public static JsonNode apply(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) {
        CopyingApplyProcessor processor = new CopyingApplyProcessor(source, flags);
        JsonPatch.process(patch, processor, flags);
        return processor.result();
    }

    public static JsonNode apply(JsonNode patch, JsonNode source) {
        return JsonPatch.apply(patch, source, CompatibilityFlags.defaults());
    }
}

