/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.serializer.SerializationDebugger;
import org.apache.spark.serializer.SerializationDebugger$ObjectStreamClassMethods$;
import org.apache.spark.util.SparkClassUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SerializationDebugger$
implements Logging {
    public static final SerializationDebugger$ MODULE$ = new SerializationDebugger$();
    private static boolean enableDebugging;
    private static final SerializationDebugger.ObjectStreamClassReflection org$apache$spark$serializer$SerializationDebugger$$reflect;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Class clazz = SparkClassUtils$.MODULE$.classForName("sun.security.action.GetBooleanAction", SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3());
        Constructor constructor = clazz.getConstructor(String.class);
        MethodHandle mh = lookup.unreflectConstructor(constructor);
        PrivilegedAction action = (PrivilegedAction)mh.invoke("sun.io.serialization.extendedDebugInfo");
        enableDebugging = Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean(AccessController.doPrivileged(action))) == false;
        org$apache$spark$serializer$SerializationDebugger$$reflect = MODULE$.liftedTree1$1();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public NotSerializableException improveException(Object obj, NotSerializableException e) {
        if (this.enableDebugging() && this.org$apache$spark$serializer$SerializationDebugger$$reflect() != null) {
            NotSerializableException notSerializableException;
            try {
                notSerializableException = new NotSerializableException(e.getMessage() + "\nSerialization stack:\n" + this.find(obj).map((Function1 & Serializable)x$1 -> "\t- " + x$1).mkString("\n"));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception in serialization debugger", throwable2);
                    notSerializableException = e;
                }
                throw throwable;
            }
            return notSerializableException;
        }
        return e;
    }

    public List<String> find(Object obj) {
        return new SerializationDebugger.SerializationDebugger().visit(obj, (List<String>)package$.MODULE$.List().empty());
    }

    public boolean enableDebugging() {
        return enableDebugging;
    }

    public void enableDebugging_$eq(boolean x$1) {
        enableDebugging = x$1;
    }

    public Tuple2<Object, ObjectStreamClass> org$apache$spark$serializer$SerializationDebugger$$findObjectAndDescriptor(Object o) {
        Class<?> cl;
        ObjectStreamClass desc;
        while (SerializationDebugger$ObjectStreamClassMethods$.MODULE$.hasWriteReplaceMethod$extension(this.ObjectStreamClassMethods(desc = ObjectStreamClass.lookupAny(cl = o.getClass())))) {
            Object replaced = SerializationDebugger$ObjectStreamClassMethods$.MODULE$.invokeWriteReplace$extension(this.ObjectStreamClassMethods(desc), o);
            Class<?> clazz = replaced.getClass();
            Class<?> clazz2 = o.getClass();
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return new Tuple2(replaced, (Object)desc);
            }
            o = replaced;
        }
        return new Tuple2(o, (Object)desc);
    }

    public ObjectStreamClass ObjectStreamClassMethods(ObjectStreamClass desc) {
        return desc;
    }

    public SerializationDebugger.ObjectStreamClassReflection org$apache$spark$serializer$SerializationDebugger$$reflect() {
        return org$apache$spark$serializer$SerializationDebugger$$reflect;
    }

    private final /* synthetic */ SerializationDebugger.ObjectStreamClassReflection liftedTree1$1() {
        SerializationDebugger.ObjectStreamClassReflection objectStreamClassReflection;
        try {
            objectStreamClassReflection = new SerializationDebugger.ObjectStreamClassReflection();
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot find private methods using reflection", (Throwable)e);
            objectStreamClassReflection = null;
        }
        return objectStreamClassReflection;
    }

    private SerializationDebugger$() {
    }
}

