/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.MigratableResolver;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.FallbackStorage$;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de!\u0002\r\u001a\u0001e\t\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u000bQ\u0002A\u0011A\u001b\t\u000fe\u0002!\u0019!C\u0005u!11\t\u0001Q\u0001\nmBq\u0001\u0012\u0001C\u0002\u0013%Q\t\u0003\u0004L\u0001\u0001\u0006IA\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019\t\u0006\u0001)A\u0005\u001d\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB0\u0001A\u0003%A\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0003s\u0001\u0011\u00051o\u0002\u0004\u007f3!\u00051d \u0004\b1eA\taGA\u0001\u0011\u0019!d\u0002\"\u0001\u0002\u0004!I\u0011Q\u0001\bC\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003\u001fq\u0001\u0015!\u0003\u0002\n!9\u0011\u0011\u0003\b\u0005\u0002\u0005M\u0001bBA\u000f\u001d\u0011\u0005\u0011q\u0004\u0005\b\u0003_qA\u0011AA\u0019\u0011%\tYDDI\u0001\n\u0003\ti\u0004C\u0004\u0002T9!I!!\u0016\t\u000f\u0005=d\u0002\"\u0001\u0002r\tya)\u00197mE\u0006\u001c7n\u0015;pe\u0006<WM\u0003\u0002\u001b7\u000591\u000f^8sC\u001e,'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003Wm\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003cIj\u0011aG\u0005\u0003gm\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t1\u0004\b\u0005\u00028\u00015\t\u0011\u0004C\u0003/\u0005\u0001\u0007\u0001'\u0001\u0007gC2d'-Y2l!\u0006$\b.F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0002gg*\u0011\u0001)H\u0001\u0007Q\u0006$wn\u001c9\n\u0005\tk$\u0001\u0002)bi\"\fQBZ1mY\n\f7m\u001b)bi\"\u0004\u0013A\u00035bI>|\u0007oQ8oMV\ta\t\u0005\u0002H\u00136\t\u0001J\u0003\u0002/\u007f%\u0011!\n\u0013\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0017!\fGm\\8q\u0007>tg\rI\u0001\u0013M\u0006dGNY1dW\u001aKG.Z*zgR,W.F\u0001O!\tat*\u0003\u0002Q{\tQa)\u001b7f'f\u001cH/Z7\u0002'\u0019\fG\u000e\u001c2bG.4\u0015\u000e\\3TsN$X-\u001c\u0011\u0002\u000b\u0005\u0004\b/\u00133\u0016\u0003Q\u0003\"!\u0016/\u000f\u0005YS\u0006CA,%\u001b\u0005A&BA-0\u0003\u0019a$o\\8u}%\u00111\fJ\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\I\u00051\u0011\r\u001d9JI\u0002\nAaY8qsR\u0019!-Z7\u0011\u0005\r\u001a\u0017B\u00013%\u0005\u0011)f.\u001b;\t\u000b\u0019\\\u0001\u0019A4\u0002!MDWO\u001a4mK\ncwnY6J]\u001a|\u0007C\u00015l\u001b\u0005I'B\u00016\u001c\u0003\u001d\u0019\b.\u001e4gY\u0016L!\u0001\\5\u0003!MCWO\u001a4mK\ncwnY6J]\u001a|\u0007\"\u00028\f\u0001\u0004y\u0017A\u00012n!\t9\u0004/\u0003\u0002r3\ta!\t\\8dW6\u000bg.Y4fe\u00061Q\r_5tiN$2\u0001^<}!\t\u0019S/\u0003\u0002wI\t9!i\\8mK\u0006t\u0007\"\u0002=\r\u0001\u0004I\u0018!C:ik\u001a4G.Z%e!\t\u0019#0\u0003\u0002|I\t\u0019\u0011J\u001c;\t\u000bud\u0001\u0019\u0001+\u0002\u0011\u0019LG.\u001a8b[\u0016\fqBR1mY\n\f7m[*u_J\fw-\u001a\t\u0003o9\u00192A\u0004\u0012))\u0005y\u0018!\u0007$B\u00192\u0013\u0015iQ&`\u00052{5iS0N\u0003:\u000bu)\u0012*`\u0013\u0012+\"!!\u0003\u0011\u0007]\nY!C\u0002\u0002\u000ee\u0011aB\u00117pG.l\u0015M\\1hKJLE-\u0001\u000eG\u00032c%)Q\"L?\ncujQ&`\u001b\u0006s\u0015iR#S?&#\u0005%\u0001\nhKR4\u0015\r\u001c7cC\u000e\\7\u000b^8sC\u001e,G\u0003BA\u000b\u00037\u0001BaIA\fm%\u0019\u0011\u0011\u0004\u0013\u0003\r=\u0003H/[8o\u0011\u0015q#\u00031\u00011\u0003q\u0011XmZ5ti\u0016\u0014(\t\\8dW6\u000bg.Y4fe&3g*Z3eK\u0012$rAYA\u0011\u0003W\ti\u0003C\u0004\u0002$M\u0001\r!!\n\u0002\r5\f7\u000f^3s!\r9\u0014qE\u0005\u0004\u0003SI\"A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJDQAL\nA\u0002ABQ\u0001R\nA\u0002\u0019\u000bqa\u00197fC:,\u0006\u000fF\u0004c\u0003g\t)$a\u000e\t\u000b9\"\u0002\u0019\u0001\u0019\t\u000b\u0011#\u0002\u0019\u0001$\t\u0011a$\u0002\u0013!a\u0001\u0003s\u0001BaIA\fs\u0006\t2\r\\3b]V\u0003H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}\"\u0006BA\u001d\u0003\u0003Z#!a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\"\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011KA$\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012e\u0016\u0004xN\u001d;CY>\u001c7n\u0015;biV\u001cHc\u0002;\u0002X\u0005m\u0013Q\r\u0005\u0007\u000332\u0002\u0019A8\u0002\u0019\tdwnY6NC:\fw-\u001a:\t\u000f\u0005uc\u00031\u0001\u0002`\u00059!\r\\8dW&#\u0007cA\u001c\u0002b%\u0019\u00111M\r\u0003\u000f\tcwnY6JI\"9\u0011q\r\fA\u0002\u0005%\u0014A\u00033bi\u0006dUM\\4uQB\u00191%a\u001b\n\u0007\u00055DE\u0001\u0003M_:<\u0017\u0001\u0002:fC\u0012$b!a\u001d\u0002\u0004\u0006\u0015\u0005\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0007EV4g-\u001a:\u000b\u0007\u0005u4$A\u0004oKR<xN]6\n\t\u0005\u0005\u0015q\u000f\u0002\u000e\u001b\u0006t\u0017mZ3e\u0005V4g-\u001a:\t\u000b9:\u0002\u0019\u0001\u0019\t\u000f\u0005us\u00031\u0001\u0002`\u0001")
public class FallbackStorage
implements Logging {
    private final Path fallbackPath;
    private final Configuration hadoopConf;
    private final FileSystem fallbackFileSystem;
    private final String appId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static ManagedBuffer read(SparkConf conf, BlockId blockId) {
        return FallbackStorage$.MODULE$.read(conf, blockId);
    }

    public static Option<Object> cleanUp$default$3() {
        return FallbackStorage$.MODULE$.cleanUp$default$3();
    }

    public static void cleanUp(SparkConf conf, Configuration hadoopConf, Option<Object> shuffleId) {
        FallbackStorage$.MODULE$.cleanUp(conf, hadoopConf, shuffleId);
    }

    public static void registerBlockManagerIfNeeded(BlockManagerMaster master, SparkConf conf, Configuration hadoopConf) {
        FallbackStorage$.MODULE$.registerBlockManagerIfNeeded(master, conf, hadoopConf);
    }

    public static Option<FallbackStorage> getFallbackStorage(SparkConf conf) {
        return FallbackStorage$.MODULE$.getFallbackStorage(conf);
    }

    public static BlockManagerId FALLBACK_BLOCK_MANAGER_ID() {
        return FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Path fallbackPath() {
        return this.fallbackPath;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileSystem fallbackFileSystem() {
        return this.fallbackFileSystem;
    }

    private String appId() {
        return this.appId;
    }

    public void copy(ShuffleBlockInfo shuffleBlockInfo, BlockManager bm) {
        int shuffleId = shuffleBlockInfo.shuffleId();
        long mapId = shuffleBlockInfo.mapId();
        MigratableResolver migratableResolver = bm.migratableResolver();
        if (migratableResolver instanceof IndexShuffleBlockResolver) {
            IndexShuffleBlockResolver indexShuffleBlockResolver = (IndexShuffleBlockResolver)migratableResolver;
            File indexFile = indexShuffleBlockResolver.getIndexFile(shuffleId, mapId, indexShuffleBlockResolver.getIndexFile$default$3());
            if (indexFile.exists()) {
                int hash = JavaUtils.nonNegativeHash((Object)indexFile.getName());
                this.fallbackFileSystem().copyFromLocalFile(new Path(Utils$.MODULE$.resolveURI(indexFile.getAbsolutePath())), new Path(this.fallbackPath(), this.appId() + "/" + shuffleId + "/" + hash + "/" + indexFile.getName()));
                File dataFile = indexShuffleBlockResolver.getDataFile(shuffleId, mapId);
                if (dataFile.exists()) {
                    int hash2 = JavaUtils.nonNegativeHash((Object)dataFile.getName());
                    this.fallbackFileSystem().copyFromLocalFile(new Path(Utils$.MODULE$.resolveURI(dataFile.getAbsolutePath())), new Path(this.fallbackPath(), this.appId() + "/" + shuffleId + "/" + hash2 + "/" + dataFile.getName()));
                }
                int reduceId = IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
                ShuffleIndexBlockId indexBlockId = new ShuffleIndexBlockId(shuffleId, mapId, reduceId);
                FallbackStorage$.MODULE$.org$apache$spark$storage$FallbackStorage$$reportBlockStatus(bm, indexBlockId, indexFile.length());
                if (dataFile.exists()) {
                    ShuffleDataBlockId dataBlockId = new ShuffleDataBlockId(shuffleId, mapId, reduceId);
                    FallbackStorage$.MODULE$.org$apache$spark$storage$FallbackStorage$$reportBlockStatus(bm, dataBlockId, dataFile.length());
                    return;
                }
                return;
            }
            return;
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Resolver: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CLASS_NAME, migratableResolver.getClass().getName())}))));
    }

    public boolean exists(int shuffleId, String filename) {
        int hash = JavaUtils.nonNegativeHash((Object)filename);
        return this.fallbackFileSystem().exists(new Path(this.fallbackPath(), this.appId() + "/" + shuffleId + "/" + hash + "/" + filename));
    }

    public FallbackStorage(SparkConf conf) {
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(conf.contains("spark.app.id"));
        Predef$.MODULE$.require(((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined());
        this.fallbackPath = new Path((String)((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).get());
        this.hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(conf);
        this.fallbackFileSystem = FileSystem.get((URI)this.fallbackPath().toUri(), (Configuration)this.hadoopConf());
        this.appId = conf.getAppId();
    }
}

