/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.AbstractFetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class FetchShuffleBlockChunks
extends AbstractFetchShuffleBlocks {
    public final int[] reduceIds;
    public final int[][] chunkIds;
    public final int shuffleMergeId;

    public FetchShuffleBlockChunks(String appId, String execId, int shuffleId, int shuffleMergeId, int[] reduceIds, int[][] chunkIds) {
        super(appId, execId, shuffleId);
        this.shuffleMergeId = shuffleMergeId;
        this.reduceIds = reduceIds;
        this.chunkIds = chunkIds;
        assert (reduceIds.length == chunkIds.length);
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.FETCH_SHUFFLE_BLOCK_CHUNKS;
    }

    public String toString() {
        return "FetchShuffleBlockChunks[appId=" + this.appId + ",execId=" + this.execId + ",shuffleId=" + this.shuffleId + ",shuffleMergeId=" + this.shuffleMergeId + ",reduceIds=" + Arrays.toString(this.reduceIds) + ",chunkIds=" + Arrays.deepToString((Object[])this.chunkIds) + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchShuffleBlockChunks that = (FetchShuffleBlockChunks)o;
        if (!super.equals(that)) {
            return false;
        }
        if (this.shuffleMergeId != that.shuffleMergeId || !Arrays.equals(this.reduceIds, that.reduceIds)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.chunkIds, (Object[])that.chunkIds);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() * 31 + this.shuffleMergeId;
        result = 31 * result + Arrays.hashCode(this.reduceIds);
        result = 31 * result + Arrays.deepHashCode((Object[])this.chunkIds);
        return result;
    }

    @Override
    public int encodedLength() {
        int encodedLengthOfChunkIds = 0;
        for (int[] ids : this.chunkIds) {
            encodedLengthOfChunkIds += Encoders.IntArrays.encodedLength((int[])ids);
        }
        return super.encodedLength() + Encoders.IntArrays.encodedLength((int[])this.reduceIds) + 4 + 4 + encodedLengthOfChunkIds;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeInt(this.shuffleMergeId);
        Encoders.IntArrays.encode((ByteBuf)buf, (int[])this.reduceIds);
        buf.writeInt(this.chunkIds.length);
        for (int[] ids : this.chunkIds) {
            Encoders.IntArrays.encode((ByteBuf)buf, (int[])ids);
        }
    }

    @Override
    public int getNumBlocks() {
        int numBlocks = 0;
        for (int[] ids : this.chunkIds) {
            numBlocks += ids.length;
        }
        return numBlocks;
    }

    public static FetchShuffleBlockChunks decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        int shuffleId = buf.readInt();
        int shuffleMergeId = buf.readInt();
        int[] reduceIds = Encoders.IntArrays.decode((ByteBuf)buf);
        int chunkIdsLen = buf.readInt();
        int[][] chunkIds = new int[chunkIdsLen][];
        for (int i = 0; i < chunkIdsLen; ++i) {
            chunkIds[i] = Encoders.IntArrays.decode((ByteBuf)buf);
        }
        return new FetchShuffleBlockChunks(appId, execId, shuffleId, shuffleMergeId, reduceIds, chunkIds);
    }
}

