/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.roaringbitmap.RoaringBitmap;

public class MergeStatuses
extends BlockTransferMessage {
    public final int shuffleId;
    public final int shuffleMergeId;
    public final RoaringBitmap[] bitmaps;
    public final int[] reduceIds;
    public final long[] sizes;

    public MergeStatuses(int shuffleId, int shuffleMergeId, RoaringBitmap[] bitmaps, int[] reduceIds, long[] sizes) {
        this.shuffleId = shuffleId;
        this.shuffleMergeId = shuffleMergeId;
        this.bitmaps = bitmaps;
        this.reduceIds = reduceIds;
        this.sizes = sizes;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.MERGE_STATUSES;
    }

    public int hashCode() {
        int objectHashCode = Objects.hashCode(this.shuffleId) * 41 + Objects.hashCode(this.shuffleMergeId);
        return objectHashCode * 41 + Arrays.hashCode(this.reduceIds) * 41 + Arrays.hashCode(this.bitmaps) * 41 + Arrays.hashCode(this.sizes);
    }

    public String toString() {
        return "MergeStatuses[shuffleId=" + this.shuffleId + ",shuffleMergeId=" + this.shuffleMergeId + ",reduceId size=" + this.reduceIds.length + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof MergeStatuses) {
            MergeStatuses o = (MergeStatuses)other;
            return Objects.equals(this.shuffleId, o.shuffleId) && Objects.equals(this.shuffleMergeId, o.shuffleMergeId) && Arrays.equals(this.bitmaps, o.bitmaps) && Arrays.equals(this.reduceIds, o.reduceIds) && Arrays.equals(this.sizes, o.sizes);
        }
        return false;
    }

    public int encodedLength() {
        return 8 + Encoders.BitmapArrays.encodedLength((RoaringBitmap[])this.bitmaps) + Encoders.IntArrays.encodedLength((int[])this.reduceIds) + Encoders.LongArrays.encodedLength((long[])this.sizes);
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.shuffleMergeId);
        Encoders.BitmapArrays.encode((ByteBuf)buf, (RoaringBitmap[])this.bitmaps);
        Encoders.IntArrays.encode((ByteBuf)buf, (int[])this.reduceIds);
        Encoders.LongArrays.encode((ByteBuf)buf, (long[])this.sizes);
    }

    public static MergeStatuses decode(ByteBuf buf) {
        int shuffleId = buf.readInt();
        int shuffleMergeId = buf.readInt();
        RoaringBitmap[] bitmaps = Encoders.BitmapArrays.decode((ByteBuf)buf);
        int[] reduceIds = Encoders.IntArrays.decode((ByteBuf)buf);
        long[] sizes = Encoders.LongArrays.decode((ByteBuf)buf);
        return new MergeStatuses(shuffleId, shuffleMergeId, bitmaps, reduceIds, sizes);
    }
}

