/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.ClusterData;
import org.apache.spark.ml.clustering.ClusterData$;
import org.apache.spark.ml.clustering.KMeansModel$;
import org.apache.spark.ml.clustering.KMeansModel$KMeansModelReader$;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.BaseReadWrite;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.GeneralMLWritable;
import org.apache.spark.ml.util.GeneralMLWriter;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SizeEstimator$;
import org.apache.spark.util.VersionUtils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\rUb\u0001\u0002\u001d:\u0001\u0011C\u0001B\u0017\u0001\u0003\u0006\u0004%\te\u0017\u0005\te\u0002\u0011\t\u0011)A\u00059\"IA\u000f\u0001BC\u0002\u0013\u0005\u0011(\u001e\u0005\ty\u0002\u0011\t\u0011)A\u0005m\"1Q\u0010\u0001C\u0001wyDq! \u0001\u0005\u0002m\n)\u0001\u0003\u0006\u0002\b\u0001A)\u0019!C\u0001\u0003\u0013Aq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011q\t\u0001\u0005B\u0005%\u0003bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003D\u0001\"a3\u0001\t\u0003Y\u0014Q\u001a\u0005\b\u0003+\u0004A\u0011IAl\u0011\u001d\t)\u000f\u0001C!\u0003ODq!a;\u0001\t\u0003\ni\u000f\u0003\u0005\u0002r\u0002!\t%PAz\u0011!\tY\u0010\u0001C\u0001{\u0005u\b\u0002\u0003B\f\u0001\u0011\u0005SH!\u0007\t\u0011\t}\u0001\u0001\"\u0011>\u0005C9qA!\u000b:\u0011\u0003\u0011YC\u0002\u00049s!\u0005!Q\u0006\u0005\u0007{b!\tAa\u0013\t\u000f\t5\u0003\u0004\"\u0011\u0003P!9!\u0011\f\r\u0005B\tmca\u0002B11\u0001[$1\r\u0005\u000b\u0003\u007fc\"Q3A\u0005\u0002\te\u0004B\u0003BC9\tE\t\u0015!\u0003\u0003|!1Q\u0010\bC\u0001\u0005\u000fC\u0011\"!\u0007\u001d\u0003\u0003%\tAa$\t\u0013\tME$%A\u0005\u0002\tU\u0005\"\u0003BU9\u0005\u0005I\u0011\tBV\u0011%\u00119\fHA\u0001\n\u0003\tI\u0001C\u0005\u0003:r\t\t\u0011\"\u0001\u0003<\"I!\u0011\u0019\u000f\u0002\u0002\u0013\u0005#1\u0019\u0005\n\u0005#d\u0012\u0011!C\u0001\u0005'D\u0011B!8\u001d\u0003\u0003%\tEa8\t\u0013\t\rH$!A\u0005B\t\u0015\b\"CAs9\u0005\u0005I\u0011\tBt\u0011%\u0011I\u000fHA\u0001\n\u0003\u0012Yo\u0002\u0006\u0003pb\t\t\u0011#\u0001<\u0005c4!B!\u0019\u0019\u0003\u0003E\ta\u000fBz\u0011\u0019iH\u0006\"\u0001\u0004\u0002!I\u0011Q\u001d\u0017\u0002\u0002\u0013\u0015#q\u001d\u0005\n\u0007\u0007a\u0013\u0011!CA\u0007\u000bA\u0011b!\u0003-\u0003\u0003%\tia\u0003\t\u0013\r]A&!A\u0005\n\reaABB\u00111\u0011\u0019\u0019\u0003\u0003\u0004~e\u0011\u00051Q\u0005\u0005\n\u0007S\u0011$\u0019!C\u0005\u0005WC\u0001ba\u000b3A\u0003%!Q\u0016\u0005\b\u00053\u0012D\u0011IB\u0017\u0011%\u00199\u0002GA\u0001\n\u0013\u0019IBA\u0006L\u001b\u0016\fgn]'pI\u0016d'B\u0001\u001e<\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003yu\n!!\u001c7\u000b\u0005yz\u0014!B:qCJ\\'B\u0001!B\u0003\u0019\t\u0007/Y2iK*\t!)A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u000b.sE\u000bE\u0002G\u000f&k\u0011aO\u0005\u0003\u0011n\u0012Q!T8eK2\u0004\"A\u0013\u0001\u000e\u0003e\u0002\"A\u0013'\n\u00055K$\u0001D&NK\u0006t7\u000fU1sC6\u001c\bCA(S\u001b\u0005\u0001&BA)<\u0003\u0011)H/\u001b7\n\u0005M\u0003&!E$f]\u0016\u0014\u0018\r\\'M/JLG/\u00192mKB\u0019q*V,\n\u0005Y\u0003&A\u0005%bgR\u0013\u0018-\u001b8j]\u001e\u001cV/\\7bef\u0004\"A\u0013-\n\u0005eK$!D&NK\u0006t7oU;n[\u0006\u0014\u00180A\u0002vS\u0012,\u0012\u0001\u0018\t\u0003;\u001at!A\u00183\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\u001c\u0015A\u0002\u001fs_>$hHC\u0001d\u0003\u0015\u00198-\u00197b\u0013\t)'-\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3cQ\r\t!\u000e\u001d\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[v\n!\"\u00198o_R\fG/[8o\u0013\tyGNA\u0003TS:\u001cW-I\u0001r\u0003\u0015\td&\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\tQ\u0007/A\u0006qCJ,g\u000e^'pI\u0016dW#\u0001<\u0011\u0005]\\X\"\u0001=\u000b\u0005iJ(B\u0001>>\u0003\u0015iG\u000e\\5c\u0013\tA\u00040\u0001\u0007qCJ,g\u000e^'pI\u0016d\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u0013~\f\u0019\u0001C\u0003[\u000b\u0001\u0007A\fK\u0002\u0000UBDQ\u0001^\u0003A\u0002Y$\u0012!S\u0001\f]Vlg)Z1ukJ,7/\u0006\u0002\u0002\fA!\u0011QBA\b\u001b\u0005\u0011\u0017bAA\tE\n\u0019\u0011J\u001c;)\t\u001dQ\u0017QC\u0011\u0003\u0003/\tQa\r\u00181]A\nAaY8qsR\u0019\u0011*!\b\t\u000f\u0005}\u0001\u00021\u0001\u0002\"\u0005)Q\r\u001f;sCB!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(m\nQ\u0001]1sC6LA!a\u000b\u0002&\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\tUB\fab]3u\r\u0016\fG/\u001e:fg\u000e{G\u000e\u0006\u0003\u00024\u0005UR\"\u0001\u0001\t\r\u0005]\u0012\u00021\u0001]\u0003\u00151\u0018\r\\;fQ\u0011I!.a\u000f\"\u0005\u0005u\u0012!\u0002\u001a/a9\u0002\u0014\u0001E:fiB\u0013X\rZ5di&|gnQ8m)\u0011\t\u0019$a\u0011\t\r\u0005]\"\u00021\u0001]Q\u0011Q!.a\u000f\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA&\u0003[\u0002B!!\u0014\u0002h9!\u0011qJA1\u001d\u0011\t\t&!\u0018\u000f\t\u0005M\u00131\f\b\u0005\u0003+\nIFD\u0002`\u0003/J\u0011AQ\u0005\u0003\u0001\u0006K!AP \n\u0007\u0005}S(A\u0002tc2LA!a\u0019\u0002f\u00059\u0001/Y2lC\u001e,'bAA0{%!\u0011\u0011NA6\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002d\u0005\u0015\u0004bBA8\u0017\u0001\u0007\u0011\u0011O\u0001\bI\u0006$\u0018m]3ua\u0011\t\u0019(a \u0011\r\u0005U\u0014qOA>\u001b\t\t)'\u0003\u0003\u0002z\u0005\u0015$a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003{\ny\b\u0004\u0001\u0005\u0019\u0005\u0005\u0015QNA\u0001\u0002\u0003\u0015\t!a!\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0006\u0006-\u0005\u0003BA\u0007\u0003\u000fK1!!#c\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0004\u0002\u000e&\u0019\u0011q\u00122\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\fU\u0006m\u0012a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005]\u00151\u0015\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*!\u0011QTA3\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t+a'\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002&2\u0001\r!a&\u0002\rM\u001c\u0007.Z7bQ\ra!\u000e]\u0001\baJ,G-[2u)\u0011\tY!!,\t\u000f\u0005=V\u00021\u0001\u00022\u0006Aa-Z1ukJ,7\u000f\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9lO\u0001\u0007Y&t\u0017\r\\4\n\t\u0005m\u0016Q\u0017\u0002\u0007-\u0016\u001cGo\u001c:)\t5Q\u0017QC\u0001\u000fG2,8\u000f^3s\u0007\u0016tG/\u001a:t+\t\t\u0019\r\u0005\u0004\u0002\u000e\u0005\u0015\u0017\u0011W\u0005\u0004\u0003\u000f\u0014'!B!se\u0006L\b\u0006\u0002\bk\u0003w\t1c\u00197vgR,'oQ3oi\u0016\u0014X*\u0019;sSb,\"!a4\u0011\t\u0005M\u0016\u0011[\u0005\u0005\u0003'\f)L\u0001\u0004NCR\u0014\u0018\u000e_\u0001\u0006oJLG/Z\u000b\u0003\u00033\u00042aTAn\u0013\r\ti\u000e\u0015\u0002\u0010\u000f\u0016tWM]1m\u001b2;&/\u001b;fe\"\"\u0001C[AqC\t\t\u0019/A\u00032]Yr\u0003'\u0001\u0005u_N#(/\u001b8h)\u0005a\u0006\u0006B\tk\u0003+\tqa];n[\u0006\u0014\u00180F\u0001XQ\u0011\u0011\".a\u000f\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f+\t\t)\u0010\u0005\u0003\u0002\u000e\u0005]\u0018bAA}E\n!Aj\u001c8h\u00035\u0019'/Z1uKN+X.\\1ssRA\u0011q B\u0003\u0005\u0013\u0011i\u0001\u0005\u0003\u0002\u000e\t\u0005\u0011b\u0001B\u0002E\n!QK\\5u\u0011\u001d\u00119\u0001\u0006a\u0001\u0003\u0017\n1\u0002\u001d:fI&\u001cG/[8og\"9!1\u0002\u000bA\u0002\u0005-\u0011a\u00028v[&#XM\u001d\u0005\b\u0005\u001f!\u0002\u0019\u0001B\t\u00031!(/Y5oS:<7i\\:u!\u0011\tiAa\u0005\n\u0007\tU!M\u0001\u0004E_V\u0014G.Z\u0001\fg\u00064XmU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0002\u0000\nm\u0001B\u0002B\u000f+\u0001\u0007A,\u0001\u0003qCRD\u0017a\u00037pC\u0012\u001cV/\\7bef$b!a@\u0003$\t\u0015\u0002B\u0002B\u000f-\u0001\u0007A\fC\u0004\u0002pY\u0001\r!a\u0013)\u0007\u0001Q\u0007/A\u0006L\u001b\u0016\fgn]'pI\u0016d\u0007C\u0001&\u0019'\u001dA\"q\u0006B\u001b\u0005w\u0001B!!\u0004\u00032%\u0019!1\u00072\u0003\r\u0005s\u0017PU3g!\u0011y%qG%\n\u0007\te\u0002K\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004BA!\u0010\u0003H5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%\u0001\u0002j_*\u0011!QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003J\t}\"\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u0016\u0003\u0011\u0011X-\u00193\u0016\u0005\tE\u0003\u0003B(\u0003T%K1A!\u0016Q\u0005!iEJU3bI\u0016\u0014\b\u0006\u0002\u000ek\u0003C\fA\u0001\\8bIR\u0019\u0011J!\u0018\t\r\tu1\u00041\u0001]Q\u0011Y\".!9\u0003\u000f=cG\rR1uCN9ADa\f\u0003f\t-\u0004\u0003BA\u0007\u0005OJ1A!\u001bc\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u001c\u0003v9!!q\u000eB:\u001d\ry&\u0011O\u0005\u0002G&\u0019\u00111\r2\n\t\t%#q\u000f\u0006\u0004\u0003G\u0012WC\u0001B>!\u0019\ti!!2\u0003~A!!q\u0010BB\u001b\t\u0011\tIC\u0002\u00028fLA!a/\u0003\u0002\u0006y1\r\\;ti\u0016\u00148)\u001a8uKJ\u001c\b\u0005\u0006\u0003\u0003\n\n5\u0005c\u0001BF95\t\u0001\u0004C\u0004\u0002@~\u0001\rAa\u001f\u0015\t\t%%\u0011\u0013\u0005\n\u0003\u007f\u0003\u0003\u0013!a\u0001\u0005w\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0018*\"!1\u0010BMW\t\u0011Y\n\u0005\u0003\u0003\u001e\n\u0015VB\u0001BP\u0015\u0011\u0011\tKa)\u0002\u0013Ut7\r[3dW\u0016$'BA7c\u0013\u0011\u00119Ka(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005[\u0003BAa,\u000366\u0011!\u0011\u0017\u0006\u0005\u0005g\u0013\u0019%\u0001\u0003mC:<\u0017bA4\u00032\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAF\u0005{C\u0011Ba0%\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\r\u0005\u0004\u0003H\n5\u00171R\u0007\u0003\u0005\u0013T1Aa3c\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001f\u0014IM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002Bk\u00057\u0004B!!\u0004\u0003X&\u0019!\u0011\u001c2\u0003\u000f\t{w\u000e\\3b]\"I!q\u0018\u0014\u0002\u0002\u0003\u0007\u00111R\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003.\n\u0005\b\"\u0003B`O\u0005\u0005\t\u0019AA\u0006\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0006)\t\u0011i+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005+\u0014i\u000fC\u0005\u0003@*\n\t\u00111\u0001\u0002\f\u00069q\n\u001c3ECR\f\u0007c\u0001BFYM)AF!>\u0003<AA!q\u001fB\u007f\u0005w\u0012I)\u0004\u0002\u0003z*\u0019!1 2\u0002\u000fI,h\u000e^5nK&!!q B}\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0005c\fQ!\u00199qYf$BA!#\u0004\b!9\u0011qX\u0018A\u0002\tm\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u001b\u0019\u0019\u0002\u0005\u0004\u0002\u000e\r=!1P\u0005\u0004\u0007#\u0011'AB(qi&|g\u000eC\u0005\u0004\u0016A\n\t\u00111\u0001\u0003\n\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\rm\u0001\u0003\u0002BX\u0007;IAaa\b\u00032\n1qJ\u00196fGR\u0014\u0011cS'fC:\u001cXj\u001c3fYJ+\u0017\rZ3s'\r\u0011$\u0011\u000b\u000b\u0003\u0007O\u00012Aa#3\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\"2!SB\u0018\u0011\u0019\u0011iB\u000ea\u00019\"\"\u0001D[AqQ\u00119\".!9")
public class KMeansModel
extends Model<KMeansModel>
implements KMeansParams,
GeneralMLWritable,
HasTrainingSummary<KMeansSummary> {
    private int numFeatures;
    private final String uid;
    private final org.apache.spark.mllib.clustering.KMeansModel parentModel;
    private Option<KMeansSummary> trainingSummary;
    private IntParam k;
    private Param<String> initMode;
    private IntParam initSteps;
    private Param<String> solver;
    private DoubleParam maxBlockSizeInMB;
    private Param<String> weightCol;
    private Param<String> distanceMeasure;
    private DoubleParam tol;
    private Param<String> predictionCol;
    private LongParam seed;
    private Param<String> featuresCol;
    private IntParam maxIter;
    private volatile boolean bitmap$0;

    public static KMeansModel load(String path) {
        return KMeansModel$.MODULE$.load(path);
    }

    public static MLReader<KMeansModel> read() {
        return KMeansModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<KMeansSummary> setSummary(Option<KMeansSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return KMeansParams.getK$(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams.getInitMode$(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams.getInitSteps$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Option<KMeansSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<KMeansSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param<String> x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.clustering.KMeansModel parentModel() {
        return this.parentModel;
    }

    private int numFeatures$lzycompute() {
        KMeansModel kMeansModel = this;
        synchronized (kMeansModel) {
            if (!this.bitmap$0) {
                this.numFeatures = ((Vector)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.parentModel().clusterCenters()))).size();
                this.bitmap$0 = true;
            }
        }
        return this.numFeatures;
    }

    public int numFeatures() {
        if (!this.bitmap$0) {
            return this.numFeatures$lzycompute();
        }
        return this.numFeatures;
    }

    @Override
    public KMeansModel copy(ParamMap extra) {
        KMeansModel copied = this.copyValues(new KMeansModel(this.uid(), this.parentModel()), extra);
        return (KMeansModel)((Model)((Object)copied.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    public KMeansModel setFeaturesCol(String value) {
        return (KMeansModel)this.set(this.featuresCol(), value);
    }

    public KMeansModel setPredictionCol(String value) {
        return (KMeansModel)this.set(this.predictionCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1(KMeansModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1(null)));
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})), outputSchema.apply(this.$(this.predictionCol())).metadata());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = this.validateAndTransformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateNumValues(outputSchema, this.$(this.predictionCol()), this.parentModel().k());
        }
        return outputSchema;
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        return this.parentModel().predict(Vectors$.MODULE$.fromML(features));
    }

    public org.apache.spark.ml.linalg.Vector[] clusterCenters() {
        return (org.apache.spark.ml.linalg.Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.parentModel().clusterCenters()), (Function1 & Serializable)x$1 -> x$1.asML(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class));
    }

    public Matrix clusterCenterMatrix() {
        return Matrices$.MODULE$.fromVectors(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.clusterCenters())));
    }

    @Override
    public GeneralMLWriter write() {
        return new GeneralMLWriter(this);
    }

    @Override
    public String toString() {
        return "KMeansModel: uid=" + this.uid() + ", k=" + this.parentModel().k() + ", distanceMeasure=" + this.$(this.distanceMeasure()) + ", numFeatures=" + this.numFeatures();
    }

    @Override
    public KMeansSummary summary() {
        return (KMeansSummary)HasTrainingSummary.summary$(this);
    }

    @Override
    public long estimatedSize() {
        return SizeEstimator$.MODULE$.estimate((Object)this.parentModel().clusterCenters());
    }

    public void createSummary(Dataset<Row> predictions, int numIter, double trainingCost) {
        KMeansSummary summary = new KMeansSummary(predictions, this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), numIter, trainingCost);
        this.setSummary((Option<KMeansSummary>)new Some((Object)summary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$2(KMeansModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple2.mcID.sp(this.summary().numIter(), this.summary().trainingCost()), (Function2 & Serializable)(data, dos) -> {
            KMeansModel.$anonfun$saveSummary$1(data, dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$2(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        int n;
        double trainingCost;
        block3: {
            Tuple2 tuple2;
            block2: {
                public final class Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$3
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$3(KMeansModel $outer) {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModel.class.getClassLoader());
                tuple2 = (Tuple2)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> {
                    int numIter = dis.readInt();
                    double trainingCost = dis.readDouble();
                    return new Tuple2.mcID.sp(numIter, trainingCost);
                }, ClassTag$.MODULE$.apply(Tuple2.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$3(null)));
                if (tuple2 == null) break block2;
                int numIter = tuple2._1$mcI$sp();
                trainingCost = tuple2._2$mcD$sp();
                if (!true) break block2;
                n = numIter;
                if (true) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        double d = trainingCost;
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(n, d);
        int numIter = sp2._1$mcI$sp();
        double trainingCost2 = sp2._2$mcD$sp();
        this.createSummary(dataset, numIter, trainingCost2);
    }

    public static final /* synthetic */ void $anonfun$saveSummary$1(Tuple2 data, DataOutputStream dos) {
        dos.writeInt(data._1$mcI$sp());
        dos.writeDouble(data._2$mcD$sp());
    }

    public KMeansModel(String uid, org.apache.spark.mllib.clustering.KMeansModel parentModel) {
        this.uid = uid;
        this.parentModel = parentModel;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasTol.$init$(this);
        HasDistanceMeasure.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        KMeansParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Statics.releaseFence();
    }

    public KMeansModel() {
        this("", null);
    }

    private static class KMeansModelReader
    extends MLReader<KMeansModel> {
        private final String className = KMeansModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public KMeansModel load(String path) {
            Vector[] vectorArray;
            SparkSession sparkSession = BaseReadWrite.sparkSession$(this);
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, sparkSession, this.className());
            String dataPath = new Path(path, "data").toString();
            if (VersionUtils$.MODULE$.majorVersion(metadata.sparkVersion()) >= 2) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator1$5
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.clustering.ClusterData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator1$5(KMeansModelReader $outer) {
                    }
                }
                ClusterData[] data = (ClusterData[])ReadWriteUtils$.MODULE$.loadArray(dataPath, sparkSession, (Function1 & Serializable)dis -> ClusterData$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(ClusterData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator1$5(null)));
                vectorArray = (Vector[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])data), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.clusterIdx()), (Ordering)Ordering.Int$.MODULE$)), (Function1 & Serializable)x$4 -> x$4.clusterCenter(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class))), (Function1 & Serializable)v -> Vectors$.MODULE$.fromML((org.apache.spark.ml.linalg.Vector)v), ClassTag$.MODULE$.apply(Vector.class));
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.clustering.KMeansModel.OldData").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator6$1(KMeansModelReader $outer) {
                    }
                }
                vectorArray = ((OldData)sparkSession.read().parquet(dataPath).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator6$1(null)))).head()).clusterCenters();
            }
            Vector[] clusterCenters = vectorArray;
            KMeansModel model = new KMeansModel(metadata.uid(), new org.apache.spark.mllib.clustering.KMeansModel(clusterCenters));
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class OldData
    implements Product,
    Serializable {
        private final Vector[] clusterCenters;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Vector[] clusterCenters() {
            return this.clusterCenters;
        }

        public OldData copy(Vector[] clusterCenters) {
            return new OldData(clusterCenters);
        }

        public Vector[] copy$default$1() {
            return this.clusterCenters();
        }

        public String productPrefix() {
            return "OldData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clusterCenters();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof OldData;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clusterCenters";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 171302923, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof OldData)) return false;
            boolean bl = true;
            if (!bl) return false;
            OldData oldData = (OldData)x$1;
            if (this.clusterCenters() != oldData.clusterCenters()) return false;
            if (!oldData.canEqual(this)) return false;
            return true;
        }

        public OldData(Vector[] clusterCenters) {
            this.clusterCenters = clusterCenters;
            Product.$init$((Product)this);
        }
    }
}

