/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleRegressorParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t%g\u0001B\u0017/\u0001eB\u0001\"\u001a\u0001\u0003\u0006\u0004%\tE\u001a\u0005\t_\u0002\u0011\t\u0011)A\u0005O\"A\u0001\u000f\u0001BC\u0002\u0013%\u0011\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003s\u0011!9\bA!b\u0001\n\u0013A\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0011y\u0004!Q1A\u0005B}D!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011!\tI\u0001\u0001C\u0001a\u0005-\u0001bBA\u0005\u0001\u0011\u0005\u0011Q\u0003\u0005\t\u0003\u0013\u0001A\u0011\u0001\u0019\u00020!A\u0011\u0011\u0007\u0001\u0005BI\n\u0019\u0004\u0003\u0004\u0002<\u0001!\t%\u001d\u0005\t\u0003\u007f\u0001!\u0019!C\u0001\u007f\"A\u0011q\t\u0001!\u0002\u0013\t\t\u0001\u0003\u0004\u0002L\u0001!\t\u0005\u001f\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\tI\u0007\u0001C!\u0003WBq!!,\u0001\t\u0003\ny\u000bC\u0004\u00026\u0002!\t%a.\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\"Q\u0011\u0011\u001b\u0001\t\u0006\u0004%\t!a5\t\u0011\u0005]\u0007\u0001\"\u00011\u00033Dq!!<\u0001\t\u0003\ty\u000fC\u0004\u0003\b\u0001!\tE!\u0003\b\u000f\tUa\u0006#\u0001\u0003\u0018\u00191QF\fE\u0001\u00053Aq!!\u0003\u001c\t\u0003\u0011)\u0004C\u0004\u00038m!\tE!\u000f\t\u000f\t\r3\u0004\"\u0011\u0003F\u00199!QJ\u000e\u00017\t=\u0003\"\u0003B)?\t\u0005\t\u0015!\u0003E\u0011\u001d\tIa\bC\u0001\u0005'BqAa\u0017 \t#\u0012iF\u0002\u0004\u0003hm!!\u0011\u000e\u0005\b\u0003\u0013\u0019C\u0011\u0001B6\u0011%\u0011yg\tb\u0001\n\u0013\u0011\t\b\u0003\u0005\u0003~\r\u0002\u000b\u0011\u0002B:\u0011%\u0011yh\tb\u0001\n\u0013\u0011\t\b\u0003\u0005\u0003\u0002\u000e\u0002\u000b\u0011\u0002B:\u0011\u001d\u0011\u0019e\tC!\u0005\u0007C\u0001Ba\"\u001c\t\u0003\u0001$\u0011\u0012\u0005\u000b\u0005K[\u0012\u0013!C\u0001a\t\u001d\u0006\"\u0003B^7\u0005\u0005I\u0011\u0002B_\u0005I9%\t\u0016*fOJ,7o]5p]6{G-\u001a7\u000b\u0005=\u0002\u0014A\u0003:fOJ,7o]5p]*\u0011\u0011GM\u0001\u0003[2T!a\r\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U2\u0014AB1qC\u000eDWMC\u00018\u0003\ry'oZ\u0002\u0001'\u0019\u0001!(R&R/B!1\b\u0010 E\u001b\u0005q\u0013BA\u001f/\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA C\u001b\u0005\u0001%BA!1\u0003\u0019a\u0017N\\1mO&\u00111\t\u0011\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005m\u0002\u0001C\u0001$J\u001b\u00059%B\u0001%1\u0003\u0011!(/Z3\n\u0005);%AE$C)J+wM]3tg>\u0014\b+\u0019:b[N\u00042A\u0012'O\u0013\tiuIA\tUe\u0016,WI\\:f[\ndW-T8eK2\u0004\"aO(\n\u0005As#a\u0007#fG&\u001c\u0018n\u001c8Ue\u0016,'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002S+6\t1K\u0003\u0002Ua\u0005!Q\u000f^5m\u0013\t16K\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\u0004\"\u0001\u00172\u000f\u0005e{fB\u0001.^\u001b\u0005Y&B\u0001/9\u0003\u0019a$o\\8u}%\ta,A\u0003tG\u0006d\u0017-\u0003\u0002aC\u00069\u0001/Y2lC\u001e,'\"\u00010\n\u0005\r$'\u0001D*fe&\fG.\u001b>bE2,'B\u00011b\u0003\r)\u0018\u000eZ\u000b\u0002OB\u0011\u0001\u000e\u001c\b\u0003S*\u0004\"AW1\n\u0005-\f\u0017A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a[1\u0002\tULG\rI\u0001\u0007?R\u0014X-Z:\u0016\u0003I\u00042a\u001d;O\u001b\u0005\t\u0017BA;b\u0005\u0015\t%O]1z\u0003\u001dyFO]3fg\u0002\nAb\u0018;sK\u0016<V-[4iiN,\u0012!\u001f\t\u0004gRT\bCA:|\u0013\ta\u0018M\u0001\u0004E_V\u0014G.Z\u0001\u000e?R\u0014X-Z,fS\u001eDGo\u001d\u0011\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0003\u0003\u0003\u00012a]A\u0002\u0013\r\t)!\u0019\u0002\u0004\u0013:$\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0013A\u0002\u001fj]&$h\bF\u0005E\u0003\u001b\ty!!\u0005\u0002\u0014!)Q-\u0003a\u0001O\")\u0001/\u0003a\u0001e\")q/\u0003a\u0001s\"1a0\u0003a\u0001\u0003\u0003!r\u0001RA\f\u00033\tY\u0002C\u0003f\u0015\u0001\u0007q\rC\u0003q\u0015\u0001\u0007!\u000fC\u0003x\u0015\u0001\u0007\u0011\u0010K\u0003\u000b\u0003?\tY\u0003\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)CM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0015\u0003G\u0011QaU5oG\u0016\f#!!\f\u0002\u000bErCG\f\u0019\u0015\u0003\u0011\u000bQ\"Z:uS6\fG/\u001a3TSj,WCAA\u001b!\r\u0019\u0018qG\u0005\u0004\u0003s\t'\u0001\u0002'p]\u001e\fQ\u0001\u001e:fKNDS!DA\u0010\u0003W\t1bZ3u\u001dVlGK]3fg\"*a\"a\b\u0002D\u0005\u0012\u0011QI\u0001\u0006e9\u0002d\u0006M\u0001\rO\u0016$h*^7Ue\u0016,7\u000f\t\u0015\u0006\u001f\u0005}\u00111I\u0001\fiJ,WmV3jO\"$8\u000fK\u0003\u0011\u0003?\tY#A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t\u0019&a\u0019\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005)A/\u001f9fg*\u0019\u0011Q\f\u001a\u0002\u0007M\fH.\u0003\u0003\u0002b\u0005]#AC*ueV\u001cG\u000fV=qK\"9\u0011QM\tA\u0002\u0005M\u0013AB:dQ\u0016l\u0017\rK\u0003\u0012\u0003?\tY#A\u0005ue\u0006t7OZ8s[R!\u0011QNAE!\u0011\ty'a!\u000f\t\u0005E\u0014\u0011\u0011\b\u0005\u0003g\nyH\u0004\u0003\u0002v\u0005ud\u0002BA<\u0003wr1AWA=\u0013\u00059\u0014BA\u001b7\u0013\t\u0019D'C\u0002\u0002^IJ1\u0001YA.\u0013\u0011\t))a\"\u0003\u0013\u0011\u000bG/\u0019$sC6,'b\u00011\u0002\\!9\u00111\u0012\nA\u0002\u00055\u0015a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u001f\u000bY\n\u0005\u0004\u0002\u0012\u0006M\u0015qS\u0007\u0003\u00037JA!!&\u0002\\\t9A)\u0019;bg\u0016$\b\u0003BAM\u00037c\u0001\u0001\u0002\u0007\u0002\u001e\u0006%\u0015\u0011!A\u0001\u0006\u0003\tyJA\u0002`II\nB!!)\u0002(B\u00191/a)\n\u0007\u0005\u0015\u0016MA\u0004O_RD\u0017N\\4\u0011\u0007M\fI+C\u0002\u0002,\u0006\u00141!\u00118z\u0003\u001d\u0001(/\u001a3jGR$2A_AY\u0011\u0019\t\u0019l\u0005a\u0001}\u0005Aa-Z1ukJ,7/\u0001\u0003d_BLHc\u0001#\u0002:\"9\u00111\u0018\u000bA\u0002\u0005u\u0016!B3yiJ\f\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\r\u0007'A\u0003qCJ\fW.\u0003\u0003\u0002H\u0006\u0005'\u0001\u0003)be\u0006lW*\u00199)\u000bQ\ty\"a\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001a\u0015\u0006+\u0005}\u00111F\u0001\u0013M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7/F\u0001?Q\u00151\u0012qDA\"\u0003\u0015!xn\u00147e+\t\tY\u000e\u0005\u0003\u0002^\u0006%XBAAp\u0015\u0011\t\t/a9\u0002\u000b5|G-\u001a7\u000b\u0007!\u000b)OC\u0002\u0002hJ\nQ!\u001c7mS\nLA!a;\u0002`\nIrI]1eS\u0016tGOQ8pgR,G\r\u0016:fKNlu\u000eZ3m\u0003U)g/\u00197vCR,W)Y2i\u0013R,'/\u0019;j_:$R!_Ay\u0003{Dq!a#\u0019\u0001\u0004\t\u0019\u0010\r\u0003\u0002v\u0006e\bCBAI\u0003'\u000b9\u0010\u0005\u0003\u0002\u001a\u0006eH\u0001DA~\u0003c\f\t\u0011!A\u0003\u0002\u0005}%aA0%g!1\u0011q \rA\u0002\u001d\fA\u0001\\8tg\"*\u0001$a\b\u0003\u0004\u0005\u0012!QA\u0001\u0006e9\"d\u0006M\u0001\u0006oJLG/Z\u000b\u0003\u0005\u0017\u00012A\u0015B\u0007\u0013\r\u0011ya\u0015\u0002\t\u001b2;&/\u001b;fe\"*\u0011$a\b\u0002D!*\u0001!a\b\u0002,\u0005\u0011rI\u0011+SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tY4dE\u0004\u001c\u00057\u0011\tCa\n\u0011\u0007M\u0014i\"C\u0002\u0003 \u0005\u0014a!\u00118z%\u00164\u0007\u0003\u0002*\u0003$\u0011K1A!\nT\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u0005S\u0011\u0019$\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003\tIwN\u0003\u0002\u00032\u0005!!.\u0019<b\u0013\r\u0019'1\u0006\u000b\u0003\u0005/\tAA]3bIV\u0011!1\b\t\u0005%\nuB)C\u0002\u0003@M\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0006;\u0005}\u00111I\u0001\u0005Y>\fG\rF\u0002E\u0005\u000fBaA!\u0013\u001f\u0001\u00049\u0017\u0001\u00029bi\"DSAHA\u0010\u0003\u0007\u0012\u0001d\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\ry\"1B\u0001\tS:\u001cH/\u00198dKR!!Q\u000bB-!\r\u00119fH\u0007\u00027!1!\u0011K\u0011A\u0002\u0011\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0005?\u0012)\u0007E\u0002t\u0005CJ1Aa\u0019b\u0005\u0011)f.\u001b;\t\r\t%#\u00051\u0001h\u0005a9%\t\u0016*fOJ,7o]5p]6{G-\u001a7SK\u0006$WM]\n\u0004G\tmBC\u0001B7!\r\u00119fI\u0001\nG2\f7o\u001d(b[\u0016,\"Aa\u001d\u0011\t\tU$1P\u0007\u0003\u0005oRAA!\u001f\u00030\u0005!A.\u00198h\u0013\ri'qO\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0013!\u0004;sK\u0016\u001cE.Y:t\u001d\u0006lW-\u0001\bue\u0016,7\t\\1tg:\u000bW.\u001a\u0011\u0015\u0007\u0011\u0013)\t\u0003\u0004\u0003J%\u0002\raZ\u0001\bMJ|Wn\u00147e)%!%1\u0012BH\u00053\u0013\u0019\u000bC\u0004\u0003\u000e*\u0002\r!a7\u0002\u0011=dG-T8eK2DqA!%+\u0001\u0004\u0011\u0019*\u0001\u0004qCJ,g\u000e\u001e\t\u0004w\tU\u0015b\u0001BL]\taqI\u0011+SK\u001e\u0014Xm]:pe\"9!1\u0014\u0016A\u0002\tu\u0015aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\bc\u00025\u0003 \u0006\u0005\u0011\u0011A\u0005\u0004\u0005Cs'aA'ba\"AaP\u000bI\u0001\u0002\u0004\t\t!A\tge>lw\n\u001c3%I\u00164\u0017-\u001e7uIQ*\"A!++\t\u0005\u0005!1V\u0016\u0003\u0005[\u0003BAa,\u000386\u0011!\u0011\u0017\u0006\u0005\u0005g\u0013),A\u0005v]\u000eDWmY6fI*\u0019\u0011QE1\n\t\te&\u0011\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B`!\u0011\u0011)H!1\n\t\t\r'q\u000f\u0002\u0007\u001f\nTWm\u0019;)\u000bm\ty\"a\u0011)\u000bi\ty\"a\u0011")
public class GBTRegressionModel
extends RegressionModel<Vector, GBTRegressionModel>
implements GBTRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int getNumTrees;
    private int totalNumNodes;
    private Param<String> lossType;
    private Param<String> impurity;
    private DoubleParam validationTol;
    private DoubleParam stepSize;
    private Param<String> validationIndicatorCol;
    private IntParam maxIter;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTRegressionModel load(String path) {
        return GBTRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<GBTRegressionModel> read() {
        return GBTRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public DecisionTreeModel getTree(int i) {
        return TreeEnsembleModel.getTree$(this, i);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public long getEstimatedSize() {
        return TreeEnsembleModel.getEstimatedSize$(this);
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams.getLossType$(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams.getOldLossType$(this);
    }

    @Override
    public Loss convertToOldLossType(String loss) {
        return GBTRegressorParams.convertToOldLossType$(this, loss);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)scala.package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)scala.package$.MODULE$.Seq().empty();
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTRegressionModel.class));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$transform$1(bcastModel, features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.featuresCol()), outputSchema.apply(this.$(this.featuresCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(GBTRegressionModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> ((TreeEnsembleModel)bcastModel.value()).predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            return dataset.withColumns(predictionColNames, predictionColumns);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": GBTRegressionModel.transform() "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.UUID, this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"does nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        return dataset.toDF();
    }

    @Override
    public double predict(Vector features) {
        double[] treePredictions = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$predict$1(features, x$4)), (ClassTag)ClassTag$.MODULE$.Double());
        return BLAS$.MODULE$.nativeBLAS().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    @Override
    public GBTRegressionModel copy(ParamMap extra) {
        return (GBTRegressionModel)((Model)this.copyValues(new GBTRegressionModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "GBTRegressionModel: uid=" + this.uid() + ", numTrees=" + this.getNumTrees() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$5 -> x$5.toOld(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class)), this._treeWeights());
    }

    public double[] evaluateEachIteration(Dataset<?> dataset, String loss) {
        RDD<Instance> data = DatasetUtils$.MODULE$.extractInstances(this, dataset, DatasetUtils$.MODULE$.extractInstances$default$3());
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.convertToOldLossType(loss), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new GBTRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transform$1(Broadcast bcastModel$1, Vector features) {
        return ((GBTRegressionModel)bcastModel$1.value()).predict(features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleRegressorParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTRegressorParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "GBTRegressionModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable)() -> "GBTRegressionModel given trees, treeWeights of non-matching lengths (" + this._trees().length + ", " + this._treeWeights().length + ", respectively).");
        this.getNumTrees = this.trees().length;
        Statics.releaseFence();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1);
    }

    public GBTRegressionModel() {
        this("", (DecisionTreeRegressionModel[])((Object[])new DecisionTreeRegressionModel[]{new DecisionTreeRegressionModel()}), new double[]{Double.NaN}, -1);
    }

    private static class GBTRegressionModelReader
    extends MLReader<GBTRegressionModel> {
        private final String className = GBTRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple3._1();
            Tuple2[] treesData = (Tuple2[])tuple3._2();
            double[] treeWeights2 = (double[])tuple3._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numFeatures")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numTrees")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "GBTRegressionModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            GBTRegressionModel model = new GBTRegressionModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTRegressionModelWriter
    extends MLWriter {
        private final GBTRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTRegressionModelWriter(GBTRegressionModel instance) {
            this.instance = instance;
        }
    }
}

