/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat;

import java.io.Serializable;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.stat.ANOVATest$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.util.collection.OpenHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ANOVATest$ {
    public static final ANOVATest$ MODULE$ = new ANOVATest$();

    public Dataset<Row> test(Dataset<Row> dataset, String featuresCol, String labelCol) {
        return this.test(dataset, featuresCol, labelCol, false);
    }

    public Dataset<Row> test(Dataset<Row> dataset, String featuresCol, String labelCol, boolean flatten) {
        SparkSession spark = dataset.sparkSession();
        RDD<Tuple4<Object, Object, Object, Object>> resRdd = this.testClassification(dataset, featuresCol, labelCol);
        if (flatten) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_ml_stat_ANOVATest$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_ml_stat_ANOVATest$$typecreator10$1() {
                }
            }
            return spark.implicits().rddToDatasetHolder(resRdd, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_stat_ANOVATest$$typecreator10$1()))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureIndex", "pValue", "degreesOfFreedom", "fValue"}));
        }
        RDD qual$1 = resRdd.coalesce(1, resRdd.coalesce$default$2(), resRdd.coalesce$default$3(), Ordering$.MODULE$.Tuple4((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        Function1 & Serializable x$1 = (Function1 & Serializable)iter -> {
            Tuple4[] res = (Tuple4[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])iter.toArray(ClassTag$.MODULE$.apply(Tuple4.class))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ANOVATest$.$anonfun$test$2(x$1)), (Ordering)Ordering.Int$.MODULE$);
            Vector pValues = Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])res), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)ANOVATest$.$anonfun$test$3(x$2)), (ClassTag)ClassTag$.MODULE$.Double()));
            long[] degreesOfFreedom = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])res), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)ANOVATest$.$anonfun$test$4(x$3)), (ClassTag)ClassTag$.MODULE$.Long());
            Vector fValues = Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])res), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)ANOVATest$.$anonfun$test$5(x$4)), (ClassTag)ClassTag$.MODULE$.Double()));
            return package$.MODULE$.Iterator().single((Object)new Tuple3((Object)pValues, (Object)degreesOfFreedom, (Object)fValues));
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_stat_ANOVATest$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_stat_ANOVATest$$typecreator20$1() {
            }
        }
        return spark.implicits().rddToDatasetHolder(qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_stat_ANOVATest$$typecreator20$1()))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pValues", "degreesOfFreedom", "fValues"}));
    }

    public RDD<Tuple4<Object, Object, Object, Object>> testClassification(Dataset<?> dataset, String featuresCol, String labelCol) {
        SparkSession spark = dataset.sparkSession();
        SchemaUtils$.MODULE$.checkColumnType(dataset.schema(), featuresCol, (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkNumericType(dataset.schema(), labelCol, SchemaUtils$.MODULE$.checkNumericType$default$3());
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_stat_ANOVATest$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_stat_ANOVATest$$typecreator5$1() {
            }
        }
        RDD points = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(labelCol).cast("double"), functions$.MODULE$.col(featuresCol)})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_stat_ANOVATest$$typecreator5$1()))).rdd();
        Vector vector = (Vector)((Tuple2)points.first())._2();
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            return this.testClassificationDenseFeatures((RDD<Tuple2<Object, Vector>>)points, denseVector.size());
        }
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            return this.testClassificationSparseFeatures((RDD<Tuple2<Object, Vector>>)points, sparseVector.size());
        }
        throw new MatchError((Object)vector);
    }

    private RDD<Tuple4<Object, Object, Object, Object>> testClassificationDenseFeatures(RDD<Tuple2<Object, Vector>> points, int numFeatures) {
        return RDD$.MODULE$.rddToPairRDDFunctions(points.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double label = tuple2._1$mcD$sp();
                Vector features = (Vector)tuple2._2();
                Predef$.MODULE$.require(features.size() == numFeatures, (Function0 & Serializable)() -> "Number of features must be " + numFeatures + " but got " + features.size());
                return features.iterator().map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int col = tuple2._1$mcI$sp();
                        double value = tuple2._2$mcD$sp();
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), (Object)new Tuple2.mcDD.sp(label, value));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)new OpenHashMap.mcD.sp((ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double()), (Object)new OpenHashMap.mcJ.sp((ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Long())), (Function2 & Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple4 != null) {
                    double sum = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double sumOfSq = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    OpenHashMap sums = (OpenHashMap)tuple4._3();
                    OpenHashMap counts = (OpenHashMap)tuple4._4();
                    if (tuple22 != null) {
                        double label = tuple22._1$mcD$sp();
                        double value = tuple22._2$mcD$sp();
                        sums.changeValue$mcD$sp((Object)BoxesRunTime.boxToDouble((double)label), (Function0)(JFunction0.mcD.sp & Serializable)() -> value, (Function1)(JFunction1.mcDD.sp & Serializable)x$5 -> x$5 + value);
                        counts.changeValue$mcJ$sp((Object)BoxesRunTime.boxToDouble((double)label), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, (Function1)(JFunction1.mcJJ.sp & Serializable)x$6 -> x$6 + 1L);
                        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)(sum + value)), (Object)BoxesRunTime.boxToDouble((double)(sumOfSq + value * value)), (Object)sums, (Object)counts);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, (Function2 & Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$2);
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Tuple4 tuple42 = (Tuple4)tuple2._2();
                if (tuple4 != null) {
                    double sum1 = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double sumOfSq1 = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    OpenHashMap sums1 = (OpenHashMap)tuple4._3();
                    OpenHashMap counts1 = (OpenHashMap)tuple4._4();
                    if (tuple42 != null) {
                        double sum2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
                        double sumOfSq2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                        OpenHashMap sums2 = (OpenHashMap)tuple42._3();
                        OpenHashMap counts2 = (OpenHashMap)tuple42._4();
                        sums2.foreach((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)ANOVATest$.$anonfun$testClassificationDenseFeatures$10(sums1, x0$5)));
                        counts2.foreach((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToLong((long)ANOVATest$.$anonfun$testClassificationDenseFeatures$13(counts1, x0$6)));
                        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)(sum1 + sum2)), (Object)BoxesRunTime.boxToDouble((double)(sumOfSq1 + sumOfSq2)), (Object)sums1, (Object)counts1);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple4.class)).map((Function1 & Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 != null) {
                int col = tuple2._1$mcI$sp();
                Tuple4 tuple4 = (Tuple4)tuple2._2();
                if (tuple4 != null) {
                    double sum = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double sumOfSq = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    OpenHashMap sums = (OpenHashMap)tuple4._3();
                    OpenHashMap counts = (OpenHashMap)tuple4._4();
                    Tuple3<Object, Object, Object> tuple3 = MODULE$.computeANOVA(sum, sumOfSq, (Map<Object, Object>)sums.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<Object, Object>)counts.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    double pValue = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    long degreesOfFreedom = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    double fValue = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)pValue), (Object)BoxesRunTime.boxToLong((long)degreesOfFreedom), (Object)BoxesRunTime.boxToDouble((double)fValue));
                    double pValue2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                    long degreesOfFreedom2 = BoxesRunTime.unboxToLong((Object)tuple32._2());
                    double fValue2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                    return new Tuple4((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToDouble((double)pValue2), (Object)BoxesRunTime.boxToLong((long)degreesOfFreedom2), (Object)BoxesRunTime.boxToDouble((double)fValue2));
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple4.class));
    }

    private RDD<Tuple4<Object, Object, Object, Object>> testClassificationSparseFeatures(RDD<Tuple2<Object, Vector>> points, int numFeatures) {
        Map counts = points.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10._1$mcD$sp()), (ClassTag)ClassTag$.MODULE$.Double()).countByValue((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int numParts = points.getNumPartitions();
        return RDD$.MODULE$.rddToPairRDDFunctions(points.mapPartitionsWithIndex((Function2 & Serializable)(x0$1, x1$1) -> ANOVATest$.$anonfun$testClassificationSparseFeatures$2(numFeatures, numParts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), points.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)new OpenHashMap.mcD.sp((ClassTag)ClassTag$.MODULE$.Double(), (ClassTag)ClassTag$.MODULE$.Double())), (Function2 & Serializable)(x0$4, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$2);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple2 labelAndValue = (Tuple2)tuple2._2();
                if (tuple3 != null) {
                    double sum = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    double sumOfSq = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    OpenHashMap sums = (OpenHashMap)tuple3._3();
                    if (labelAndValue != null) {
                        Tuple2 tuple22 = labelAndValue;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        double label = tuple22._1$mcD$sp();
                        double value = tuple22._2$mcD$sp();
                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(label, value);
                        double label2 = sp2._1$mcD$sp();
                        double value2 = sp2._2$mcD$sp();
                        sums.changeValue$mcD$sp((Object)BoxesRunTime.boxToDouble((double)label2), (Function0)(JFunction0.mcD.sp & Serializable)() -> value2, (Function1)(JFunction1.mcDD.sp & Serializable)x$12 -> x$12 + value2);
                        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)(sum + value2)), (Object)BoxesRunTime.boxToDouble((double)(sumOfSq + value2 * value2)), (Object)sums);
                    }
                    return new Tuple3((Object)BoxesRunTime.boxToDouble((double)sum), (Object)BoxesRunTime.boxToDouble((double)sumOfSq), (Object)sums);
                }
            }
            throw new MatchError((Object)tuple2);
        }, (Function2 & Serializable)(x0$5, x1$3) -> {
            Tuple2 tuple2 = new Tuple2(x0$5, x1$3);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple3 tuple32 = (Tuple3)tuple2._2();
                if (tuple3 != null) {
                    double sum1 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    double sumOfSq1 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    OpenHashMap sums1 = (OpenHashMap)tuple3._3();
                    if (tuple32 != null) {
                        double sum2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                        double sumOfSq2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                        OpenHashMap sums2 = (OpenHashMap)tuple32._3();
                        sums2.foreach((Function1 & Serializable)x0$6 -> BoxesRunTime.boxToDouble((double)ANOVATest$.$anonfun$testClassificationSparseFeatures$12(sums1, x0$6)));
                        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)(sum1 + sum2)), (Object)BoxesRunTime.boxToDouble((double)(sumOfSq1 + sumOfSq2)), (Object)sums1);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1 & Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 != null) {
                int col = tuple2._1$mcI$sp();
                Tuple3 tuple3 = (Tuple3)tuple2._2();
                if (tuple3 != null) {
                    double sum = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    double sumOfSq = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    OpenHashMap sums = (OpenHashMap)tuple3._3();
                    counts.keysIterator().foreach((Function1)(JFunction1.mcVD.sp & Serializable)label -> {
                        if (!sums.contains((Object)BoxesRunTime.boxToDouble((double)label))) {
                            sums.update$mcD$sp((Object)BoxesRunTime.boxToDouble((double)label), 0.0);
                            return;
                        }
                    });
                    Tuple3<Object, Object, Object> tuple32 = MODULE$.computeANOVA(sum, sumOfSq, (Map<Object, Object>)sums.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<Object, Object>)counts);
                    if (tuple32 == null) {
                        throw new MatchError(tuple32);
                    }
                    double pValue = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                    long degreesOfFreedom = BoxesRunTime.unboxToLong((Object)tuple32._2());
                    double fValue = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                    Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)pValue), (Object)BoxesRunTime.boxToLong((long)degreesOfFreedom), (Object)BoxesRunTime.boxToDouble((double)fValue));
                    double pValue2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                    long degreesOfFreedom2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
                    double fValue2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
                    return new Tuple4((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToDouble((double)pValue2), (Object)BoxesRunTime.boxToLong((long)degreesOfFreedom2), (Object)BoxesRunTime.boxToDouble((double)fValue2));
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple4.class));
    }

    private Tuple3<Object, Object, Object> computeANOVA(double sum, double sumOfSq, Map<Object, Object> sums, Map<Object, Object> counts) {
        long numSamples = BoxesRunTime.unboxToLong((Object)counts.valuesIterator().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        int numClasses = counts.size();
        double sqSum = sum * sum;
        double ssTot = sumOfSq - sqSum / (double)numSamples;
        double totalSqSum = BoxesRunTime.unboxToDouble((Object)sums.iterator().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)ANOVATest$.$anonfun$computeANOVA$1(counts, x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double ssbn = totalSqSum - sqSum / (double)numSamples;
        double sswn = ssTot - ssbn;
        int dfbn = numClasses - 1;
        long dfwn = numSamples - (long)numClasses;
        double msb = ssbn / (double)dfbn;
        double msw = sswn / (double)dfwn;
        double fValue = msb / msw;
        double pValue = 1.0 - new FDistribution((double)dfbn, (double)dfwn).cumulativeProbability(fValue);
        long degreesOfFreedom = (long)dfbn + dfwn;
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)pValue), (Object)BoxesRunTime.boxToLong((long)degreesOfFreedom), (Object)BoxesRunTime.boxToDouble((double)fValue));
    }

    public static final /* synthetic */ int $anonfun$test$2(Tuple4 x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1._1());
    }

    public static final /* synthetic */ double $anonfun$test$3(Tuple4 x$2) {
        return BoxesRunTime.unboxToDouble((Object)x$2._2());
    }

    public static final /* synthetic */ long $anonfun$test$4(Tuple4 x$3) {
        return BoxesRunTime.unboxToLong((Object)x$3._3());
    }

    public static final /* synthetic */ double $anonfun$test$5(Tuple4 x$4) {
        return BoxesRunTime.unboxToDouble((Object)x$4._4());
    }

    public static final /* synthetic */ double $anonfun$testClassificationDenseFeatures$10(OpenHashMap sums1$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            double v = tuple2._1$mcD$sp();
            double w = tuple2._2$mcD$sp();
            return sums1$1.changeValue$mcD$sp((Object)BoxesRunTime.boxToDouble((double)v), (Function0)(JFunction0.mcD.sp & Serializable)() -> w, (Function1)(JFunction1.mcDD.sp & Serializable)x$7 -> x$7 + w);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$testClassificationDenseFeatures$13(OpenHashMap counts1$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            double v = tuple2._1$mcD$sp();
            long w = tuple2._2$mcJ$sp();
            return counts1$1.changeValue$mcJ$sp((Object)BoxesRunTime.boxToDouble((double)v), (Function0)(JFunction0.mcJ.sp & Serializable)() -> w, (Function1)(JFunction1.mcJJ.sp & Serializable)x$8 -> x$8 + w);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testClassificationSparseFeatures$7(int col) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), null);
    }

    public static final /* synthetic */ Iterator $anonfun$testClassificationSparseFeatures$2(int numFeatures$2, int numParts$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int pid = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            return iter.flatMap((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    double label = tuple2._1$mcD$sp();
                    Vector features = (Vector)tuple2._2();
                    Predef$.MODULE$.require(features.size() == numFeatures$2, (Function0 & Serializable)() -> "Number of features must be " + numFeatures$2 + " but got " + features.size());
                    return features.nonZeroIterator().map((Function1 & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            int col = tuple2._1$mcI$sp();
                            double value = tuple2._2$mcD$sp();
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), (Object)new Tuple2.mcDD.sp(label, value));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            }).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().range(pid, numFeatures$2, numParts$1).map((Function1 & Serializable)col -> ANOVATest$.$anonfun$testClassificationSparseFeatures$7(BoxesRunTime.unboxToInt((Object)col))));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$testClassificationSparseFeatures$12(OpenHashMap sums1$2, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            double v = tuple2._1$mcD$sp();
            double w = tuple2._2$mcD$sp();
            return sums1$2.changeValue$mcD$sp((Object)BoxesRunTime.boxToDouble((double)v), (Function0)(JFunction0.mcD.sp & Serializable)() -> w, (Function1)(JFunction1.mcDD.sp & Serializable)x$13 -> x$13 + w);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ double $anonfun$computeANOVA$1(Map counts$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double label = tuple2._1$mcD$sp();
            double sum = tuple2._2$mcD$sp();
            return sum * sum / (double)BoxesRunTime.unboxToLong((Object)counts$2.apply((Object)BoxesRunTime.boxToDouble((double)label)));
        }
        throw new MatchError((Object)tuple2);
    }

    private ANOVATest$() {
    }
}

