/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.Field;
import java.io.Serializable;
import scala.Double$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import spire.math.DecimalNumber;
import spire.math.FloatNumber;
import spire.math.IntNumber;
import spire.math.Natural;
import spire.math.Number;
import spire.math.NumberInstances;
import spire.math.Rational;
import spire.math.RationalNumber;
import spire.math.SafeLong;
import spire.math.SafeLong$;

public final class Number$
implements NumberInstances,
Serializable {
    public static final Number$ MODULE$ = new Number$();
    private static final Number zero;
    private static final Number one;
    private static final SafeLong minInt;
    private static final SafeLong maxInt;
    private static final SafeLong minLong;
    private static final SafeLong maxLong;
    private static final BigDecimal minDouble;
    private static final BigDecimal maxDouble;
    private static Field<Number> NumberAlgebra;

    static {
        NumberInstances.$init$(MODULE$);
        zero = MODULE$.apply(0);
        one = MODULE$.apply(1);
        minInt = SafeLong$.MODULE$.apply(Integer.MIN_VALUE);
        maxInt = SafeLong$.MODULE$.apply(Integer.MAX_VALUE);
        minLong = SafeLong$.MODULE$.apply(Long.MIN_VALUE);
        maxLong = SafeLong$.MODULE$.apply(Long.MAX_VALUE);
        minDouble = package$.MODULE$.BigDecimal().apply(Double$.MODULE$.MinValue());
        maxDouble = package$.MODULE$.BigDecimal().apply(Double.MAX_VALUE);
    }

    @Override
    public final Field<Number> NumberAlgebra() {
        return NumberAlgebra;
    }

    @Override
    public final void spire$math$NumberInstances$_setter_$NumberAlgebra_$eq(Field<Number> x$1) {
        NumberAlgebra = x$1;
    }

    public final Number zero() {
        return zero;
    }

    public final Number one() {
        return one;
    }

    public Number apply(int n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n));
    }

    public Number apply(long n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n));
    }

    public Number apply(BigInt n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n));
    }

    public Number apply(SafeLong n) {
        return new IntNumber(n);
    }

    public Number apply(BigDecimal n) {
        return new DecimalNumber(n);
    }

    public Number apply(Rational n) {
        return new RationalNumber(n);
    }

    public Number apply(Natural n) {
        return new IntNumber(SafeLong$.MODULE$.apply(n.toBigInt()));
    }

    public Number apply(float n) {
        if (Float.isNaN(n) || Float.isInfinite(n)) {
            throw new IllegalArgumentException(Float.toString(n));
        }
        return new FloatNumber(n);
    }

    public Number apply(double n) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            throw new IllegalArgumentException(Double.toString(n));
        }
        return new FloatNumber(n);
    }

    public Number apply(String s) {
        Number number;
        try {
            number = this.apply(SafeLong$.MODULE$.apply(s));
        }
        catch (Exception exception) {
            number = this.apply(package$.MODULE$.BigDecimal().apply(s));
        }
        return number;
    }

    public SafeLong minInt() {
        return minInt;
    }

    public SafeLong maxInt() {
        return maxInt;
    }

    public SafeLong minLong() {
        return minLong;
    }

    public SafeLong maxLong() {
        return maxLong;
    }

    public BigDecimal minDouble() {
        return minDouble;
    }

    public BigDecimal maxDouble() {
        return maxDouble;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Number$.class);
    }

    private Number$() {
    }
}

