/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import algebra.ring.Ring;
import algebra.ring.Rng;
import algebra.ring.Semiring;
import algebra.ring.Signed;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import spire.math.Interval;
import spire.math.Interval$;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.poly.RootIsolator;
import spire.math.poly.RootIsolator$TransformedPoly$2$;
import spire.math.poly.Roots$;
import spire.math.poly.Term;
import spire.optional.intervalGeometricPartialOrder$;
import spire.std.package$bigInt$;
import spire.syntax.std.package$seq$;

public final class RootIsolator$ {
    public static final RootIsolator$ MODULE$ = new RootIsolator$();
    private static final RootIsolator<Rational> RationalRootIsolator = new RootIsolator<Rational>(){

        public Vector<Interval<Rational>> isolateRoots(Polynomial<Rational> poly) {
            return RootIsolator$.MODULE$.spire$math$poly$RootIsolator$$VAS(Roots$.MODULE$.removeFractions(poly));
        }
    };
    private static final RootIsolator<BigDecimal> BigDecimalRootIsolator = new RootIsolator<BigDecimal>(){

        public Vector<Interval<Rational>> isolateRoots(Polynomial<BigDecimal> poly) {
            return RootIsolator$.MODULE$.spire$math$poly$RootIsolator$$VAS(Roots$.MODULE$.removeDecimal(poly));
        }
    };
    private static final RootIsolator<BigInt> BigIntRootIsolator = new RootIsolator<BigInt>(){

        public Vector<Interval<Rational>> isolateRoots(Polynomial<BigInt> poly) {
            return RootIsolator$.MODULE$.spire$math$poly$RootIsolator$$VAS(poly);
        }
    };

    public RootIsolator<Rational> RationalRootIsolator() {
        return RationalRootIsolator;
    }

    public RootIsolator<BigDecimal> BigDecimalRootIsolator() {
        return BigDecimalRootIsolator;
    }

    public RootIsolator<BigInt> BigIntRootIsolator() {
        return BigIntRootIsolator;
    }

    public final Vector<Interval<Rational>> spire$math$poly$RootIsolator$$VAS(Polynomial<BigInt> poly) {
        Vector vector;
        LazyRef TransformedPoly$module = new LazyRef();
        if (poly.isConstant()) {
            vector = package$.MODULE$.Vector().empty();
        } else {
            Interval<Rational> zeroInterval = Interval$.MODULE$.point(Rational$.MODULE$.zero(), (Order)Rational$.MODULE$.RationalAlgebra());
            public class Spire_math_poly_RootIsolator$TransformedPoly$1
            implements Product,
            Serializable {
                private final Polynomial<BigInt> p;
                private final BigInt a;
                private final BigInt b;
                private final BigInt c;
                private final BigInt d;

                public Iterator<String> productElementNames() {
                    return Product.productElementNames$((Product)this);
                }

                public Polynomial<BigInt> p() {
                    return this.p;
                }

                public BigInt a() {
                    return this.a;
                }

                public BigInt b() {
                    return this.b;
                }

                public BigInt c() {
                    return this.c;
                }

                public BigInt d() {
                    return this.d;
                }

                public Spire_math_poly_RootIsolator$TransformedPoly$1 copy(Polynomial<BigInt> p, BigInt a, BigInt b, BigInt c, BigInt d) {
                    return new Spire_math_poly_RootIsolator$TransformedPoly$1(p, a, b, c, d);
                }

                public Polynomial<BigInt> copy$default$1() {
                    return this.p();
                }

                public BigInt copy$default$2() {
                    return this.a();
                }

                public BigInt copy$default$3() {
                    return this.b();
                }

                public BigInt copy$default$4() {
                    return this.c();
                }

                public BigInt copy$default$5() {
                    return this.d();
                }

                public String productPrefix() {
                    return "TransformedPoly";
                }

                public int productArity() {
                    return 5;
                }

                public Object productElement(int x$1) {
                    Object object;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            object = this.p();
                            break;
                        }
                        case 1: {
                            object = this.a();
                            break;
                        }
                        case 2: {
                            object = this.b();
                            break;
                        }
                        case 3: {
                            object = this.c();
                            break;
                        }
                        case 4: {
                            object = this.d();
                            break;
                        }
                        default: {
                            object = Statics.ioobe((int)x$1);
                            break;
                        }
                    }
                    return object;
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Spire_math_poly_RootIsolator$TransformedPoly$1;
                }

                public String productElementName(int x$1) {
                    String string;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            string = "p";
                            break;
                        }
                        case 1: {
                            string = "a";
                            break;
                        }
                        case 2: {
                            string = "b";
                            break;
                        }
                        case 3: {
                            string = "c";
                            break;
                        }
                        case 4: {
                            string = "d";
                            break;
                        }
                        default: {
                            string = (String)Statics.ioobe((int)x$1);
                            break;
                        }
                    }
                    return string;
                }

                public int hashCode() {
                    return ScalaRunTime$.MODULE$._hashCode((Product)this);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Spire_math_poly_RootIsolator$TransformedPoly$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Spire_math_poly_RootIsolator$TransformedPoly$1 var4_4 = (Spire_math_poly_RootIsolator$TransformedPoly$1)x$1;
                    Polynomial<BigInt> polynomial = this.p();
                    Polynomial<BigInt> polynomial2 = var4_4.p();
                    if (polynomial == null) {
                        if (polynomial2 != null) {
                            return false;
                        }
                    } else if (!((Object)polynomial).equals(polynomial2)) return false;
                    BigInt bigInt = this.a();
                    BigInt bigInt2 = var4_4.a();
                    if (bigInt == null) {
                        if (bigInt2 != null) {
                            return false;
                        }
                    } else if (!bigInt.equals(bigInt2)) return false;
                    BigInt bigInt3 = this.b();
                    BigInt bigInt4 = var4_4.b();
                    if (bigInt3 == null) {
                        if (bigInt4 != null) {
                            return false;
                        }
                    } else if (!bigInt3.equals(bigInt4)) return false;
                    BigInt bigInt5 = this.c();
                    BigInt bigInt6 = var4_4.c();
                    if (bigInt5 == null) {
                        if (bigInt6 != null) {
                            return false;
                        }
                    } else if (!bigInt5.equals(bigInt6)) return false;
                    BigInt bigInt7 = this.d();
                    BigInt bigInt8 = var4_4.d();
                    if (bigInt7 == null) {
                        if (bigInt8 != null) {
                            return false;
                        }
                    } else if (!bigInt7.equals(bigInt8)) return false;
                    if (!var4_4.canEqual(this)) return false;
                    return true;
                }

                public Spire_math_poly_RootIsolator$TransformedPoly$1(Polynomial<BigInt> p, BigInt a, BigInt b, BigInt c, BigInt d) {
                    this.p = p;
                    this.a = a;
                    this.b = b;
                    this.c = c;
                    this.d = d;
                    Product.$init$((Product)this);
                }
            }
            Spire_math_poly_RootIsolator$TransformedPoly$1 var5_4 = this.TransformedPoly$3(TransformedPoly$module).apply(poly, BigInt$.MODULE$.int2bigInt(1), BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(1));
            Vector posRoots = this.rec$1(package$.MODULE$.Nil().$colon$colon((Object)var5_4), RootIsolator$.rec$default$2$1(), TransformedPoly$module);
            Spire_math_poly_RootIsolator$TransformedPoly$1 var7_6 = this.TransformedPoly$3(TransformedPoly$module).apply(poly.flip((Rng<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Eq<BigInt>)((Eq)package$bigInt$.MODULE$.BigIntAlgebra())), BigInt$.MODULE$.int2bigInt(1), BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(1));
            Vector negRoots = (Vector)((StrictOptimizedIterableOps)this.rec$1(package$.MODULE$.Nil().$colon$colon((Object)var7_6), RootIsolator$.rec$default$2$1(), TransformedPoly$module).map((Function1 & Serializable)x$2 -> x$2.unary_$minus(Rational$.MODULE$.RationalAlgebra()))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RootIsolator$.$anonfun$VAS$7(zeroInterval, x$3)));
            Vector roots = (Vector)negRoots.$plus$plus((IterableOnce)posRoots);
            PartialOrder partialOrder = intervalGeometricPartialOrder$.MODULE$.intervalGeometricPartialOrder((Order)Rational$.MODULE$.RationalAlgebra());
            Order order = spire.algebra.package$.MODULE$.Order().from((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToInteger((int)RootIsolator$.$anonfun$VAS$8(partialOrder, x, y)));
            vector = package$seq$.MODULE$.seqOps(roots).qsorted(order, ClassTag$.MODULE$.apply(Interval.class), Vector$.MODULE$.iterableFactory());
        }
        return vector;
    }

    private static final /* synthetic */ RootIsolator$TransformedPoly$2$ TransformedPoly$lzycompute$1(LazyRef TransformedPoly$module$1) {
        RootIsolator$TransformedPoly$2$ rootIsolator$TransformedPoly$2$;
        LazyRef lazyRef = TransformedPoly$module$1;
        synchronized (lazyRef) {
            rootIsolator$TransformedPoly$2$ = TransformedPoly$module$1.initialized() ? (RootIsolator$TransformedPoly$2$)TransformedPoly$module$1.value() : (RootIsolator$TransformedPoly$2$)TransformedPoly$module$1.initialize((Object)new RootIsolator$TransformedPoly$2$());
        }
        return rootIsolator$TransformedPoly$2$;
    }

    private final RootIsolator$TransformedPoly$2$ TransformedPoly$3(LazyRef TransformedPoly$module$1) {
        return TransformedPoly$module$1.initialized() ? (RootIsolator$TransformedPoly$2$)TransformedPoly$module$1.value() : RootIsolator$.TransformedPoly$lzycompute$1(TransformedPoly$module$1);
    }

    private final List split1$1(Polynomial p, BigInt a, BigInt b, BigInt c, BigInt d, LazyRef TransformedPoly$module$1) {
        List list;
        Polynomial<BigInt> r = p.shift(package$.MODULE$.BigInt().apply(1), package$bigInt$.MODULE$.BigIntAlgebra(), (Eq)package$bigInt$.MODULE$.BigIntAlgebra());
        Spire_math_poly_RootIsolator$TransformedPoly$1 rRoots = this.TransformedPoly$3(TransformedPoly$module$1).apply(r, a, b.$plus(a), c, d.$plus(c));
        if (r.signVariations((Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Order<BigInt>)((Order)package$bigInt$.MODULE$.BigIntAlgebra()), (Signed<BigInt>)((Signed)package$bigInt$.MODULE$.BigIntAlgebra())) < p.signVariations(package$bigInt$.MODULE$.BigIntAlgebra(), (Order)package$bigInt$.MODULE$.BigIntAlgebra(), (Signed)package$bigInt$.MODULE$.BigIntAlgebra())) {
            Spire_math_poly_RootIsolator$TransformedPoly$1 lRoots;
            Polynomial<BigInt> l = p.reciprocal(package$bigInt$.MODULE$.BigIntAlgebra(), (Eq)package$bigInt$.MODULE$.BigIntAlgebra()).shift(package$.MODULE$.BigInt().apply(1), (Ring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Eq<BigInt>)((Eq)package$bigInt$.MODULE$.BigIntAlgebra())).removeZeroRoots((Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Eq<BigInt>)((Eq)package$bigInt$.MODULE$.BigIntAlgebra()));
            Spire_math_poly_RootIsolator$TransformedPoly$1 var11_11 = lRoots = this.TransformedPoly$3(TransformedPoly$module$1).apply(l, b, a.$plus(b), d, c.$plus(d));
            Spire_math_poly_RootIsolator$TransformedPoly$1 var12_12 = rRoots;
            list = package$.MODULE$.Nil().$colon$colon((Object)var12_12).$colon$colon((Object)var11_11);
        } else {
            Spire_math_poly_RootIsolator$TransformedPoly$1 var13_13 = rRoots;
            list = package$.MODULE$.Nil().$colon$colon((Object)var13_13);
        }
        return list;
    }

    private static final Rational ub$1(Polynomial p$1, BigInt a$1, BigInt b$1, BigInt c$1, BigInt d$1) {
        int exp = Roots$.MODULE$.upperBound(p$1);
        Rational ub0 = exp >= 0 ? Rational$.MODULE$.apply(package$.MODULE$.BigInt().apply(1).$less$less(exp)) : Rational$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1), package$.MODULE$.BigInt().apply(1).$less$less(-exp));
        return Rational$.MODULE$.apply(a$1).$times(ub0).$plus(Rational$.MODULE$.apply(b$1)).$div(Rational$.MODULE$.apply(c$1).$times(ub0).$plus(Rational$.MODULE$.apply(d$1)));
    }

    private final List findFloor$1(Polynomial q, Option floor, BigInt a$1, BigInt b$1, BigInt c$1, BigInt d$1, LazyRef TransformedPoly$module$1) {
        List list;
        while (true) {
            int lb;
            if ((lb = Roots$.MODULE$.lowerBound(q)) < 0) {
                list = (List)floor.fold((Function0 & Serializable)() -> this.split1$1(q, a$1, b$1, c$1, d$1, TransformedPoly$module$1), (Function1 & Serializable)h -> this.split1$1(q, a$1, b$1.$plus(a$1.$times(h)), c$1, d$1.$plus(c$1.$times(h)), TransformedPoly$module$1));
                break;
            }
            BigInt h2 = package$.MODULE$.BigInt().apply(1).$less$less(lb);
            Polynomial<BigInt> q0 = q.shift(h2, (Ring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Eq<BigInt>)((Eq)package$bigInt$.MODULE$.BigIntAlgebra()));
            if (q0.signVariations((Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Order<BigInt>)((Order)package$bigInt$.MODULE$.BigIntAlgebra()), (Signed<BigInt>)((Signed)package$bigInt$.MODULE$.BigIntAlgebra())) == 0) {
                list = package$.MODULE$.Nil();
                break;
            }
            floor = new Some(floor.fold((Function0 & Serializable)() -> h2, (Function1 & Serializable)x$1 -> x$1.$plus(h2)));
            q = q0;
        }
        return list;
    }

    private final Vector rec$1(List polys, Vector acc, LazyRef TransformedPoly$module$1) {
        List list;
        block4: while ((list = polys) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Spire_math_poly_RootIsolator$TransformedPoly$1 var8_6 = (Spire_math_poly_RootIsolator$TransformedPoly$1)colon2.head();
            List rest = colon2.next$access$1();
            if (var8_6 == null) break;
            Polynomial<BigInt> p = var8_6.p();
            BigInt a = var8_6.a();
            BigInt b = var8_6.b();
            BigInt c = var8_6.c();
            BigInt d = var8_6.d();
            if (p.nth(0, (Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra()).signum() == 0) {
                Polynomial<BigInt> p0 = p.mapTerms((Function1 & Serializable)x0$1 -> {
                    Term term = x0$1;
                    if (term == null) {
                        throw new MatchError((Object)term);
                    }
                    BigInt coeff = (BigInt)term.coeff();
                    int exp = term.exp();
                    Term<BigInt> term2 = new Term<BigInt>(coeff, exp - 1);
                    return term2;
                }, package$bigInt$.MODULE$.BigIntAlgebra(), (Eq)package$bigInt$.MODULE$.BigIntAlgebra(), ClassTag$.MODULE$.apply(BigInt.class));
                Spire_math_poly_RootIsolator$TransformedPoly$1 var16_14 = this.TransformedPoly$3(TransformedPoly$module$1).apply(p0, a, b, c, d);
                acc = (Vector)acc.$colon$plus(Interval$.MODULE$.point(Rational$.MODULE$.apply(b, d), (Order)Rational$.MODULE$.RationalAlgebra()));
                polys = rest.$colon$colon((Object)var16_14);
                continue;
            }
            int n = p.signVariations((Semiring<BigInt>)package$bigInt$.MODULE$.BigIntAlgebra(), (Order<BigInt>)((Order)package$bigInt$.MODULE$.BigIntAlgebra()), (Signed<BigInt>)((Signed)package$bigInt$.MODULE$.BigIntAlgebra()));
            switch (n) {
                case 0: {
                    polys = rest;
                    continue block4;
                }
                case 1: {
                    Rational i1;
                    Rational i0 = BoxesRunTime.equalsNumObject((Number)c, (Object)BoxesRunTime.boxToInteger((int)0)) ? RootIsolator$.ub$1(p, a, b, c, d) : Rational$.MODULE$.apply(a, c);
                    Rational rational = i1 = BoxesRunTime.equalsNumObject((Number)d, (Object)BoxesRunTime.boxToInteger((int)0)) ? RootIsolator$.ub$1(p, a, b, c, d) : Rational$.MODULE$.apply(b, d);
                    if (i0.$less((Object)i1)) {
                        acc = (Vector)acc.$colon$plus(Interval$.MODULE$.open(i0, i1, (Order)Rational$.MODULE$.RationalAlgebra()));
                        polys = rest;
                        continue block4;
                    }
                    acc = (Vector)acc.$colon$plus(Interval$.MODULE$.open(i1, i0, (Order)Rational$.MODULE$.RationalAlgebra()));
                    polys = rest;
                    continue block4;
                }
            }
            polys = this.findFloor$1(p, (Option)None$.MODULE$, a, b, c, d, TransformedPoly$module$1).reverse_$colon$colon$colon(rest);
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (nil$ != null ? !nil$.equals(list2) : list2 != null) {
            throw new MatchError((Object)list);
        }
        Vector vector = acc;
        return vector;
    }

    private static final Vector rec$default$2$1() {
        return package$.MODULE$.Vector().empty();
    }

    public static final /* synthetic */ boolean $anonfun$VAS$7(Interval zeroInterval$1, Interval x$3) {
        Interval interval = x$3;
        Interval interval2 = zeroInterval$1;
        return interval == null ? interval2 != null : !interval.equals(interval2);
    }

    public static final /* synthetic */ int $anonfun$VAS$8(PartialOrder partialOrder$1, Interval x, Interval y) {
        return BoxesRunTime.unboxToInt((Object)partialOrder$1.tryCompare((Object)x, (Object)y).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("unexpected overlapping isolated roots");
        }));
    }

    private RootIsolator$() {
    }
}

