/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ResourceUtilization
implements Comparable<ResourceUtilization> {
    private Map<String, Float> customResources = new HashMap<String, Float>();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceUtilization newInstance(int pmem, int vmem, float cpu) {
        return ResourceUtilization.newInstance(pmem, vmem, cpu, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceUtilization newInstance(int pmem, int vmem, float cpu, Map<String, Float> customResources) {
        ResourceUtilization utilization = Records.newRecord(ResourceUtilization.class);
        utilization.setPhysicalMemory(pmem);
        utilization.setVirtualMemory(vmem);
        utilization.setCPU(cpu);
        utilization.setCustomResources(customResources);
        return utilization;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceUtilization newInstance(ResourceUtilization resourceUtil) {
        return ResourceUtilization.newInstance(resourceUtil.getPhysicalMemory(), resourceUtil.getVirtualMemory(), resourceUtil.getCPU(), resourceUtil.getCustomResources());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getVirtualMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setVirtualMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getPhysicalMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setPhysicalMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract float getCPU();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setCPU(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public float getCustomResource(String resourceName) {
        if (this.customResources != null && resourceName != null) {
            return this.customResources.get(resourceName).floatValue();
        }
        return 0.0f;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Map<String, Float> getCustomResources() {
        return this.customResources;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void setCustomResources(Map<String, Float> customResources) {
        if (customResources != null) {
            this.customResources = customResources;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void setCustomResource(String resourceName, float utilization) {
        if (resourceName != null && !resourceName.isEmpty()) {
            this.customResources.put(resourceName, Float.valueOf(utilization));
        }
    }

    public int hashCode() {
        int prime = 263167;
        int result = 3571;
        result = 263167 * result + this.getVirtualMemory();
        result = 263167 * result + this.getPhysicalMemory();
        result = 31 * result + Float.valueOf(this.getCPU()).hashCode();
        if (this.customResources != null && !this.customResources.isEmpty()) {
            for (Map.Entry<String, Float> entry : this.customResources.entrySet()) {
                result = 31 * result + this.customResources.get(entry.getKey()).hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceUtilization)) {
            return false;
        }
        ResourceUtilization other = (ResourceUtilization)obj;
        return this.getVirtualMemory() == other.getVirtualMemory() && this.getPhysicalMemory() == other.getPhysicalMemory() && this.getCPU() == other.getCPU() && this.customResources.equals(other.customResources);
    }

    public String toString() {
        StringBuilder utilizationString = new StringBuilder();
        utilizationString.append("<pmem:" + this.getPhysicalMemory() + ", vmem:" + this.getVirtualMemory() + ", vCores:" + this.getCPU());
        if (this.getCustomResources() != null && !this.getCustomResources().isEmpty()) {
            for (Map.Entry<String, Float> entry : this.getCustomResources().entrySet()) {
                utilizationString.append(", " + entry.getKey() + ":" + entry.getValue());
            }
        }
        utilizationString.append(">");
        return utilizationString.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void addTo(int pmem, int vmem, float cpu) {
        this.addTo(pmem, vmem, cpu, null, 0.0f);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void addTo(int pmem, int vmem, float cpu, String resourceName, float utilization) {
        this.setPhysicalMemory(this.getPhysicalMemory() + pmem);
        this.setVirtualMemory(this.getVirtualMemory() + vmem);
        this.setCPU(this.getCPU() + cpu);
        if (resourceName != null) {
            this.setCustomResource(resourceName, this.getCustomResource(resourceName) + utilization);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void subtractFrom(int pmem, int vmem, float cpu) {
        this.subtractFrom(pmem, vmem, cpu, null, 0.0f);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void subtractFrom(int pmem, int vmem, float cpu, String resourceName, float utilization) {
        this.setPhysicalMemory(this.getPhysicalMemory() - pmem);
        this.setVirtualMemory(this.getVirtualMemory() - vmem);
        this.setCPU(this.getCPU() - cpu);
        if (resourceName != null) {
            this.setCustomResource(resourceName, this.getCustomResource(resourceName) - utilization);
        }
    }
}

