/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics.geospatial;

import org.apache.parquet.column.statistics.geospatial.BoundingBox;
import org.apache.parquet.column.statistics.geospatial.GeospatialTypes;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeospatialStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(GeospatialStatistics.class);
    private BoundingBox boundingBox;
    private GeospatialTypes geospatialTypes;

    public static Builder newBuilder(PrimitiveType type) {
        LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.GeometryLogicalTypeAnnotation) {
            return new Builder();
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.GeographyLogicalTypeAnnotation) {
            return GeospatialStatistics.noopBuilder();
        }
        return GeospatialStatistics.noopBuilder();
    }

    public GeospatialStatistics(BoundingBox boundingBox, GeospatialTypes geospatialTypes) {
        this.boundingBox = boundingBox;
        this.geospatialTypes = geospatialTypes;
    }

    public GeospatialStatistics() {
        this(new BoundingBox(), new GeospatialTypes());
    }

    public GeospatialStatistics(String crs) {
        this.boundingBox = new BoundingBox();
        this.geospatialTypes = new GeospatialTypes();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public GeospatialTypes getGeospatialTypes() {
        return this.geospatialTypes;
    }

    public boolean isValid() {
        return this.boundingBox != null && this.boundingBox.isValid() || this.geospatialTypes != null && this.geospatialTypes.isValid();
    }

    public void merge(GeospatialStatistics other) {
        if (this.boundingBox != null) {
            this.boundingBox.merge(other.boundingBox);
        }
        if (this.geospatialTypes != null) {
            this.geospatialTypes.merge(other.geospatialTypes);
        }
    }

    private void abort() {
        if (this.boundingBox != null) {
            this.boundingBox.abort();
        }
        if (this.geospatialTypes != null) {
            this.geospatialTypes.abort();
        }
    }

    public GeospatialStatistics copy() {
        return new GeospatialStatistics(this.boundingBox != null ? this.boundingBox.copy() : null, this.geospatialTypes != null ? this.geospatialTypes.copy() : null);
    }

    public String toString() {
        return "GeospatialStatistics{boundingBox=" + this.boundingBox + ", geospatialTypes=" + this.geospatialTypes + '}';
    }

    public static Builder noopBuilder() {
        return new NoopBuilder();
    }

    private static class NoopBuilder
    extends Builder {
        private NoopBuilder() {
        }

        @Override
        public GeospatialStatistics build() {
            return new GeospatialStatistics(null, null);
        }

        @Override
        public void update(Binary value) {
        }

        @Override
        public void abort() {
        }
    }

    public static class Builder {
        private BoundingBox boundingBox;
        private GeospatialTypes geospatialTypes;
        private final WKBReader reader = new WKBReader();

        public Builder() {
            this.boundingBox = new BoundingBox();
            this.geospatialTypes = new GeospatialTypes();
        }

        public void update(Binary value) {
            if (value == null) {
                return;
            }
            try {
                Geometry geom = this.reader.read(value.getBytes());
                this.update(geom);
            }
            catch (ParseException e) {
                LOG.warn("Failed to parse WKB geometry, omit it from stats", (Throwable)e);
            }
        }

        private void update(Geometry geom) {
            this.boundingBox.update(geom);
            this.geospatialTypes.update(geom);
        }

        public void abort() {
            this.boundingBox.abort();
            this.geospatialTypes.abort();
        }

        public GeospatialStatistics build() {
            return new GeospatialStatistics(this.boundingBox, this.geospatialTypes);
        }
    }
}

