/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.util.SQLOrderingUtil;

public class ArrayExpressionUtils {
    private static final Comparator<Boolean> booleanComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.equals(o2) ? 0 : (o1 != false ? 1 : -1);
    };
    private static final Comparator<Byte> byteComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Byte.compare(o1, o2);
    };
    private static final Comparator<Short> shortComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Short.compare(o1, o2);
    };
    private static final Comparator<Integer> integerComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Integer.compare(o1, o2);
    };
    private static final Comparator<Long> longComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Long.compare(o1, o2);
    };
    private static final Comparator<Float> floatComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return SQLOrderingUtil.compareFloats(o1.floatValue(), o2.floatValue());
    };
    private static final Comparator<Double> doubleComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return SQLOrderingUtil.compareDoubles(o1, o2);
    };

    public static int binarySearch(boolean[] data, boolean value) {
        int low = 0;
        int high = data.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            boolean midVal = data[mid];
            if (value == midVal) {
                return mid;
            }
            if (value) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static int binarySearch(Boolean[] data, Boolean value) {
        return Arrays.binarySearch(data, value, booleanComp);
    }

    public static int binarySearch(byte[] data, byte value) {
        return Arrays.binarySearch(data, value);
    }

    public static int binarySearch(Byte[] data, Byte value) {
        return Arrays.binarySearch(data, value, byteComp);
    }

    public static int binarySearch(short[] data, short value) {
        return Arrays.binarySearch(data, value);
    }

    public static int binarySearch(Short[] data, Short value) {
        return Arrays.binarySearch(data, value, shortComp);
    }

    public static int binarySearch(int[] data, int value) {
        return Arrays.binarySearch(data, value);
    }

    public static int binarySearch(Integer[] data, Integer value) {
        return Arrays.binarySearch(data, value, integerComp);
    }

    public static int binarySearch(long[] data, long value) {
        return Arrays.binarySearch(data, value);
    }

    public static int binarySearch(Long[] data, Long value) {
        return Arrays.binarySearch(data, value, longComp);
    }

    public static int binarySearch(float[] data, float value) {
        return Arrays.binarySearch(data, value);
    }

    public static int binarySearch(Float[] data, Float value) {
        return Arrays.binarySearch(data, value, floatComp);
    }

    public static int binarySearch(double[] data, double value) {
        return Arrays.binarySearch(data, value);
    }

    public static int binarySearch(Double[] data, Double value) {
        return Arrays.binarySearch(data, value, doubleComp);
    }

    public static int binarySearch(Object[] data, Object value, Comparator<Object> comp) {
        return Arrays.binarySearch(data, value, comp);
    }
}

