/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH FROM str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(LEADING FROM str) - Removes the leading space characters from `str`.\n\n    _FUNC_(TRAILING FROM str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`.\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(BOTH FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(LEADING FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(TRAILING FROM '    SparkSQL   ');\n           SparkSQL\n      > SELECT _FUNC_('SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mx!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u0002#\u0002\t\u0003)\u0005B\u0002#\u0002\t\u0003\t\u0019\u000e\u0003\u0005E\u0003\u0005\u0005I\u0011QAl\u0011%\ti.AI\u0001\n\u0003\t)\u0006C\u0005\u0002`\u0006\t\t\u0011\"!\u0002b\"I\u0011q^\u0001\u0012\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003c\f\u0011\u0011!C\u0005\u0003g4AAM\u0012A\u000f\"AAL\u0003BK\u0002\u0013\u0005Q\f\u0003\u0005_\u0015\tE\t\u0015!\u0003I\u0011!y&B!f\u0001\n\u0003\u0001\u0007\u0002\u00033\u000b\u0005#\u0005\u000b\u0011B1\t\u000b\tSA\u0011A3\t\u000b\tSA\u0011\u00015\t\u000b\tSA\u0011A6\t\u000b5TA\u0011\t8\t\u000b]TA\u0011\u000b8\t\u000baTA\u0011I=\t\raTA\u0011IA\u0005\u0011\u001d\t\tB\u0003C!\u0003'Aq!!\n\u000b\t#\n9\u0003C\u0005\u00024)\t\t\u0011\"\u0001\u00026!I\u00111\b\u0006\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003'R\u0011\u0013!C\u0001\u0003+B\u0011\"!\u0017\u000b\u0003\u0003%\t%a\u0017\t\u0013\u0005\u001d$\"!A\u0005\u0002\u0005%\u0004\"CA9\u0015\u0005\u0005I\u0011AA:\u0011%\tyHCA\u0001\n\u0003\n\t\tC\u0005\u0002\u0010*\t\t\u0011\"\u0001\u0002\u0012\"I\u00111\u0014\u0006\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003CS\u0011\u0011!C!\u0003G\u000b!b\u0015;sS:<GK]5n\u0015\t!S%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0014(\u0003!\u0019\u0017\r^1msN$(B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003U-\nQa\u001d9be.T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u0001\u0001CA\u0019\u0002\u001b\u0005\u0019#AC*ue&tw\r\u0016:j[N\u0019\u0011\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0002j_*\tq(\u0001\u0003kCZ\f\u0017BA!=\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\t\u0001'A\u0003baBd\u0017\u0010F\u0003G\u0003\u001b\f\t\u000e\u0005\u00022\u0015M)!\u0002S&O#B\u0011\u0011'S\u0005\u0003\u0015\u000e\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t\tD*\u0003\u0002NG\t)2\u000b\u001e:j]\u001e\u0014DK]5n\u000bb\u0004(/Z:tS>t\u0007CA\u001bP\u0013\t\u0001fGA\u0004Qe>$Wo\u0019;\u0011\u0005ISfBA*Y\u001d\t!v+D\u0001V\u0015\t1v&\u0001\u0004=e>|GOP\u0005\u0002o%\u0011\u0011LN\u0001\ba\u0006\u001c7.Y4f\u0013\t\t5L\u0003\u0002Zm\u000511O]2TiJ,\u0012\u0001S\u0001\bgJ\u001c7\u000b\u001e:!\u0003\u001d!(/[7TiJ,\u0012!\u0019\t\u0004k\tD\u0015BA27\u0005\u0019y\u0005\u000f^5p]\u0006AAO]5n'R\u0014\b\u0005F\u0002GM\u001eDQ\u0001X\bA\u0002!CqaX\b\u0011\u0002\u0003\u0007\u0011\rF\u0002GS*DQa\u0018\tA\u0002!CQ\u0001\u0018\tA\u0002!#\"A\u00127\t\u000bq\u000b\u0002\u0019\u0001%\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001p!\t\u0001HO\u0004\u0002reB\u0011AKN\u0005\u0003gZ\na\u0001\u0015:fI\u00164\u0017BA;w\u0005\u0019\u0019FO]5oO*\u00111ON\u0001\nI&\u0014Xm\u0019;j_:\fa\u0001Z8Fm\u0006dGc\u0001>\u0002\u0006A\u001910!\u0001\u000e\u0003qT!! @\u0002\u000bQL\b/Z:\u000b\u0005}L\u0013AB;og\u00064W-C\u0002\u0002\u0004q\u0014!\"\u0016+GqM#(/\u001b8h\u0011\u0019\t9\u0001\u0006a\u0001u\u0006I1O]2TiJLgn\u001a\u000b\u0006u\u0006-\u0011Q\u0002\u0005\u0007\u0003\u000f)\u0002\u0019\u0001>\t\r\u0005=Q\u00031\u0001{\u0003)!(/[7TiJLgnZ\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u000b!\u0015\u0011\u0016qCA\u000e\u0013\r\tIb\u0017\u0002\u0004'\u0016\f\b\u0003BA\u000f\u0003Ci!!a\b\u000b\u0005u<\u0013\u0002BA\u0012\u0003?\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001%\u0002*!9\u00111F\fA\u0002\u00055\u0012a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004BAUA\u0018\u0011&\u0019\u0011\u0011G.\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLH#\u0002$\u00028\u0005e\u0002b\u0002/\u0019!\u0003\u0005\r\u0001\u0013\u0005\b?b\u0001\n\u00111\u0001b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0010+\u0007!\u000b\te\u000b\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013!C;oG\",7m[3e\u0015\r\tiEN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA)\u0003\u000f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0016+\u0007\u0005\f\t%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003Gr\u0014\u0001\u00027b]\u001eL1!^A1\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0007E\u00026\u0003[J1!a\u001c7\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)(a\u001f\u0011\u0007U\n9(C\u0002\u0002zY\u00121!\u00118z\u0011%\ti(HA\u0001\u0002\u0004\tY'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0007\u0003b!!\"\u0002\f\u0006UTBAAD\u0015\r\tIIN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAG\u0003\u000f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111SAM!\r)\u0014QS\u0005\u0004\u0003/3$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003{z\u0012\u0011!a\u0001\u0003k\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QLAP\u0011%\ti\bIA\u0001\u0002\u0004\tY'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003'\u000b)\u000bC\u0005\u0002~\u0005\n\t\u00111\u0001\u0002v!:\"\"!+\u00020\u0006E\u0016QWA\\\u0003w\u000bi,!1\u0002D\u0006\u001d\u0017\u0011\u001a\t\u0004c\u0005-\u0016bAAWG\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAZ\u0003\u0015\u001d&\u0002\t\u0011!A}3UKT\"`QM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!C:$\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b\"P)\"\u0003cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!C:$\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b'F\u0003\u0012Kej\u0012\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002bW-\u00193j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005E\u0012*P\u001b\u0002\u001aHO]\u0015![\u0001\u0012V-\\8wKN\u0004C\u000f[3!iJ\f\u0017\u000e\\5oO\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`QQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\\3bI&tw\rI1oI\u0002\"(/Y5mS:<\u0007\u0005\u0019;sS6\u001cFO\u001d1!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)\u0005>#\u0006\n\t;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fA1,\u0017\rZ5oO\u0002\ng\u000e\u001a\u0011ue\u0006LG.\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006T#B\t&su\t\t;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fA1,\u0017\rZ5oO\u0002\u0002GO]5n'R\u0014\b\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b+S\u0003&c\u0015JT$!iJLWn\u0015;sA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/\u001a\u0011uQ\u0016\u0004CO]1jY&tw\r\t1ue&l7\u000b\u001e:aA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!/\u0002\u0007oT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005\u001e:j[N#(\u000fI\u0017!i\",\u0007\u0005\u001e:j[\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011u_\u0002\"(/[7-AQDW\r\t3fM\u0006,H\u000e\u001e\u0011wC2,X\rI5tA\u0005\u00043/\u001b8hY\u0016\u00043\u000f]1dK*\u0001\u0003\u0005\t\u0011!A)\u0002#i\u0014+IY\u00012%kT'![\u0001\"\b.Z:fA\u0005\u0014X\rI6fs^|'\u000fZ:!i>\u00043\u000f]3dS\u001aL\b\u0005\u001e:j[6Lgn\u001a\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\t|G\u000f\u001b\u0011f]\u0012\u001c\be\u001c4\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1+\u0015\tR%O\u000f2\u0002cIU(NA5\u0002C\u000f[3tK\u0002\n'/\u001a\u0011lKf<xN\u001d3tAQ|\u0007e\u001d9fG&4\u0017\u0010\t;sS6l\u0017N\\4!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011mK\u001a$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!K:$\u0007e\u001c4!i\",\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t+S\u0003&c\u0015JT$-A\u0019\u0013v*\u0014\u0011.AQDWm]3!CJ,\u0007e[3zo>\u0014Hm\u001d\u0011u_\u0002\u001a\b/Z2jMf\u0004CO]5n[&tw\rI:ue&tw\rI2iCJ\f7\r^3sg\u00022'o\\7!i\",\u0007E]5hQRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001eT\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qX\u0001\u0005b)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\t\u0011!AM\u0003\u0018M]6T#2\u0003\u0003\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:l'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\"P)\"\u0003cIU(NA\u001d\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)MA\u0001\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'B\f'o[*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CC*R!E\u0013:;\u0005E\u0012*P\u001b\u0002:\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\u0016*B\u00132Kej\u0012\u0011G%>k\u0005e\n\u0011!A\u0001\u001a\u0006/\u0019:l'Fc\u0005\u0005\t\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'B\f'o[*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\t{E\u000b\u0013\u0011('2;\u0003E\u0012*P\u001b\u0002:3k\u00159be.\u001c\u0016\u000bT*(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:l'FS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006T#B\t&su\tI\u0014T\u0019\u001e\u0002cIU(NA\u001d\u001a6\u000b]1sWN\u000bFjU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]6T#2\u001b&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b+S\u0003&c\u0015JT$!OMcu\u0005\t$S\u001f6\u0003seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003eU*qCJ\\7+\u0015\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011QY\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0017\fAb\u001d;sS:<wLZ;oGNDa!a4\u0004\u0001\u0004A\u0015aA:ue\")ql\u0001a\u0001\u0011R\u0019a)!6\t\r\u0005=G\u00011\u0001I)\u00151\u0015\u0011\\An\u0011\u0015aV\u00011\u0001I\u0011\u001dyV\u0001%AA\u0002\u0005\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019/a;\u0011\tU\u0012\u0017Q\u001d\t\u0006k\u0005\u001d\b*Y\u0005\u0004\u0003S4$A\u0002+va2,'\u0007\u0003\u0005\u0002n\u001e\t\t\u00111\u0001G\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005U\b\u0003BA0\u0003oLA!!?\u0002b\t1qJ\u00196fGR\u0004")
public class StringTrim
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private int collationId;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim x$0) {
        return StringTrim$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return String2TrimExpression.contextIndependentFoldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int collationId$lzycompute() {
        StringTrim stringTrim = this;
        synchronized (stringTrim) {
            if (!this.bitmap$0) {
                this.collationId = String2TrimExpression.collationId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    @Override
    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public String direction() {
        return "BOTH";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return CollationSupport.StringTrim.exec((UTF8String)srcString);
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return CollationSupport.StringTrim.exec((UTF8String)srcString, (UTF8String)trimString, (int)this.collationId());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)Nil$.MODULE$));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcStr();
            }
            case 1: {
                return this.trimStr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcStr";
            }
            case 1: {
                return "trimStr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

