/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mx!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u0002#\u0002\t\u0003)\u0005B\u0002#\u0002\t\u0003\t\u0019\u000e\u0003\u0005E\u0003\u0005\u0005I\u0011QAl\u0011%\ti.AI\u0001\n\u0003\t)\u0006C\u0005\u0002`\u0006\t\t\u0011\"!\u0002b\"I\u0011q^\u0001\u0012\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003c\f\u0011\u0011!C\u0005\u0003g4AAM\u0012A\u000f\"AAL\u0003BK\u0002\u0013\u0005Q\f\u0003\u0005_\u0015\tE\t\u0015!\u0003I\u0011!y&B!f\u0001\n\u0003\u0001\u0007\u0002\u00033\u000b\u0005#\u0005\u000b\u0011B1\t\u000b\tSA\u0011A3\t\u000b\tSA\u0011\u00015\t\u000b\tSA\u0011A6\t\u000b5TA\u0011\t8\t\u000b]TA\u0011\u000b8\t\u000baTA\u0011I=\t\raTA\u0011IA\u0005\u0011\u001d\t\tB\u0003C!\u0003'Aq!!\n\u000b\t#\n9\u0003C\u0005\u00024)\t\t\u0011\"\u0001\u00026!I\u00111\b\u0006\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003'R\u0011\u0013!C\u0001\u0003+B\u0011\"!\u0017\u000b\u0003\u0003%\t%a\u0017\t\u0013\u0005\u001d$\"!A\u0005\u0002\u0005%\u0004\"CA9\u0015\u0005\u0005I\u0011AA:\u0011%\tyHCA\u0001\n\u0003\n\t\tC\u0005\u0002\u0010*\t\t\u0011\"\u0001\u0002\u0012\"I\u00111\u0014\u0006\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003CS\u0011\u0011!C!\u0003G\u000bqb\u0015;sS:<GK]5n%&<\u0007\u000e\u001e\u0006\u0003I\u0015\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011aeJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001A\u0011\u0011'A\u0007\u0002G\ty1\u000b\u001e:j]\u001e$&/[7SS\u001eDGoE\u0002\u0002ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001eA\u001b\u0005a$BA\u001f?\u0003\tIwNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u00011\u0003\u0015\t\u0007\u000f\u001d7z)\u00151\u0015QZAi!\t\t$bE\u0003\u000b\u0011.s\u0015\u000b\u0005\u00022\u0013&\u0011!j\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u0019M\u0013\ti5EA\u000bTiJLgn\u001a\u001aUe&lW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005Uz\u0015B\u0001)7\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0015.\u000f\u0005MCfB\u0001+X\u001b\u0005)&B\u0001,0\u0003\u0019a$o\\8u}%\tq'\u0003\u0002Zm\u00059\u0001/Y2lC\u001e,\u0017BA!\\\u0015\tIf'\u0001\u0004te\u000e\u001cFO]\u000b\u0002\u0011\u000691O]2TiJ\u0004\u0013a\u0002;sS6\u001cFO]\u000b\u0002CB\u0019QG\u0019%\n\u0005\r4$AB(qi&|g.\u0001\u0005ue&l7\u000b\u001e:!)\r1em\u001a\u0005\u00069>\u0001\r\u0001\u0013\u0005\b?>\u0001\n\u00111\u0001b)\r1\u0015N\u001b\u0005\u0006?B\u0001\r\u0001\u0013\u0005\u00069B\u0001\r\u0001\u0013\u000b\u0003\r2DQ\u0001X\tA\u0002!\u000b!\u0002\u001d:fiRLh*Y7f+\u0005y\u0007C\u00019u\u001d\t\t(\u000f\u0005\u0002Um%\u00111ON\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002tm\u0005IA-\u001b:fGRLwN\\\u0001\u0007I>,e/\u00197\u0015\u0007i\f)\u0001E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fQ\u0001^=qKNT!a`\u0015\u0002\rUt7/\u00194f\u0013\r\t\u0019\u0001 \u0002\u000b+R3\u0005h\u0015;sS:<\u0007BBA\u0004)\u0001\u0007!0A\u0005te\u000e\u001cFO]5oOR)!0a\u0003\u0002\u000e!1\u0011qA\u000bA\u0002iDa!a\u0004\u0016\u0001\u0004Q\u0018A\u0003;sS6\u001cFO]5oO\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005U\u0001#\u0002*\u0002\u0018\u0005m\u0011bAA\r7\n\u00191+Z9\u0011\t\u0005u\u0011\u0011E\u0007\u0003\u0003?Q!!`\u0014\n\t\u0005\r\u0012q\u0004\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007\u0019\u000bI\u0003C\u0004\u0002,]\u0001\r!!\f\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0005%\u0006=\u0002*C\u0002\u00022m\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u000b\u0019\u000b9$!\u000f\t\u000fqC\u0002\u0013!a\u0001\u0011\"9q\f\u0007I\u0001\u0002\u0004\t\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u007fQ3\u0001SA!W\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAA'm\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0013q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003/R3!YA!\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r \u0002\t1\fgnZ\u0005\u0004k\u0006\u0005\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA6!\r)\u0014QN\u0005\u0004\u0003_2$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA;\u0003w\u00022!NA<\u0013\r\tIH\u000e\u0002\u0004\u0003:L\b\"CA?;\u0005\u0005\t\u0019AA6\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0011\t\u0007\u0003\u000b\u000bY)!\u001e\u000e\u0005\u0005\u001d%bAAEm\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0015q\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0014\u0006e\u0005cA\u001b\u0002\u0016&\u0019\u0011q\u0013\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u0011QP\u0010\u0002\u0002\u0003\u0007\u0011QO\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002^\u0005}\u0005\"CA?A\u0005\u0005\t\u0019AA6\u0003\u0019)\u0017/^1mgR!\u00111SAS\u0011%\ti(IA\u0001\u0002\u0004\t)\bK\f\u000b\u0003S\u000by+!-\u00026\u0006]\u00161XA_\u0003\u0003\f\u0019-a2\u0002JB\u0019\u0011'a+\n\u0007\u000556EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005M\u0016a\u0012\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA]\u0003\u0005u!\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002#\u0006\t;sS6\u001cFO\u001d\u0011.AQDW\r\t;sS6\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!i>\u0004CO]5nY\u0001\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u0011jg\u0002\n\u0007e]5oO2,\u0007e\u001d9bG\u0016T\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qX\u0001L\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000b\fQ!\r\u00186]A\nQa\u001a:pkB\f#!a3\u0002\u0019M$(/\u001b8h?\u001a,hnY:\t\r\u0005=7\u00011\u0001I\u0003\r\u0019HO\u001d\u0005\u0006?\u000e\u0001\r\u0001\u0013\u000b\u0004\r\u0006U\u0007BBAh\t\u0001\u0007\u0001\nF\u0003G\u00033\fY\u000eC\u0003]\u000b\u0001\u0007\u0001\nC\u0004`\u000bA\u0005\t\u0019A1\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002d\u0006-\b\u0003B\u001bc\u0003K\u0004R!NAt\u0011\u0006L1!!;7\u0005\u0019!V\u000f\u001d7fe!A\u0011Q^\u0004\u0002\u0002\u0003\u0007a)A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA{!\u0011\ty&a>\n\t\u0005e\u0018\u0011\r\u0002\u0007\u001f\nTWm\u0019;")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private int collationId;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight x$0) {
        return StringTrimRight$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return String2TrimExpression.contextIndependentFoldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int collationId$lzycompute() {
        StringTrimRight stringTrimRight = this;
        synchronized (stringTrimRight) {
            if (!this.bitmap$0) {
                this.collationId = String2TrimExpression.collationId$(this);
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    @Override
    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public String direction() {
        return "TRAILING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return CollationSupport.StringTrimRight.exec((UTF8String)srcString);
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return CollationSupport.StringTrimRight.exec((UTF8String)srcString, (UTF8String)trimString, (int)this.collationId());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)Nil$.MODULE$));
    }

    @Override
    public StringTrimRight withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcStr();
            }
            case 1: {
                return this.trimStr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcStr";
            }
            case 1: {
                return "trimStr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

