/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.MetadataColumn;
import org.apache.spark.sql.connector.catalog.SupportsMetadataColumns;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.sql.util.SchemaValidationMode;
import org.apache.spark.sql.util.SchemaValidationMode$PROHIBIT_CHANGES$;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class V2TableUtil$
implements SQLConfHelper {
    public static final V2TableUtil$ MODULE$ = new V2TableUtil$();

    static {
        SQLConfHelper.$init$(MODULE$);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public String toQualifiedName(CatalogPlugin catalog, Identifier ident) {
        return package$.MODULE$.quoteIfNeeded(catalog.name()) + "." + CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted();
    }

    public Seq<String> validateCapturedColumns(Table table, DataSourceV2Relation relation, SchemaValidationMode mode) {
        return this.validateCapturedColumns(table, (Seq<Column>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)relation.table().columns()).toImmutableArraySeq(), mode);
    }

    public Seq<String> validateCapturedColumns(Table table, Seq<Column> originCols, SchemaValidationMode mode) {
        StructType originSchema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(originCols);
        StructType schema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(table.columns());
        return SchemaUtils$.MODULE$.validateSchemaCompatibility(originSchema, schema, this.resolver(), mode);
    }

    public SchemaValidationMode validateCapturedColumns$default$3() {
        return SchemaValidationMode$PROHIBIT_CHANGES$.MODULE$;
    }

    public Seq<String> validateCapturedMetadataColumns(Table table, DataSourceV2Relation relation, SchemaValidationMode mode) {
        return this.validateCapturedMetadataColumns(table, this.extractMetadataColumns(relation), mode);
    }

    public Seq<MetadataColumn> extractMetadataColumns(DataSourceV2Relation relation) {
        Seq metaAttrNames = (Seq)((IterableOps)relation.output().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)V2TableUtil$.$anonfun$extractMetadataColumns$1(x$1)))).map((Function1 & Serializable)x$2 -> x$2.name());
        return this.filter((Seq<String>)metaAttrNames, this.metadataColumns(relation.table()));
    }

    public Seq<String> validateCapturedMetadataColumns(Table table, Seq<MetadataColumn> originMetaCols, SchemaValidationMode mode) {
        Seq originMetaColNames = (Seq)originMetaCols.map((Function1 & Serializable)x$3 -> x$3.name());
        StructType originMetaSchema = CatalogV2Util$.MODULE$.toStructType(originMetaCols);
        Seq<MetadataColumn> metaCols = this.filter((Seq<String>)originMetaColNames, this.metadataColumns(table));
        StructType metaSchema = CatalogV2Util$.MODULE$.toStructType(metaCols);
        return SchemaUtils$.MODULE$.validateSchemaCompatibility(originMetaSchema, metaSchema, this.resolver(), mode);
    }

    public SchemaValidationMode validateCapturedMetadataColumns$default$3() {
        return SchemaValidationMode$PROHIBIT_CHANGES$.MODULE$;
    }

    private Seq<MetadataColumn> filter(Seq<String> colNames, Seq<MetadataColumn> cols) {
        Set normalizedColNames = ((IterableOnceOps)colNames.map((Function1 & Serializable)name -> MODULE$.normalize((String)name))).toSet();
        return (Seq)cols.filter((Function1 & Serializable)col -> BoxesRunTime.boxToBoolean((boolean)normalizedColNames.contains((Object)V2TableUtil$.MODULE$.normalize(col.name()))));
    }

    private Seq<MetadataColumn> metadataColumns(Table table) {
        Table table2 = table;
        if (table2 instanceof SupportsMetadataColumns) {
            SupportsMetadataColumns supportsMetadataColumns = (SupportsMetadataColumns)table2;
            return ArrayImplicits$.MODULE$.SparkArrayOps((Object)supportsMetadataColumns.metadataColumns()).toImmutableArraySeq();
        }
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private String normalize(String name) {
        if (this.conf().caseSensitiveAnalysis()) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    private Function2<String, String, Object> resolver() {
        return this.conf().resolver();
    }

    public static final /* synthetic */ boolean $anonfun$extractMetadataColumns$1(AttributeReference x$1) {
        return package$.MODULE$.MetadataColumnHelper(x$1).isMetadataCol();
    }

    private V2TableUtil$() {
    }
}

