/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.constraints;

import java.util.StringJoiner;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.NamedReference;

abstract class BaseConstraint
implements Constraint {
    private final String name;
    private final boolean enforced;
    private final Constraint.ValidationStatus validationStatus;
    private final boolean rely;

    protected BaseConstraint(String name, boolean enforced, Constraint.ValidationStatus validationStatus, boolean rely) {
        this.name = name;
        this.enforced = enforced;
        this.validationStatus = validationStatus;
        this.rely = rely;
    }

    protected abstract String definition();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean enforced() {
        return this.enforced;
    }

    @Override
    public Constraint.ValidationStatus validationStatus() {
        return this.validationStatus;
    }

    @Override
    public boolean rely() {
        return this.rely;
    }

    @Override
    public String toDDL() {
        return String.format("CONSTRAINT %s %s %s %s", this.name, this.definition(), this.enforced ? "ENFORCED" : "NOT ENFORCED", this.rely ? "RELY" : "NORELY");
    }

    @Override
    public String toDescription() {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(this.definition());
        joiner.add(this.enforced ? "ENFORCED" : "NOT ENFORCED");
        if (this.rely) {
            joiner.add("RELY");
        }
        return joiner.toString();
    }

    public String toString() {
        return this.toDDL();
    }

    protected String toDDL(NamedReference[] columns) {
        StringJoiner joiner = new StringJoiner(", ");
        for (NamedReference column : columns) {
            joiner.add(column.toString());
        }
        return joiner.toString();
    }

    static abstract class Builder<B, C> {
        private final String name;
        private boolean enforced = true;
        private Constraint.ValidationStatus validationStatus = Constraint.ValidationStatus.UNVALIDATED;
        private boolean rely = false;

        Builder(String name) {
            this.name = name;
        }

        protected abstract B self();

        public abstract C build();

        public String name() {
            return this.name;
        }

        public B enforced(boolean enforced) {
            this.enforced = enforced;
            return this.self();
        }

        public boolean enforced() {
            return this.enforced;
        }

        public B validationStatus(Constraint.ValidationStatus validationStatus) {
            if (validationStatus != null) {
                this.validationStatus = validationStatus;
            }
            return this.self();
        }

        public Constraint.ValidationStatus validationStatus() {
            return this.validationStatus;
        }

        public B rely(boolean rely) {
            this.rely = rely;
            return this.self();
        }

        public boolean rely() {
            return this.rely;
        }
    }
}

