/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.read.streaming;

import java.util.Objects;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;

@Evolving
public final class ReadMinRows
implements ReadLimit {
    private long rows;
    private long maxTriggerDelayMs;

    ReadMinRows(long rows, long maxTriggerDelayMs) {
        this.rows = rows;
        this.maxTriggerDelayMs = maxTriggerDelayMs;
    }

    public long minRows() {
        return this.rows;
    }

    public long maxTriggerDelayMs() {
        return this.maxTriggerDelayMs;
    }

    public String toString() {
        return "ReadMinRows{rows=" + this.rows + ", maxTriggerDelayMs=" + this.maxTriggerDelayMs + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadMinRows that = (ReadMinRows)o;
        return this.rows == that.rows && this.maxTriggerDelayMs() == that.maxTriggerDelayMs();
    }

    public int hashCode() {
        return Objects.hash(this.rows, this.maxTriggerDelayMs());
    }
}

