/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.EncryptionPropertiesHelper;
import org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;

public class ParquetWriter<T>
implements Closeable {
    public static final int DEFAULT_BLOCK_SIZE = 0x8000000;
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final CompressionCodecName DEFAULT_COMPRESSION_CODEC_NAME = CompressionCodecName.UNCOMPRESSED;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final boolean DEFAULT_IS_VALIDATING_ENABLED = false;
    public static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.DEFAULT_WRITER_VERSION;
    public static final String OBJECT_MODEL_NAME_PROP = "writer.model.name";
    public static final int MAX_PADDING_SIZE_DEFAULT = 0x800000;
    private final InternalParquetRecordWriter<T> writer;
    private final CompressionCodecFactory codecFactory;

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, true, false);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, pageSize, enableDictionary, validating);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, DEFAULT_WRITER_VERSION);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, new Configuration());
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        this(file, ParquetFileWriter.Mode.CREATE, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, conf);
    }

    @Deprecated
    public ParquetWriter(Path file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        this((OutputFile)HadoopOutputFile.fromPath(file, conf), mode, writeSupport, compressionCodecName, (long)blockSize, validating, conf, 0x800000, ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build(), null);
    }

    @Deprecated
    public ParquetWriter(Path file, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000);
    }

    @Deprecated
    public ParquetWriter(Path file, Configuration conf, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000, 0x100000, true, false, DEFAULT_WRITER_VERSION, conf);
    }

    ParquetWriter(OutputFile file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, long rowGroupSize, boolean validating, Configuration conf, int maxPaddingSize, ParquetProperties encodingProps, FileEncryptionProperties encryptionProperties) throws IOException {
        this(file, mode, writeSupport, compressionCodecName, rowGroupSize, validating, new HadoopParquetConfiguration(conf), maxPaddingSize, encodingProps, encryptionProperties);
    }

    ParquetWriter(OutputFile file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, long rowGroupSize, boolean validating, ParquetConfiguration conf, int maxPaddingSize, ParquetProperties encodingProps, FileEncryptionProperties encryptionProperties) throws IOException {
        this(file, mode, writeSupport, compressionCodecName, new CodecFactory(conf, encodingProps.getPageSizeThreshold()), rowGroupSize, validating, conf, maxPaddingSize, encodingProps, encryptionProperties);
    }

    ParquetWriter(OutputFile file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, CompressionCodecFactory codecFactory, long rowGroupSize, boolean validating, ParquetConfiguration conf, int maxPaddingSize, ParquetProperties encodingProps, FileEncryptionProperties encryptionProperties) throws IOException {
        Map<String, String> extraMetadata;
        WriteSupport.WriteContext writeContext = writeSupport.init(conf);
        MessageType schema = writeContext.getSchema();
        if (encryptionProperties == null) {
            encryptionProperties = EncryptionPropertiesHelper.createEncryptionProperties(conf, file, writeContext);
        }
        ParquetFileWriter fileWriter = new ParquetFileWriter(file, schema, mode, rowGroupSize, maxPaddingSize, encryptionProperties, encodingProps);
        fileWriter.start();
        this.codecFactory = codecFactory;
        CompressionCodecFactory.BytesInputCompressor compressor = codecFactory.getCompressor(compressionCodecName);
        if (encodingProps.getExtraMetaData() == null || encodingProps.getExtraMetaData().isEmpty()) {
            extraMetadata = writeContext.getExtraMetaData();
        } else {
            extraMetadata = new HashMap<String, String>(writeContext.getExtraMetaData());
            encodingProps.getExtraMetaData().forEach((metadataKey, metadataValue) -> {
                if (metadataKey.equals(OBJECT_MODEL_NAME_PROP)) {
                    throw new IllegalArgumentException("Cannot overwrite metadata key writer.model.name. Please use another key name.");
                }
                if (extraMetadata.put((String)metadataKey, (String)metadataValue) != null) {
                    throw new IllegalArgumentException("Duplicate metadata key " + metadataKey + ". Please use another key name.");
                }
            });
        }
        this.writer = new InternalParquetRecordWriter<T>(fileWriter, writeSupport, schema, extraMetadata, rowGroupSize, compressor, validating, encodingProps);
    }

    public void write(T object) throws IOException {
        try {
            this.writer.write(object);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.codecFactory.release();
        }
    }

    public ParquetMetadata getFooter() {
        return this.writer.getFooter();
    }

    public long getDataSize() {
        return this.writer.getDataSize();
    }

    public static abstract class Builder<T, SELF extends Builder<T, SELF>> {
        private OutputFile file = null;
        private Path path = null;
        private FileEncryptionProperties encryptionProperties = null;
        private ParquetConfiguration conf = null;
        private ParquetFileWriter.Mode mode;
        private CompressionCodecFactory codecFactory = null;
        private CompressionCodecName codecName = DEFAULT_COMPRESSION_CODEC_NAME;
        private long rowGroupSize = 0x8000000L;
        private int maxPaddingSize = 0x800000;
        private boolean enableValidation = false;
        private ParquetProperties.Builder encodingPropsBuilder = ParquetProperties.builder();

        protected Builder(Path path) {
            this.path = path;
        }

        protected Builder(OutputFile path) {
            this.file = path;
        }

        protected abstract SELF self();

        @Deprecated
        protected abstract WriteSupport<T> getWriteSupport(Configuration var1);

        protected WriteSupport<T> getWriteSupport(ParquetConfiguration conf) {
            return this.getWriteSupport(ConfigurationUtil.createHadoopConfiguration(conf));
        }

        public SELF withConf(Configuration conf) {
            this.conf = new HadoopParquetConfiguration(conf);
            return this.self();
        }

        public SELF withConf(ParquetConfiguration conf) {
            this.conf = conf;
            return this.self();
        }

        public SELF withWriteMode(ParquetFileWriter.Mode mode) {
            this.mode = mode;
            return this.self();
        }

        public SELF withCompressionCodec(CompressionCodecName codecName) {
            this.codecName = codecName;
            return this.self();
        }

        public SELF withCodecFactory(CompressionCodecFactory codecFactory) {
            this.codecFactory = codecFactory;
            return this.self();
        }

        public SELF withEncryption(FileEncryptionProperties encryptionProperties) {
            this.encryptionProperties = encryptionProperties;
            return this.self();
        }

        @Deprecated
        public SELF withRowGroupSize(int rowGroupSize) {
            return this.withRowGroupSize((long)rowGroupSize);
        }

        public SELF withRowGroupSize(long rowGroupSize) {
            this.rowGroupSize = rowGroupSize;
            return this.self();
        }

        public SELF withPageSize(int pageSize) {
            this.encodingPropsBuilder.withPageSize(pageSize);
            return this.self();
        }

        public SELF withRowGroupRowCountLimit(int rowCount) {
            this.encodingPropsBuilder.withRowGroupRowCountLimit(rowCount);
            return this.self();
        }

        public SELF withPageRowCountLimit(int rowCount) {
            this.encodingPropsBuilder.withPageRowCountLimit(rowCount);
            return this.self();
        }

        public SELF withDictionaryPageSize(int dictionaryPageSize) {
            this.encodingPropsBuilder.withDictionaryPageSize(dictionaryPageSize);
            return this.self();
        }

        public SELF withMaxPaddingSize(int maxPaddingSize) {
            this.maxPaddingSize = maxPaddingSize;
            return this.self();
        }

        public SELF enableDictionaryEncoding() {
            this.encodingPropsBuilder.withDictionaryEncoding(true);
            return this.self();
        }

        public SELF withDictionaryEncoding(boolean enableDictionary) {
            this.encodingPropsBuilder.withDictionaryEncoding(enableDictionary);
            return this.self();
        }

        public SELF withByteStreamSplitEncoding(boolean enableByteStreamSplit) {
            this.encodingPropsBuilder.withByteStreamSplitEncoding(enableByteStreamSplit);
            return this.self();
        }

        public SELF withDictionaryEncoding(String columnPath, boolean enableDictionary) {
            this.encodingPropsBuilder.withDictionaryEncoding(columnPath, enableDictionary);
            return this.self();
        }

        public SELF enableValidation() {
            this.enableValidation = true;
            return this.self();
        }

        public SELF withValidation(boolean enableValidation) {
            this.enableValidation = enableValidation;
            return this.self();
        }

        public SELF withWriterVersion(ParquetProperties.WriterVersion version) {
            this.encodingPropsBuilder.withWriterVersion(version);
            return this.self();
        }

        public SELF enablePageWriteChecksum() {
            this.encodingPropsBuilder.withPageWriteChecksumEnabled(true);
            return this.self();
        }

        public SELF withPageWriteChecksumEnabled(boolean enablePageWriteChecksum) {
            this.encodingPropsBuilder.withPageWriteChecksumEnabled(enablePageWriteChecksum);
            return this.self();
        }

        public SELF withMaxBloomFilterBytes(int maxBloomFilterBytes) {
            this.encodingPropsBuilder.withMaxBloomFilterBytes(maxBloomFilterBytes);
            return this.self();
        }

        public SELF withBloomFilterNDV(String columnPath, long ndv) {
            this.encodingPropsBuilder.withBloomFilterNDV(columnPath, ndv);
            return this.self();
        }

        public SELF withBloomFilterFPP(String columnPath, double fpp) {
            this.encodingPropsBuilder.withBloomFilterFPP(columnPath, fpp);
            return this.self();
        }

        public SELF withAdaptiveBloomFilterEnabled(boolean enabled) {
            this.encodingPropsBuilder.withAdaptiveBloomFilterEnabled(enabled);
            return this.self();
        }

        public SELF withBloomFilterCandidateNumber(String columnPath, int number) {
            this.encodingPropsBuilder.withBloomFilterCandidatesNumber(columnPath, number);
            return this.self();
        }

        public SELF withBloomFilterEnabled(boolean enabled) {
            this.encodingPropsBuilder.withBloomFilterEnabled(enabled);
            return this.self();
        }

        public SELF withBloomFilterEnabled(String columnPath, boolean enabled) {
            this.encodingPropsBuilder.withBloomFilterEnabled(columnPath, enabled);
            return this.self();
        }

        public SELF withMinRowCountForPageSizeCheck(int min) {
            this.encodingPropsBuilder.withMinRowCountForPageSizeCheck(min);
            return this.self();
        }

        public SELF withMaxRowCountForPageSizeCheck(int max) {
            this.encodingPropsBuilder.withMaxRowCountForPageSizeCheck(max);
            return this.self();
        }

        public SELF withColumnIndexTruncateLength(int length) {
            this.encodingPropsBuilder.withColumnIndexTruncateLength(length);
            return this.self();
        }

        public SELF withStatisticsTruncateLength(int length) {
            this.encodingPropsBuilder.withStatisticsTruncateLength(length);
            return this.self();
        }

        public SELF withExtraMetaData(Map<String, String> extraMetaData) {
            this.encodingPropsBuilder.withExtraMetaData(extraMetaData);
            return this.self();
        }

        public SELF withAllocator(ByteBufferAllocator allocator) {
            this.encodingPropsBuilder.withAllocator(allocator);
            return this.self();
        }

        public SELF config(String property, String value) {
            if (this.conf == null) {
                this.conf = new HadoopParquetConfiguration();
            }
            this.conf.set(property, value);
            return this.self();
        }

        public SELF withStatisticsEnabled(String columnPath, boolean enabled) {
            this.encodingPropsBuilder.withStatisticsEnabled(columnPath, enabled);
            return this.self();
        }

        public SELF withStatisticsEnabled(boolean enabled) {
            this.encodingPropsBuilder.withStatisticsEnabled(enabled);
            return this.self();
        }

        public SELF withSizeStatisticsEnabled(String columnPath, boolean enabled) {
            this.encodingPropsBuilder.withSizeStatisticsEnabled(columnPath, enabled);
            return this.self();
        }

        public SELF withSizeStatisticsEnabled(boolean enabled) {
            this.encodingPropsBuilder.withSizeStatisticsEnabled(enabled);
            return this.self();
        }

        public ParquetWriter<T> build() throws IOException {
            if (this.conf == null) {
                this.conf = new HadoopParquetConfiguration();
            }
            ParquetProperties encodingProps = this.encodingPropsBuilder.build();
            if (this.codecFactory == null) {
                this.codecFactory = new CodecFactory(this.conf, encodingProps.getPageSizeThreshold());
            }
            return new ParquetWriter<T>((OutputFile)(this.file != null ? this.file : HadoopOutputFile.fromPath(this.path, ConfigurationUtil.createHadoopConfiguration(this.conf))), this.mode, this.getWriteSupport(this.conf), this.codecName, this.codecFactory, this.rowGroupSize, this.enableValidation, this.conf, this.maxPaddingSize, encodingProps, this.encryptionProperties);
        }
    }
}

