/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.CommutativeRig;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import spire.math.Algebraic;
import spire.math.Complex;
import spire.math.Natural$;
import spire.math.Number;
import spire.math.Number$;
import spire.math.NumberTag;
import spire.math.Quaternion;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.UInt;
import spire.math.UInt$;
import spire.math.ULong$;

@ScalaSignature(bytes="\u0006\u0005\u00115g\u0001CA\u0019\u0003g\t\t#!\u0010\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u00111\u000f\u0001\u0007\u0002\u0005U\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!5\u0001\t\u0003\tI\rC\u0004\u0002T\u0002!\t!!6\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bbBAv\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\t9\u0010\u0001C\u0001\u0003sDqAa\u0003\u0001\t\u0003\tI\rC\u0004\u0003\u000e\u0001!\tAa\u0004\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0016\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0005[\u0001A\u0011\tB\b\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqA!\u000f\u0001\t\u0003\u0012Y\u0004C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\tE\u0003\u0001\"\u0001\u0002p\"9!1\u000b\u0001\u0005\u0002\u0005=\bb\u0002B+\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005/\u0002A\u0011AAx\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003\u0013DqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003\\\u0001!\tAa\u0019\t\u000f\t\u001d\u0004\u0001\"\u0012\u0003j!9!Q\u000e\u0001\u0005\u0002\t=\u0004b\u0002B:\u0001\u0011\u0005!Q\u000f\u0005\b\u0005s\u0002A\u0011\u0001B>\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003CqA!\"\u0001\t\u0003\u00119\tC\u0004\u0003\f\u0002!\tA!$\t\u000f\te\u0004\u0001\"\u0001\u0003\u0012\"9!q\u0010\u0001\u0005\u0002\t]\u0005b\u0002BC\u0001\u0011\u0005!1\u0014\u0005\b\u0005\u0017\u0003A\u0011\u0001BP\u0011\u001d\u0011I\b\u0001C\u0001\u0005GCqAa \u0001\t\u0003\u00119\u000bC\u0004\u0003\u0006\u0002!\tAa+\t\u000f\t-\u0005\u0001\"\u0001\u00030\"9!1\u0017\u0001\u0007\u0002\tU\u0006b\u0002B^\u0001\u0019\u0005!Q\u0018\u0005\b\u0005\u0003\u0004a\u0011\u0001Bb\u0011\u001d\u00119\r\u0001C\u0001\u0005\u0013DqA!4\u0001\r\u0003\u0011y\rC\u0004\u0003T\u00021\tA!6\t\u000f\te\u0007A\"\u0001\u0003\\\"9!1\u0017\u0001\u0005\u0002\t\u0015\bb\u0002B^\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005\u0003\u0004A\u0011\u0001Bw\u0011\u001d\u00119\r\u0001C\u0001\u0005cDqA!4\u0001\t\u0003\u0011)\u0010C\u0004\u0003T\u0002!\tA!?\t\u000f\te\u0007\u0001\"\u0001\u0003~\"9!1\u0017\u0001\u0005\u0002\r\r\u0001b\u0002B^\u0001\u0011\u00051q\u0001\u0005\b\u0005\u0003\u0004A\u0011AB\u0006\u0011\u001d\u0019y\u0001\u0001C\u0001\u0007#Aqaa\u0004\u0001\t\u0003\u0019)\u0002C\u0004\u0003H\u0002!\ta!\u0007\t\u000f\t5\u0007\u0001\"\u0001\u0004\u001e!9!1\u001b\u0001\u0005\u0002\r\u0005\u0002b\u0002Bm\u0001\u0011\u00051Q\u0005\u0005\b\u0007S\u0001A\u0011BB\u0016\u0011\u001d\u0019)\u0004\u0001C\u0001\u0007oAqa!\u0010\u0001\t\u0003\u0019y\u0004C\u0004\u0004D\u0001!\ta!\u0012\t\u000f\r%\u0003\u0001\"\u0001\u0004L!91\u0011\n\u0001\u0005\u0002\r=\u0003bBB*\u0001\u0011\u00051Q\u000b\u0005\b\u0007'\u0002A\u0011AB-\u0011\u001d\u0019i\u0006\u0001C\u0001\u0007?Bqa!\u0018\u0001\t\u0003\u0019\u0019g\u0002\u0005\u0005L\u0006M\u0002\u0012ABC\r!\t\t$a\r\t\u0002\r-\u0004bBA6\u001d\u0012\u000511\u0011\u0005\f\u0007gq%\u0019!C\u0003\u0003g\t)\b\u0003\u0005\u0004\b:\u0003\u000bQBA<\u0011\u001d\u0019II\u0014C\u0002\u0007\u0017Cqaa$O\t\u0003\u0019\t\nC\u0004\u0004\u0010:#\ta!(\t\u000f\r=e\n\"\u0001\u0004\"\"I1Q\u0015(C\u0002\u0013%\u0011\u0011\u001e\u0005\t\u0007Os\u0005\u0015!\u0003\u0002p!91q\u0012(\u0005\u0002\r%\u0006\"CBX\u001d\n\u0007I\u0011AAu\u0011!\u0019\tL\u0014Q\u0001\n\u0005=\u0004\"CBZ\u001d\n\u0007I\u0011AAu\u0011!\u0019)L\u0014Q\u0001\n\u0005=dABB5\u001d\u0002#Y\t\u0003\u0006\u0004Zv\u0013)\u001a!C\u0001\u0003kB!ba?^\u0005#\u0005\u000b\u0011BA<\u0011)\u0019i.\u0018BK\u0002\u0013\u0005\u0011\u0011\u001e\u0005\u000b\t\u001bk&\u0011#Q\u0001\n\u0005=\u0004bBA6;\u0012\u0005Aq\u0012\u0005\b\u0003gjF\u0011AA;\u0011\u001d!)*\u0018C\u0001\u0003SDqAa-^\t\u0003!9\nC\u0004\u0003<v#\t\u0001b'\t\u000f\t\u0005W\f\"\u0001\u0005 \"9!QZ/\u0005\u0002\u0011\r\u0006b\u0002Bj;\u0012\u0005Aq\u0015\u0005\b\u00053lF\u0011\u0001CV\u0011%!Y\"XA\u0001\n\u0003!y\u000bC\u0005\u0005\"u\u000b\n\u0011\"\u0001\u0005$!IAQW/\u0012\u0002\u0013\u0005Aq\u0017\u0005\n\tsi\u0016\u0011!C!\twA\u0011\u0002\"\u0010^\u0003\u0003%\t!!3\t\u0013\u0011}R,!A\u0005\u0002\u0011m\u0006\"\u0003C$;\u0006\u0005I\u0011\tC%\u0011%!9&XA\u0001\n\u0003!y\fC\u0005\u0005^u\u000b\t\u0011\"\u0011\u0005D\"IA1M/\u0002\u0002\u0013\u0005CQM\u0004\n\u0007os\u0015\u0011!E\u0001\u0007s3\u0011b!\u001bO\u0003\u0003E\ta!0\t\u000f\u0005-d\u000f\"\u0001\u0004N\"I!\u0011\b<\u0002\u0002\u0013\u00153q\u001a\u0005\n\u0007\u001f3\u0018\u0011!CA\u0007+D\u0011ba8w\u0003\u0003%\ti!9\t\u0013\r=h/!A\u0005\n\u0005ehABBy\u001d\u0002\u001b\u0019\u0010\u0003\u0006\u0004Zr\u0014)\u001a!C\u0001\u0003kB!ba?}\u0005#\u0005\u000b\u0011BA<\u0011\u001d\tY\u0007 C\u0001\u0007{Dq!a\u001d}\t\u0003\t)\bC\u0004\u00034r$\t\u0001b\u0001\t\u000f\tmF\u0010\"\u0001\u0005\b!9!\u0011\u0019?\u0005\u0002\u0011-\u0001b\u0002Bgy\u0012\u0005Aq\u0002\u0005\b\u0005'dH\u0011\u0001C\n\u0011\u001d\u0011I\u000e C\u0001\t/A\u0011\u0002b\u0007}\u0003\u0003%\t\u0001\"\b\t\u0013\u0011\u0005B0%A\u0005\u0002\u0011\r\u0002\"\u0003C\u001dy\u0006\u0005I\u0011\tC\u001e\u0011%!i\u0004`A\u0001\n\u0003\tI\rC\u0005\u0005@q\f\t\u0011\"\u0001\u0005B!IAq\t?\u0002\u0002\u0013\u0005C\u0011\n\u0005\n\t/b\u0018\u0011!C\u0001\t3B\u0011\u0002\"\u0018}\u0003\u0003%\t\u0005b\u0018\t\u0013\u0011\rD0!A\u0005B\u0011\u0015t!\u0003C:\u001d\u0006\u0005\t\u0012\u0001C;\r%\u0019\tPTA\u0001\u0012\u0003!9\b\u0003\u0005\u0002l\u0005\rB\u0011\u0001C@\u0011)\u0011I$a\t\u0002\u0002\u0013\u00153q\u001a\u0005\u000b\u0007\u001f\u000b\u0019#!A\u0005\u0002\u0012\u0005\u0005BCBp\u0003G\t\t\u0011\"!\u0005\u0006\"Q1q^A\u0012\u0003\u0003%I!!?\t\u0013\r=h*!A\u0005\n\u0005e(a\u0002(biV\u0014\u0018\r\u001c\u0006\u0005\u0003k\t9$\u0001\u0003nCRD'BAA\u001d\u0003\u0015\u0019\b/\u001b:f\u0007\u0001\u0019r\u0001AA \u0003\u001b\n\u0019\u0006\u0005\u0003\u0002B\u0005%SBAA\"\u0015\u0011\t)$!\u0012\u000b\u0005\u0005\u001d\u0013!B:dC2\f\u0017\u0002BA&\u0003\u0007\u00121bU2bY\u0006tU/\u001c2feB!\u0011\u0011IA(\u0013\u0011\t\t&a\u0011\u0003/M\u001b\u0017\r\\1Ok6,'/[2D_:4XM]:j_:\u001c\b\u0003BA+\u0003KrA!a\u0016\u0002b9!\u0011\u0011LA0\u001b\t\tYF\u0003\u0003\u0002^\u0005m\u0012A\u0002\u001fs_>$h(\u0003\u0002\u0002H%!\u00111MA#\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001a\u0002j\ta1+\u001a:jC2L'0\u00192mK*!\u00111MA#\u0003\u0019a\u0014N\\5u}Q\u0011\u0011q\u000e\t\u0004\u0003c\u0002QBAA\u001a\u0003\u0015!\u0017nZ5u+\t\t9\b\u0005\u0003\u0002r\u0005e\u0014\u0002BA>\u0003g\u0011A!V%oi\u0006qam\u001c7e\t&<\u0017\u000e^:MK\u001a$X\u0003BAA\u0003\u0013#B!a!\u00020R!\u0011QQAS!\u0011\t9)!#\r\u0001\u0011Y\u00111R\u0002!\u0002\u0003\u0005)\u0019AAG\u0005\u0005\t\u0015\u0003BAH\u0003/\u0003B!!%\u0002\u00146\u0011\u0011QI\u0005\u0005\u0003+\u000b)EA\u0004O_RD\u0017N\\4\u0011\t\u0005E\u0015\u0011T\u0005\u0005\u00037\u000b)EA\u0002B]fDC!!#\u0002 B!\u0011\u0011SAQ\u0013\u0011\t\u0019+!\u0012\u0003\u0017M\u0004XmY5bY&TX\r\u001a\u0005\b\u0003O\u001b\u0001\u0019AAU\u0003\u00051\u0007CCAI\u0003W\u000b))a\u001e\u0002\u0006&!\u0011QVA#\u0005%1UO\\2uS>t'\u0007C\u0004\u00022\u000e\u0001\r!!\"\u0002\u0003\u0005\fqBZ8mI\u0012Kw-\u001b;t%&<\u0007\u000e^\u000b\u0005\u0003o\u000bi\f\u0006\u0003\u0002:\u0006\u0015G\u0003BA^\u0003\u0003\u0004B!a\"\u0002>\u0012Y\u00111\u0012\u0003!\u0002\u0003\u0005)\u0019AAGQ\u0011\ti,a(\t\u000f\u0005\u001dF\u00011\u0001\u0002DBQ\u0011\u0011SAV\u0003w\u000b9(a/\t\u000f\u0005EF\u00011\u0001\u0002<\u0006Qq-\u001a;Ok6\u0014\u0015\u000e^:\u0016\u0005\u0005-\u0007\u0003BAI\u0003\u001bLA!a4\u0002F\t\u0019\u0011J\u001c;\u0002\u001d\u001d,G\u000fR5hSRdUM\\4uQ\u00061Ao\u001c'jgR,\"!a6\u0011\r\u0005U\u0013\u0011\\A<\u0013\u0011\tY.!\u001b\u0003\t1K7\u000f^\u0001\bi>\f%O]1z+\t\t\t\u000f\u0005\u0004\u0002\u0012\u0006\r\u00181Z\u0005\u0005\u0003K\f)EA\u0003BeJ\f\u00170\u0001\u0005sKZ,'o]3e+\t\ty'\u0001\u0003ue&l\u0017aB5t/\"|G.Z\u000b\u0003\u0003c\u0004B!!%\u0002t&!\u0011Q_A#\u0005\u001d\u0011un\u001c7fC:\f!\"\u001e8eKJd\u00170\u001b8h)\t\tY\u0010\u0005\u0003\u0002~\n\u001dQBAA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0005\u000b\tAA[1wC&!!\u0011BA\u0000\u0005\u0019y%M[3di\u0006A\u0011N\u001c;WC2,X-A\u0005m_:<g+\u00197vKV\u0011!\u0011\u0003\t\u0005\u0003#\u0013\u0019\"\u0003\u0003\u0003\u0016\u0005\u0015#\u0001\u0002'p]\u001e\f!B\u001a7pCR4\u0016\r\\;f+\t\u0011Y\u0002\u0005\u0003\u0002\u0012\nu\u0011\u0002\u0002B\u0010\u0003\u000b\u0012QA\u00127pCR\f1\u0002Z8vE2,g+\u00197vKV\u0011!Q\u0005\t\u0005\u0003#\u00139#\u0003\u0003\u0003*\u0005\u0015#A\u0002#pk\ndW-A\u0003u_&sG/\u0001\u0004u_2{gnZ\u0001\ti>\u0014\u0015nZ%oiV\u0011!1\u0007\t\u0005\u0003+\u0012)$\u0003\u0003\u00038\u0005%$A\u0002\"jO&sG/\u0001\u0005u_N#(/\u001b8h)\t\u0011i\u0004\u0005\u0003\u0003@\t\u001dc\u0002\u0002B!\u0005\u0007\u0002B!!\u0017\u0002F%!!QIA#\u0003\u0019\u0001&/\u001a3fM&!!\u0011\nB&\u0005\u0019\u0019FO]5oO*!!QIA#\u0003\u0019!xNU3qeV\u0011!QH\u0001\u0007SNTVM]8\u0002\u000b%\u001cxJ\\3\u0002\u000b%\u001cx\n\u001a3\u0002\r%\u001cXI^3o\u0003)\u0001xn^3s\u001f\u001a$vo\\\u0001\bG>l\u0007/\u0019:f)\u0011\tYMa\u0018\t\u000f\t\u00054\u00041\u0001\u0002x\u0005\u0019!\u000f[:\u0015\t\u0005-'Q\r\u0005\b\u0005Cb\u0002\u0019AA8\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u001fB6\u0011\u001d\u0011\t'\ba\u0001\u0003/\u000b\u0011\u0002J3rI\u0015\fH%Z9\u0015\t\u0005E(\u0011\u000f\u0005\b\u0005Cr\u0002\u0019AA8\u0003-!S-\u001d\u0013cC:<G%Z9\u0015\t\u0005E(q\u000f\u0005\b\u0005Cz\u0002\u0019AA8\u0003\u0015!C.Z:t)\u0011\t\tP! \t\u000f\t\u0005\u0004\u00051\u0001\u0002p\u0005AA\u0005\\3tg\u0012*\u0017\u000f\u0006\u0003\u0002r\n\r\u0005b\u0002B1C\u0001\u0007\u0011qN\u0001\tI\u001d\u0014X-\u0019;feR!\u0011\u0011\u001fBE\u0011\u001d\u0011\tG\ta\u0001\u0003_\n1\u0002J4sK\u0006$XM\u001d\u0013fcR!\u0011\u0011\u001fBH\u0011\u001d\u0011\tg\ta\u0001\u0003_\"B!!=\u0003\u0014\"9!Q\u0013\u0013A\u0002\u0005]\u0014!\u0001:\u0015\t\u0005E(\u0011\u0014\u0005\b\u0005++\u0003\u0019AA<)\u0011\t\tP!(\t\u000f\tUe\u00051\u0001\u0002xQ!\u0011\u0011\u001fBQ\u0011\u001d\u0011)j\na\u0001\u0003o\"B!!=\u0003&\"9!Q\u0013\u0015A\u0002\tMB\u0003BAy\u0005SCqA!&*\u0001\u0004\u0011\u0019\u0004\u0006\u0003\u0002r\n5\u0006b\u0002BKU\u0001\u0007!1\u0007\u000b\u0005\u0003c\u0014\t\fC\u0004\u0003\u0016.\u0002\rAa\r\u0002\u000b\u0011\u0002H.^:\u0015\t\u0005=$q\u0017\u0005\b\u0005sc\u0003\u0019AA<\u0003\t\u0011H-\u0001\u0004%[&tWo\u001d\u000b\u0005\u0003_\u0012y\fC\u0004\u0003:6\u0002\r!a\u001e\u0002\r\u0011\"\u0018.\\3t)\u0011\tyG!2\t\u000f\tef\u00061\u0001\u0002x\u0005QA\u0005Z5wIQLG\u000eZ3\u0015\t\u0005=$1\u001a\u0005\b\u0005s{\u0003\u0019AA<\u0003\u0011!C-\u001b<\u0015\t\u0005=$\u0011\u001b\u0005\b\u0005s\u0003\u0004\u0019AA<\u0003!!\u0003/\u001a:dK:$H\u0003BA8\u0005/DqA!/2\u0001\u0004\t9(\u0001\u0007%I&4H\u0005]3sG\u0016tG\u000f\u0006\u0003\u0003^\n\r\b\u0003CAI\u0005?\fy'a\u001c\n\t\t\u0005\u0018Q\t\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\te&\u00071\u0001\u0002xQ!!1\u0007Bt\u0011\u001d\u0011\tg\ra\u0001\u0005g!BAa\r\u0003l\"9!\u0011\r\u001bA\u0002\tMB\u0003\u0002B\u001a\u0005_DqA!\u00196\u0001\u0004\u0011\u0019\u0004\u0006\u0003\u00034\tM\bb\u0002B1m\u0001\u0007!1\u0007\u000b\u0005\u0005g\u00119\u0010C\u0004\u0003b]\u0002\rAa\r\u0015\t\tM\"1 \u0005\b\u0005CB\u0004\u0019\u0001B\u001a)\u0011\u0011yp!\u0001\u0011\u0011\u0005E%q\u001cB\u001a\u0005gAqA!\u0019:\u0001\u0004\u0011\u0019\u0004\u0006\u0003\u0002p\r\u0015\u0001b\u0002B1u\u0001\u0007\u0011q\u000e\u000b\u0005\u0003_\u001aI\u0001C\u0004\u0003bm\u0002\r!a\u001c\u0015\t\u0005=4Q\u0002\u0005\b\u0005Cb\u0004\u0019AA8\u0003\r\u0001xn\u001e\u000b\u0005\u0003_\u001a\u0019\u0002C\u0004\u0003bu\u0002\r!a\u001c\u0015\t\u0005=4q\u0003\u0005\b\u0005Cr\u0004\u0019AA<)\u0011\tyga\u0007\t\u000f\t\u0005t\b1\u0001\u0002pQ!\u0011qNB\u0010\u0011\u001d\u0011\t\u0007\u0011a\u0001\u0003_\"B!a\u001c\u0004$!9!\u0011M!A\u0002\u0005=D\u0003\u0002Bo\u0007OAqA!\u0019C\u0001\u0004\ty'A\u0004m_:<G-\u001b<\u0015\r\tu7QFB\u0019\u0011\u001d\u0019yc\u0011a\u0001\u0003_\n1A\\;n\u0011\u001d\u0019\u0019d\u0011a\u0001\u0003_\nQ\u0001Z3o_6\f!\u0002\n7fgN$C.Z:t)\u0011\tyg!\u000f\t\u000f\rmB\t1\u0001\u0002L\u0006\ta.\u0001\u0003dQ>\u0004H\u0003BA8\u0007\u0003Bqaa\u000fF\u0001\u0004\tY-\u0001\t%OJ,\u0017\r^3sI\u001d\u0014X-\u0019;feR!\u0011qNB$\u0011\u001d\u0019YD\u0012a\u0001\u0003\u0017\fA\u0001\n2beR!\u0011qNB'\u0011\u001d\u0011\tg\u0012a\u0001\u0003_\"B!a\u001c\u0004R!9!\u0011\r%A\u0002\u0005]\u0014\u0001\u0002\u0013b[B$B!a\u001c\u0004X!9!\u0011M%A\u0002\u0005=D\u0003BA8\u00077BqA!\u0019K\u0001\u0004\t9(A\u0002%kB$B!a\u001c\u0004b!9!\u0011M&A\u0002\u0005=D\u0003BA8\u0007KBqA!\u0019M\u0001\u0004\t9(K\u0002\u0001;r\u0014Q\u0001R5hSR\u001crATB7\u0007g\u001aI\b\u0005\u0003\u0002\u0012\u000e=\u0014\u0002BB9\u0003\u000b\u0012a!\u00118z%\u00164\u0007\u0003BA9\u0007kJAaa\u001e\u00024\t\u0001b*\u0019;ve\u0006d\u0017J\\:uC:\u001cWm\u001d\t\u0005\u0007w\u001a\t)\u0004\u0002\u0004~)!1q\u0010B\u0002\u0003\tIw.\u0003\u0003\u0002h\ruDCABC!\r\t\tHT\u0001\u0007I\u0016tw.\u001c\u0011\u0002\u001f9\fG/\u001e:bYR{')[4J]R$BAa\r\u0004\u000e\"911\b*A\u0002\u0005=\u0014!B1qa2LH\u0003BA8\u0007'Cqa!&T\u0001\u0004\u00199*\u0001\u0002vgB1\u0011\u0011SBM\u0003oJAaa'\u0002F\tQAH]3qK\u0006$X\r\u001a \u0015\t\u0005=4q\u0014\u0005\b\u0007w!\u0006\u0019\u0001B\t)\u0011\tyga)\t\u000f\rmR\u000b1\u0001\u00034\u0005)A/\u001a82q\u00051A/\u001a82q\u0001\"B!a\u001c\u0004,\"91Q\u0016-A\u0002\tu\u0012!A:\u0002\ti,'o\\\u0001\u0006u\u0016\u0014x\u000eI\u0001\u0004_:,\u0017\u0001B8oK\u0002\nQ\u0001R5hSR\u00042aa/w\u001b\u0005q5#\u0002<\u0004@\u000ee\u0004CCBa\u0007\u000f\f9(a\u001c\u0004L6\u001111\u0019\u0006\u0005\u0007\u000b\f)%A\u0004sk:$\u0018.\\3\n\t\r%71\u0019\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004cAB^;R\u00111\u0011\u0018\u000b\u0003\u0007#\u0004B!!@\u0004T&!!\u0011JA\u0000)\u0019\u0019Yma6\u0004\\\"91\u0011\\=A\u0002\u0005]\u0014!\u00013\t\u000f\ru\u0017\u00101\u0001\u0002p\u0005\u0011A\u000f\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\u0019oa;\u0011\r\u0005E5Q]Bu\u0013\u0011\u00199/!\u0012\u0003\r=\u0003H/[8o!!\t\tJa8\u0002x\u0005=\u0004\"CBwu\u0006\u0005\t\u0019ABf\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u0002\u0004\u000b:$7c\u0002?\u0002p\u0005M3Q\u001f\t\u0005\u0003#\u001b90\u0003\u0003\u0004z\u0006\u0015#a\u0002)s_\u0012,8\r^\u0001\u0003I\u0002\"Baa@\u0005\u0002A\u001911\u0018?\t\u000f\rew\u00101\u0001\u0002xQ!\u0011q\u000eC\u0003\u0011!\u0019Y$a\u0001A\u0002\u0005]D\u0003BA8\t\u0013A\u0001ba\u000f\u0002\u0006\u0001\u0007\u0011q\u000f\u000b\u0005\u0003_\"i\u0001\u0003\u0005\u0004<\u0005\u001d\u0001\u0019AA<)\u0011\ty\u0007\"\u0005\t\u0011\rm\u0012\u0011\u0002a\u0001\u0003o\"B!a\u001c\u0005\u0016!A11HA\u0006\u0001\u0004\t9\b\u0006\u0003\u0003^\u0012e\u0001\u0002CB\u001e\u0003\u001b\u0001\r!a\u001e\u0002\t\r|\u0007/\u001f\u000b\u0005\u0007\u007f$y\u0002\u0003\u0006\u0004Z\u0006=\u0001\u0013!a\u0001\u0003o\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0005&)\"\u0011q\u000fC\u0014W\t!I\u0003\u0005\u0003\u0005,\u0011URB\u0001C\u0017\u0015\u0011!y\u0003\"\r\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002C\u001a\u0003\u000b\n!\"\u00198o_R\fG/[8o\u0013\u0011!9\u0004\"\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007#\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0018\u0012\r\u0003B\u0003C#\u0003/\t\t\u00111\u0001\u0002L\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"\u0001b\u0013\u0011\r\u00115C1KAL\u001b\t!yE\u0003\u0003\u0005R\u0005\u0015\u0013AC2pY2,7\r^5p]&!AQ\u000bC(\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005EH1\f\u0005\u000b\t\u000b\nY\"!AA\u0002\u0005]\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$Ba!5\u0005b!QAQIA\u000f\u0003\u0003\u0005\r!a3\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a3)\u000fq$I\u0007b\u001c\u0005rA!\u0011\u0011\u0013C6\u0013\u0011!i'!\u0012\u0003!M+'/[1m-\u0016\u00148/[8o+&#\u0015!\u0002<bYV,g$\u0001\u0001\u0002\u0007\u0015sG\r\u0005\u0003\u0004<\u0006\r2CBA\u0012\ts\u001aI\b\u0005\u0005\u0004B\u0012m\u0014qOB\u0000\u0013\u0011!iha1\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0005vQ!1q CB\u0011!\u0019I.!\u000bA\u0002\u0005]D\u0003\u0002CD\t\u0013\u0003b!!%\u0004f\u0006]\u0004BCBw\u0003W\t\t\u00111\u0001\u0004\u0000N9Q,a\u001c\u0002T\rU\u0018a\u0001;mAQ111\u001aCI\t'Cqa!7c\u0001\u0004\t9\bC\u0004\u0004^\n\u0004\r!a\u001c\u0002\tQ\f\u0017\u000e\u001c\u000b\u0005\u0003_\"I\nC\u0004\u0004<\u0015\u0004\r!a\u001e\u0015\t\u0005=DQ\u0014\u0005\b\u0007w1\u0007\u0019AA<)\u0011\ty\u0007\")\t\u000f\rmr\r1\u0001\u0002xQ!\u0011q\u000eCS\u0011\u001d\u0019Y\u0004\u001ba\u0001\u0003o\"B!a\u001c\u0005*\"911H5A\u0002\u0005]D\u0003\u0002Bo\t[Cqaa\u000fk\u0001\u0004\t9\b\u0006\u0004\u0004L\u0012EF1\u0017\u0005\n\u00073\\\u0007\u0013!a\u0001\u0003oB\u0011b!8l!\u0003\u0005\r!a\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011A\u0011\u0018\u0016\u0005\u0003_\"9\u0003\u0006\u0003\u0002\u0018\u0012u\u0006\"\u0003C#a\u0006\u0005\t\u0019AAf)\u0011\t\t\u0010\"1\t\u0013\u0011\u0015#/!AA\u0002\u0005]E\u0003BBi\t\u000bD\u0011\u0002\"\u0012t\u0003\u0003\u0005\r!a3)\u000fu#I\u0007b\u001c\u0005r!:\u0001\u0001\"\u001b\u0005p\u0011E\u0014a\u0002(biV\u0014\u0018\r\u001c")
public abstract class Natural
extends ScalaNumber
implements ScalaNumericConversions {
    private static final long serialVersionUID = 0L;

    public static Natural one() {
        return Natural$.MODULE$.one();
    }

    public static Natural zero() {
        return Natural$.MODULE$.zero();
    }

    public static Natural apply(String s) {
        return Natural$.MODULE$.apply(s);
    }

    public static Natural apply(BigInt n) {
        return Natural$.MODULE$.apply(n);
    }

    public static Natural apply(long n) {
        return Natural$.MODULE$.apply(n);
    }

    public static Natural apply(Seq<UInt> us) {
        return Natural$.MODULE$.apply(us);
    }

    public static BigInt naturalToBigInt(Natural n) {
        return Natural$.MODULE$.naturalToBigInt(n);
    }

    public static NumberTag<Natural> NaturalTag() {
        return Natural$.MODULE$.NaturalTag();
    }

    public static CommutativeRig<Natural> NaturalAlgebra() {
        return Natural$.MODULE$.NaturalAlgebra();
    }

    public char toChar() {
        return ScalaNumericAnyConversions.toChar$((ScalaNumericAnyConversions)this);
    }

    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$((ScalaNumericAnyConversions)this);
    }

    public short toShort() {
        return ScalaNumericAnyConversions.toShort$((ScalaNumericAnyConversions)this);
    }

    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$((ScalaNumericAnyConversions)this);
    }

    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidByte() {
        return ScalaNumericAnyConversions.isValidByte$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidShort() {
        return ScalaNumericAnyConversions.isValidShort$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidInt() {
        return ScalaNumericAnyConversions.isValidInt$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidChar() {
        return ScalaNumericAnyConversions.isValidChar$((ScalaNumericAnyConversions)this);
    }

    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$((ScalaNumericAnyConversions)this);
    }

    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$((ScalaNumericAnyConversions)this, (Object)x);
    }

    public abstract int digit();

    public <A> A foldDigitsLeft(A a, Function2<A, UInt, A> f) {
        return (A)this.recur$1(this, a, f, a);
    }

    public <A> A foldDigitsRight(A a, Function2<A, UInt, A> f) {
        return this.reversed().foldDigitsLeft(a, f);
    }

    public int getNumBits() {
        return this.recur$2(this, 0);
    }

    public int getDigitLength() {
        return this.recur$3(this, 0);
    }

    public List<UInt> toList() {
        return this.recur$4(this, (List)package$.MODULE$.Nil());
    }

    /*
     * WARNING - void declaration
     */
    public int[] toArray() {
        void var2_2;
        int n = this.getDigitLength();
        int[] arr = new int[n];
        this.recur$5(this, n - 1, arr);
        return var2_2;
    }

    public Natural reversed() {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            natural = this.recur$6(tail, new End(d));
        } else {
            natural = this;
        }
        return natural;
    }

    public Natural trim() {
        return this.recur$7(this.reversed()).reversed();
    }

    public boolean isWhole() {
        return true;
    }

    public Object underlying() {
        return this;
    }

    public int intValue() {
        return this.toInt();
    }

    public long longValue() {
        return this.toLong();
    }

    public float floatValue() {
        return this.toBigInt().toFloat();
    }

    public double doubleValue() {
        return this.toBigInt().toDouble();
    }

    public int toInt() {
        return UInt$.MODULE$.toInt$extension(this.digit()) & Integer.MAX_VALUE;
    }

    public long toLong() {
        long l;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            l = UInt$.MODULE$.toLong$extension(d);
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            l = (tail.toLong() << (int)32L) + UInt$.MODULE$.toLong$extension(d);
        } else {
            throw new MatchError((Object)natural);
        }
        return l;
    }

    public BigInt toBigInt() {
        BigInt bigInt;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            bigInt = package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(d));
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            bigInt = tail.toBigInt().$less$less(32).$plus(package$.MODULE$.BigInt().apply(UInt$.MODULE$.toLong$extension(d)));
        } else {
            throw new MatchError((Object)natural);
        }
        return bigInt;
    }

    public String toString() {
        return this.recur$8(this, "");
    }

    public String toRepr() {
        return this.toList().mkString("Natural(", ", ", ")");
    }

    public boolean isZero() {
        return this.recur$9(this);
    }

    public boolean isOne() {
        boolean bl;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int n = end.d();
            bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1));
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int n = digit.d();
            Natural tail = digit.tl();
            bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) && tail.isZero();
        } else {
            throw new MatchError((Object)natural);
        }
        return bl;
    }

    public boolean isOdd() {
        return UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(this.digit(), UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(1));
    }

    public boolean isEven() {
        return UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(this.digit(), UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(0));
    }

    public int powerOfTwo() {
        return this.recur$10(this, 0, -1);
    }

    public int compare(int rhs) {
        int n;
        Natural natural = this;
        if (natural instanceof End) {
            End end = (End)natural;
            int d = end.d();
            n = UInt$.MODULE$.$less$extension(d, rhs) ? -1 : (UInt$.MODULE$.$greater$extension(d, rhs) ? 1 : 0);
        } else if (natural instanceof Digit) {
            Digit digit = (Digit)natural;
            int d = digit.d();
            Natural tail = digit.tl();
            n = tail.isZero() ? (UInt$.MODULE$.$greater$extension(d, rhs) ? 1 : (UInt$.MODULE$.$less$extension(d, rhs) ? -1 : 0)) : 1;
        } else {
            throw new MatchError((Object)natural);
        }
        return n;
    }

    public int compare(Natural rhs) {
        return this.recur$11(this, rhs, 0);
    }

    public final boolean equals(Object rhs) {
        boolean bl;
        Object object = rhs;
        if (object instanceof Natural) {
            Natural natural = (Natural)((Object)object);
            bl = this.$eq$eq$eq(natural);
        } else if (object instanceof UInt) {
            int n = ((UInt)object).signed();
            bl = this.compare(n) == 0;
        } else if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            BigInt bigInt2 = this.toBigInt();
            BigInt bigInt3 = bigInt;
            bl = !(bigInt2 != null ? !bigInt2.equals(bigInt3) : bigInt3 != null);
        } else if (object instanceof SafeLong) {
            SafeLong safeLong = (SafeLong)((Object)object);
            bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)SafeLong$.MODULE$.apply(this.toBigInt())), (java.lang.Number)((Object)safeLong));
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            bl = bigDecimal.isWhole() && BoxesRunTime.equalsNumNum((java.lang.Number)this.toBigInt(), (java.lang.Number)bigDecimal);
        } else if (object instanceof Rational) {
            Rational rational = (Rational)((Object)object);
            bl = rational.isWhole() && BoxesRunTime.equalsNumNum((java.lang.Number)((Object)Rational$.MODULE$.apply(this.toBigInt())), (java.lang.Number)((Object)rational));
        } else if (object instanceof Algebraic) {
            Algebraic algebraic = (Algebraic)((Object)object);
            bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)algebraic), (java.lang.Number)((Object)this));
        } else if (object instanceof Real) {
            Real real = (Real)object;
            bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)real.toRational()));
        } else if (object instanceof Number) {
            Number number = (Number)object;
            Number number2 = Number$.MODULE$.apply(this.toBigInt());
            Number number3 = number;
            bl = !(number2 != null ? !number2.equals(number3) : number3 != null);
        } else {
            Quaternion quaternion;
            Complex complex;
            bl = object instanceof Complex ? BoxesRunTime.equalsNumNum((java.lang.Number)((Object)(complex = (Complex)((Object)object))), (java.lang.Number)((Object)this)) : (object instanceof Quaternion ? BoxesRunTime.equalsNumNum((java.lang.Number)((Object)(quaternion = (Quaternion)((Object)object))), (java.lang.Number)((Object)this)) : this.unifiedPrimitiveEquals(object));
        }
        return bl;
    }

    public boolean $eq$eq$eq(Natural rhs) {
        return this.compare(rhs) == 0;
    }

    public boolean $eq$bang$eq(Natural rhs) {
        return !this.$eq$eq$eq(rhs);
    }

    public boolean $less(Natural rhs) {
        return this.compare(rhs) < 0;
    }

    public boolean $less$eq(Natural rhs) {
        return this.compare(rhs) <= 0;
    }

    public boolean $greater(Natural rhs) {
        return this.compare(rhs) > 0;
    }

    public boolean $greater$eq(Natural rhs) {
        return this.compare(rhs) >= 0;
    }

    public boolean $less(int r) {
        return this.compare(r) < 0;
    }

    public boolean $less$eq(int r) {
        return this.compare(r) <= 0;
    }

    public boolean $greater(int r) {
        return this.compare(r) > 0;
    }

    public boolean $greater$eq(int r) {
        return this.compare(r) >= 0;
    }

    public boolean $less(BigInt r) {
        return this.toBigInt().compare(r) < 0;
    }

    public boolean $less$eq(BigInt r) {
        return this.toBigInt().compare(r) <= 0;
    }

    public boolean $greater(BigInt r) {
        return this.toBigInt().compare(r) > 0;
    }

    public boolean $greater$eq(BigInt r) {
        return this.toBigInt().compare(r) >= 0;
    }

    public abstract Natural $plus(int var1);

    public abstract Natural $minus(int var1);

    public abstract Natural $times(int var1);

    public Natural $div$tilde(int rd) {
        return this.$div(rd);
    }

    public abstract Natural $div(int var1);

    public abstract Natural $percent(int var1);

    public abstract Tuple2<Natural, Natural> $div$percent(int var1);

    public BigInt $plus(BigInt rhs) {
        return this.toBigInt().$plus(rhs);
    }

    public BigInt $minus(BigInt rhs) {
        return this.toBigInt().$minus(rhs);
    }

    public BigInt $times(BigInt rhs) {
        return this.toBigInt().$times(rhs);
    }

    public BigInt $div$tilde(BigInt rhs) {
        return this.toBigInt().$div(rhs);
    }

    public BigInt $div(BigInt rhs) {
        return this.toBigInt().$div(rhs);
    }

    public BigInt $percent(BigInt rhs) {
        return this.toBigInt().$percent(rhs);
    }

    public Tuple2<BigInt, BigInt> $div$percent(BigInt rhs) {
        return this.toBigInt().$div$percent(rhs);
    }

    public Natural $plus(Natural rhs) {
        return Natural.recur$12(this, rhs, 0L);
    }

    public Natural $minus(Natural rhs) {
        if (this.$less(rhs)) {
            throw new ArithmeticException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("negative subtraction: %s - %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this, rhs})));
        }
        return Natural.recur$13(this, rhs, 0L);
    }

    public Natural $times(Natural rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = rhs.$times(ld);
        } else if (natural2 instanceof Digit) {
            Natural natural3;
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end = (End)natural4;
                int rd = end.d();
                natural3 = this.$times(rd);
            } else if (natural4 instanceof Digit) {
                Digit digit2 = (Digit)natural4;
                int rd = digit2.d();
                Natural rtail = digit2.tl();
                natural3 = new Digit(UInt$.MODULE$.apply(0), new Digit(UInt$.MODULE$.apply(0), ltail.$times(rtail))).$plus(new Digit(UInt$.MODULE$.apply(0), ltail.$times(rd))).$plus(new Digit(UInt$.MODULE$.apply(0), rtail.$times(ld))).$plus(Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) * UInt$.MODULE$.toLong$extension(rd)));
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural pow(Natural rhs) {
        return this._pow$1(Natural$.MODULE$.apply(1L), this, rhs);
    }

    public Natural pow(int rhs) {
        return this._pow$2(Natural$.MODULE$.apply(1L), this, rhs);
    }

    public Natural $div$tilde(Natural rhs) {
        return this.$div(rhs);
    }

    public Natural $div(Natural rhs) {
        Natural natural;
        Natural natural2 = rhs;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int rd = end.d();
            natural = this.$div(rd);
        } else if (natural2 instanceof Digit) {
            Natural natural3;
            Natural natural4 = this;
            if (natural4 instanceof End) {
                natural3 = new End(UInt$.MODULE$.apply(0));
            } else if (natural4 instanceof Digit) {
                Natural natural5;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        natural5 = this;
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            natural5 = this.$greater$greater(p);
                            break;
                        }
                        natural5 = (Natural)((Object)this.longdiv(this, rhs)._1());
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                natural3 = natural5;
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural $percent(Natural rhs) {
        Natural natural;
        Natural natural2 = rhs;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int rd = end.d();
            natural = this.$percent(rd);
        } else if (natural2 instanceof Digit) {
            End end;
            Natural natural3 = this;
            if (natural3 instanceof End) {
                End end2 = (End)natural3;
                int ld = end2.d();
                end = new End(ld);
            } else if (natural3 instanceof Digit) {
                Natural natural4;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        natural4 = new End(UInt$.MODULE$.apply(0));
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            natural4 = this.$amp(Natural$.MODULE$.apply(1L).$less$less(p).$minus(UInt$.MODULE$.apply(1)));
                            break;
                        }
                        natural4 = (Natural)((Object)this.longdiv(this, rhs)._2());
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                end = natural4;
            } else {
                throw new MatchError((Object)natural3);
            }
            natural = end;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Tuple2<Natural, Natural> $div$percent(Natural rhs) {
        Tuple2 tuple2;
        Natural natural = rhs;
        if (natural instanceof End) {
            End end = (End)natural;
            int rd = end.d();
            tuple2 = new Tuple2((Object)this.$div(rd), (Object)this.$percent(rd));
        } else if (natural instanceof Digit) {
            Tuple2 tuple22;
            Natural natural2 = this;
            if (natural2 instanceof End) {
                tuple22 = new Tuple2((Object)new End(UInt$.MODULE$.apply(0)), (Object)this);
            } else if (natural2 instanceof Digit) {
                Tuple2 tuple23;
                int n = rhs.compare(UInt$.MODULE$.apply(1));
                switch (n) {
                    case -1: {
                        throw new IllegalArgumentException("/ by zero");
                    }
                    case 0: {
                        tuple23 = new Tuple2((Object)this, (Object)Natural$.MODULE$.apply(0L));
                        break;
                    }
                    case 1: {
                        int p = rhs.powerOfTwo();
                        if (p >= 0) {
                            Natural mask = Natural$.MODULE$.apply(1L).$less$less(p).$minus(UInt$.MODULE$.apply(1));
                            tuple23 = new Tuple2((Object)this.$greater$greater(p), (Object)this.$amp(mask));
                            break;
                        }
                        tuple23 = this.longdiv(this, rhs);
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                tuple22 = tuple23;
            } else {
                throw new MatchError((Object)natural2);
            }
            tuple2 = tuple22;
        } else {
            throw new MatchError((Object)natural);
        }
        return tuple2;
    }

    private Tuple2<Natural, Natural> longdiv(Natural num, Natural denom) {
        Natural rem = num;
        Natural quo = Natural$.MODULE$.apply(0L);
        int remBits = rem.getNumBits();
        int denomBits = denom.getNumBits();
        int shift = remBits - denomBits;
        while (shift >= 0) {
            Natural shifted = denom.$less$less(shift);
            if (shifted.$less$eq(rem)) {
                quo = quo.$plus(Natural$.MODULE$.apply(1L).$less$less(shift));
                rem = rem.$minus(shifted);
                remBits = rem.getNumBits();
                shift = remBits - denomBits;
                continue;
            }
            --shift;
        }
        return new Tuple2((Object)quo, (Object)rem);
    }

    public Natural $less$less(int n2) {
        int m = n2 & 0x1F;
        Natural num = Natural.recur$14(this, 0L, m);
        return (Natural)((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n2 / 32).foldLeft((Object)num, (Function2 & Serializable)(n, x$2) -> Natural.$anonfun$$less$less$1(n, BoxesRunTime.unboxToInt((Object)x$2))));
    }

    public Natural chop(int n) {
        return this.recur$15(this, n);
    }

    public Natural $greater$greater(int n) {
        int m = n & 0x1F;
        return Natural.recur$16(this.chop(n / 32).reversed(), 0L, m).reversed();
    }

    public Natural $bar(Natural rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = new End(UInt$.MODULE$.$bar$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                natural3 = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), rtail);
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = rhs;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                digit = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), ltail);
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                digit = new Digit(UInt$.MODULE$.$bar$extension(ld, rd), ltail.$bar(rtail));
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural $bar(int rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = new End(UInt$.MODULE$.$bar$extension(ld, rhs));
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            natural = new Digit(UInt$.MODULE$.$bar$extension(ld, rhs), ltail);
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public Natural $amp(Natural rhs) {
        return Natural.and$1(this, rhs).trim();
    }

    public Natural $amp(int rhs) {
        return new End(UInt$.MODULE$.$amp$extension(this.digit(), rhs));
    }

    public Natural $up(Natural rhs) {
        return Natural.xor$1(this, rhs).trim();
    }

    public Natural $up(int rhs) {
        Natural natural;
        Natural natural2 = this;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int ld = end.d();
            natural = new End(UInt$.MODULE$.$up$extension(ld, rhs));
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int ld = digit.d();
            Natural ltail = digit.tl();
            natural = new Digit(UInt$.MODULE$.$up$extension(ld, rhs), ltail);
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public boolean foldDigitsLeft$mZc$sp(boolean a, Function2<Object, UInt, Object> f) {
        return this.recur$17(this, a, f, a);
    }

    public byte foldDigitsLeft$mBc$sp(byte a, Function2<Object, UInt, Object> f) {
        return this.recur$18(this, a, f, a);
    }

    public char foldDigitsLeft$mCc$sp(char a, Function2<Object, UInt, Object> f) {
        return this.recur$19(this, a, f, a);
    }

    public double foldDigitsLeft$mDc$sp(double a, Function2<Object, UInt, Object> f) {
        return this.recur$20(this, a, f, a);
    }

    public float foldDigitsLeft$mFc$sp(float a, Function2<Object, UInt, Object> f) {
        return this.recur$21(this, a, f, a);
    }

    public int foldDigitsLeft$mIc$sp(int a, Function2<Object, UInt, Object> f) {
        return this.recur$22(this, a, f, a);
    }

    public long foldDigitsLeft$mJc$sp(long a, Function2<Object, UInt, Object> f) {
        return this.recur$23(this, a, f, a);
    }

    public short foldDigitsLeft$mSc$sp(short a, Function2<Object, UInt, Object> f) {
        return this.recur$24(this, a, f, a);
    }

    public void foldDigitsLeft$mVc$sp(BoxedUnit a, Function2<BoxedUnit, UInt, BoxedUnit> f) {
        this.recur$25(this, a, f, a);
    }

    public boolean foldDigitsRight$mZc$sp(boolean a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mZc$sp(a, f);
    }

    public byte foldDigitsRight$mBc$sp(byte a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mBc$sp(a, f);
    }

    public char foldDigitsRight$mCc$sp(char a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mCc$sp(a, f);
    }

    public double foldDigitsRight$mDc$sp(double a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mDc$sp(a, f);
    }

    public float foldDigitsRight$mFc$sp(float a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mFc$sp(a, f);
    }

    public int foldDigitsRight$mIc$sp(int a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mIc$sp(a, f);
    }

    public long foldDigitsRight$mJc$sp(long a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mJc$sp(a, f);
    }

    public short foldDigitsRight$mSc$sp(short a, Function2<Object, UInt, Object> f) {
        return this.reversed().foldDigitsLeft$mSc$sp(a, f);
    }

    public void foldDigitsRight$mVc$sp(BoxedUnit a, Function2<BoxedUnit, UInt, BoxedUnit> f) {
        this.reversed().foldDigitsLeft$mVc$sp(a, f);
    }

    private final Object recur$1(Natural next, Object sofar, Function2 f$1, Object a$1) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = f$1.apply(a$1, (Object)new UInt(d));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        Object object = f$1.apply(a$1, (Object)new UInt(d));
        return object;
    }

    private final int bit$1(int n, int b) {
        while (!UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
            ++b;
            n = UInt$.MODULE$.$greater$greater$greater$extension(n, 1);
        }
        return b;
    }

    private final int recur$2(Natural next, int b) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                Natural tail = digit.tl();
                b += 32;
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        int n = b + this.bit$1(d, 0);
        return n;
    }

    private final int recur$3(Natural next, int n) {
        block1: {
            Natural natural;
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                Natural tail = digit.tl();
                ++n;
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        int n2 = n + 1;
        return n2;
    }

    private final List recur$4(Natural next, List sofar) {
        int d;
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d2 = digit.d();
                Natural tail = digit.tl();
                int n = d2;
                sofar = sofar.$colon$colon((Object)new UInt(n));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int n = d = end.d();
        List list = sofar.$colon$colon((Object)new UInt(n));
        return list;
    }

    private final void recur$5(Natural next, int i, int[] arr$1) {
        int d;
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d2 = digit.d();
                Natural tail = digit.tl();
                arr$1[i] = d2;
                --i;
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        arr$1[i] = d = end.d();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Natural recur$6(Natural next, Natural sofar) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = new Digit(d, sofar);
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        Digit digit = new Digit(d, sofar);
        return digit;
    }

    private final Natural recur$7(Natural next) {
        Natural natural;
        block4: {
            Natural natural2;
            while ((natural2 = next) instanceof Digit) {
                Digit digit = (Digit)natural2;
                int n = digit.d();
                Natural tail = digit.tl();
                if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                    next = tail;
                    continue;
                }
                natural = next;
                break block4;
            }
            if (natural2 instanceof End) {
                natural = next;
            } else {
                throw new MatchError((Object)natural2);
            }
        }
        return natural;
    }

    private final String recur$8(Natural next, String s) {
        String string;
        block3: {
            Natural natural;
            block4: {
                Natural r;
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int d = end.d();
                        string = new StringBuilder(0).append(Long.toString(UInt$.MODULE$.toLong$extension(d))).append(s).toString();
                        break block3;
                    }
                    if (!(natural instanceof Digit)) break block4;
                    Tuple2<Natural, Natural> tuple2 = next.$div$percent(Natural$.MODULE$.denom());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Natural q = (Natural)((Object)tuple2._1());
                    Natural r2 = (Natural)((Object)tuple2._2());
                    Tuple2 tuple22 = new Tuple2((Object)q, (Object)r2);
                    Tuple2 tuple23 = tuple22;
                    Natural q2 = (Natural)((Object)tuple23._1());
                    r = (Natural)((Object)tuple23._2());
                    if (q2.isZero()) break;
                    s = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%09d%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)UInt$.MODULE$.toLong$extension(r.digit())), s}));
                    next = q2;
                }
                string = new StringBuilder(0).append(Long.toString(UInt$.MODULE$.toLong$extension(r.digit()))).append(s).toString();
                break block3;
            }
            throw new MatchError((Object)natural);
        }
        return string;
    }

    private final boolean recur$9(Natural next) {
        boolean bl;
        block2: {
            Natural natural;
            block3: {
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int n = end.d();
                        bl = UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0));
                        break block2;
                    }
                    if (!(natural instanceof Digit)) break block3;
                    Digit digit = (Digit)natural;
                    int n = digit.d();
                    Natural tail = digit.tl();
                    if (!UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) break;
                    next = tail;
                }
                bl = false;
                break block2;
            }
            throw new MatchError((Object)natural);
        }
        return bl;
    }

    private static final int test$1(int n) {
        int i;
        if ((n & -n) != n) {
            return -1;
        }
        for (i = 1; i < 32 && UInt$.MODULE$.$bang$eq$extension(UInt$.MODULE$.$greater$greater$greater$extension(n, i), UInt$.MODULE$.apply(0)); ++i) {
        }
        return i - 1;
    }

    private final int recur$10(Natural next, int shift, int bit) {
        int n;
        block3: {
            Natural natural;
            block4: {
                while (true) {
                    if ((natural = next) instanceof End) {
                        End end = (End)natural;
                        int n2 = end.d();
                        int t = Natural.test$1(n2);
                        n = t < 0 ? -1 : (bit < 0 ? shift + t : -1);
                        break block3;
                    }
                    if (!(natural instanceof Digit)) break block4;
                    Digit digit = (Digit)natural;
                    int n3 = digit.d();
                    Natural tail = digit.tl();
                    int t = Natural.test$1(n3);
                    if (t < 0) {
                        shift += 32;
                        next = tail;
                        continue;
                    }
                    if (bit >= 0) break;
                    bit = shift + t;
                    shift += 32;
                    next = tail;
                }
                n = -1;
                break block3;
            }
            throw new MatchError((Object)natural);
        }
        return n;
    }

    private static final int cmp$1(int a, int b, int c) {
        return UInt$.MODULE$.$less$extension(a, b) ? -1 : (UInt$.MODULE$.$greater$extension(a, b) ? 1 : c);
    }

    private final int recur$11(Natural lhs, Natural rhs, int d) {
        int n;
        block6: {
            Natural natural;
            block7: {
                Natural natural2;
                block8: {
                    while (true) {
                        if ((natural = lhs) instanceof End) {
                            int n2;
                            End end = (End)natural;
                            int ld = end.d();
                            Natural natural3 = rhs;
                            if (natural3 instanceof End) {
                                End end2 = (End)natural3;
                                int rd = end2.d();
                                n2 = Natural.cmp$1(ld, rd, d);
                            } else if (natural3 instanceof Digit) {
                                n2 = -rhs.compare(ld);
                            } else {
                                throw new MatchError((Object)natural3);
                            }
                            n = n2;
                            break block6;
                        }
                        if (!(natural instanceof Digit)) break block7;
                        Digit digit = (Digit)natural;
                        int ld = digit.d();
                        Natural ltail = digit.tl();
                        natural2 = rhs;
                        if (natural2 instanceof End) break block8;
                        if (!(natural2 instanceof Digit)) break;
                        Digit digit2 = (Digit)natural2;
                        int rd = digit2.d();
                        Natural rtail = digit2.tl();
                        d = Natural.cmp$1(ld, rd, d);
                        rhs = rtail;
                        lhs = ltail;
                    }
                    throw new MatchError((Object)natural2);
                }
                End end = (End)natural2;
                int rd = end.d();
                int n3 = lhs.compare(rd);
                n = n3;
                break block6;
            }
            throw new MatchError((Object)natural);
        }
        return n;
    }

    private static final Natural recur$12(Natural left, Natural right, long carry) {
        Natural natural;
        Natural natural2 = left;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = right;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry);
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                natural3 = new Digit(UInt$.MODULE$.apply(t), rtail.$plus(UInt$.MODULE$.apply(t >> 32)));
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = right;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                digit = new Digit(UInt$.MODULE$.apply(t), ltail.$plus(UInt$.MODULE$.apply(t >> 32)));
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                long t = UInt$.MODULE$.toLong$extension(ld) + UInt$.MODULE$.toLong$extension(rd) + carry;
                digit = new Digit(UInt$.MODULE$.apply(t), Natural.recur$12(ltail, rtail, t >> 32));
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private static final Natural recur$13(Natural left, Natural right, long carry) {
        Natural natural;
        Natural natural2 = left;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = right;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry);
            } else if (natural4 instanceof Digit) {
                long t;
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                Natural tl = rtail.$minus(UInt$.MODULE$.apply(-((t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry) >> 32)));
                natural3 = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = right;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                long t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry;
                Natural tl = ltail.$minus(UInt$.MODULE$.apply(-(t >> 32)));
                digit = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else if (natural5 instanceof Digit) {
                long t;
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                Natural tl = Natural.recur$13(ltail, rtail, -((t = UInt$.MODULE$.toLong$extension(ld) - UInt$.MODULE$.toLong$extension(rd) - carry) >> 32));
                digit = tl instanceof End && UInt$.MODULE$.$eq$eq$extension(tl.digit(), UInt$.MODULE$.apply(0)) ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), tl);
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private final Natural _pow$1(Natural t, Natural b, Natural e) {
        while (!e.isZero()) {
            if (e.isOdd()) {
                Natural natural = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final Natural _pow$2(Natural t, Natural b, int e) {
        while (!UInt$.MODULE$.$eq$eq$extension(e, UInt$.MODULE$.apply(0))) {
            if (UInt$.MODULE$.$eq$eq$extension(UInt$.MODULE$.$amp$extension(e, UInt$.MODULE$.apply(1)), UInt$.MODULE$.apply(1))) {
                Natural natural = t.$times(b);
                e = UInt$.MODULE$.$greater$greater$extension(e, 1);
                b = b.$times(b);
                t = natural;
                continue;
            }
            e = UInt$.MODULE$.$greater$greater$extension(e, 1);
            b = b.$times(b);
        }
        return t;
    }

    private static final Natural recur$14(Natural next, long carry, int m$1) {
        Natural natural;
        Natural natural2 = next;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int d = end.d();
            natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(d) << m$1 | carry);
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            long t = UInt$.MODULE$.toLong$extension(d) << m$1 | carry;
            natural = new Digit(UInt$.MODULE$.apply(t), Natural.recur$14(tail, t >> 32, m$1));
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    public static final /* synthetic */ Digit $anonfun$$less$less$1(Natural n, int x$2) {
        return new Digit(UInt$.MODULE$.apply(0), n);
    }

    private final Natural recur$15(Natural next, int n) {
        Natural natural;
        block2: {
            block3: {
                Natural natural2;
                while (true) {
                    if (n <= 0) {
                        natural = next;
                        break block2;
                    }
                    natural2 = next;
                    if (natural2 instanceof End) break block3;
                    if (!(natural2 instanceof Digit)) break;
                    Digit digit = (Digit)natural2;
                    Natural tail = digit.tl();
                    --n;
                    next = tail;
                }
                throw new MatchError((Object)natural2);
            }
            End end = new End(UInt$.MODULE$.apply(0));
            natural = end;
        }
        return natural;
    }

    private static final Natural recur$16(Natural next, long carry, int m$2) {
        Natural natural;
        Natural natural2 = next;
        if (natural2 instanceof End) {
            End end = (End)natural2;
            int d = end.d();
            natural = Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(d) >> m$2 | carry);
        } else if (natural2 instanceof Digit) {
            Digit digit = (Digit)natural2;
            int d = digit.d();
            Natural tail = digit.tl();
            long t = (UInt$.MODULE$.toLong$extension(d) | carry) << 32 - m$2;
            natural = new Digit(UInt$.MODULE$.apply(t >> 32), Natural.recur$16(tail, t & 0xFFFFFFFFL, m$2));
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private static final Natural and$1(Natural lhs, Natural rhs) {
        End end;
        Natural natural = lhs;
        if (natural instanceof End) {
            End end2;
            End end3 = (End)natural;
            int ld = end3.d();
            Natural natural2 = rhs;
            if (natural2 instanceof End) {
                End end4 = (End)natural2;
                int rd = end4.d();
                end2 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else if (natural2 instanceof Digit) {
                Digit digit = (Digit)natural2;
                int rd = digit.d();
                end2 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else {
                throw new MatchError((Object)natural2);
            }
            end = end2;
        } else if (natural instanceof Digit) {
            Natural natural3;
            Digit digit = (Digit)natural;
            int ld = digit.d();
            Natural ltail = digit.tl();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end5 = (End)natural4;
                int rd = end5.d();
                natural3 = new End(UInt$.MODULE$.$amp$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit2 = (Digit)natural4;
                int rd = digit2.d();
                Natural rtail = digit2.tl();
                natural3 = new Digit(UInt$.MODULE$.$amp$extension(ld, rd), Natural.and$1(ltail, rtail));
            } else {
                throw new MatchError((Object)natural4);
            }
            end = natural3;
        } else {
            throw new MatchError((Object)natural);
        }
        return end;
    }

    private static final Natural xor$1(Natural lhs, Natural rhs) {
        Natural natural;
        Natural natural2 = lhs;
        if (natural2 instanceof End) {
            Natural natural3;
            End end = (End)natural2;
            int ld = end.d();
            Natural natural4 = rhs;
            if (natural4 instanceof End) {
                End end2 = (End)natural4;
                int rd = end2.d();
                natural3 = new End(UInt$.MODULE$.$up$extension(ld, rd));
            } else if (natural4 instanceof Digit) {
                Digit digit = (Digit)natural4;
                int rd = digit.d();
                Natural rtail = digit.tl();
                natural3 = new Digit(UInt$.MODULE$.$up$extension(ld, rd), rtail);
            } else {
                throw new MatchError((Object)natural4);
            }
            natural = natural3;
        } else if (natural2 instanceof Digit) {
            Digit digit;
            Digit digit2 = (Digit)natural2;
            int ld = digit2.d();
            Natural ltail = digit2.tl();
            Natural natural5 = rhs;
            if (natural5 instanceof End) {
                End end = (End)natural5;
                int rd = end.d();
                digit = new Digit(UInt$.MODULE$.$up$extension(ld, rd), ltail);
            } else if (natural5 instanceof Digit) {
                Digit digit3 = (Digit)natural5;
                int rd = digit3.d();
                Natural rtail = digit3.tl();
                digit = new Digit(UInt$.MODULE$.$up$extension(ld, rd), ltail.$up(rtail));
            } else {
                throw new MatchError((Object)natural5);
            }
            natural = digit;
        } else {
            throw new MatchError((Object)natural2);
        }
        return natural;
    }

    private final boolean recur$17(Natural next, boolean sofar, Function2 f$2, boolean a$2) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToBoolean((Object)f$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)a$2), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)f$2.apply((Object)BoxesRunTime.boxToBoolean((boolean)a$2), (Object)new UInt(d)));
        return bl;
    }

    private final byte recur$18(Natural next, byte sofar, Function2 f$3, byte a$3) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToByte((Object)f$3.apply((Object)BoxesRunTime.boxToByte((byte)a$3), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        byte by = BoxesRunTime.unboxToByte((Object)f$3.apply((Object)BoxesRunTime.boxToByte((byte)a$3), (Object)new UInt(d)));
        return by;
    }

    private final char recur$19(Natural next, char sofar, Function2 f$4, char a$4) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToChar((Object)f$4.apply((Object)BoxesRunTime.boxToCharacter((char)a$4), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        char c = BoxesRunTime.unboxToChar((Object)f$4.apply((Object)BoxesRunTime.boxToCharacter((char)a$4), (Object)new UInt(d)));
        return c;
    }

    private final double recur$20(Natural next, double sofar, Function2 f$5, double a$5) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToDouble((Object)f$5.apply((Object)BoxesRunTime.boxToDouble((double)a$5), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        double d2 = BoxesRunTime.unboxToDouble((Object)f$5.apply((Object)BoxesRunTime.boxToDouble((double)a$5), (Object)new UInt(d)));
        return d2;
    }

    private final float recur$21(Natural next, float sofar, Function2 f$6, float a$6) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToFloat((Object)f$6.apply((Object)BoxesRunTime.boxToFloat((float)a$6), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        float f = BoxesRunTime.unboxToFloat((Object)f$6.apply((Object)BoxesRunTime.boxToFloat((float)a$6), (Object)new UInt(d)));
        return f;
    }

    private final int recur$22(Natural next, int sofar, Function2 f$7, int a$7) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToInt((Object)f$7.apply((Object)BoxesRunTime.boxToInteger((int)a$7), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        int n = BoxesRunTime.unboxToInt((Object)f$7.apply((Object)BoxesRunTime.boxToInteger((int)a$7), (Object)new UInt(d)));
        return n;
    }

    private final long recur$23(Natural next, long sofar, Function2 f$8, long a$8) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToLong((Object)f$8.apply((Object)BoxesRunTime.boxToLong((long)a$8), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        long l = BoxesRunTime.unboxToLong((Object)f$8.apply((Object)BoxesRunTime.boxToLong((long)a$8), (Object)new UInt(d)));
        return l;
    }

    private final short recur$24(Natural next, short sofar, Function2 f$9, short a$9) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = BoxesRunTime.unboxToShort((Object)f$9.apply((Object)BoxesRunTime.boxToShort((short)a$9), (Object)new UInt(d)));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        short s = BoxesRunTime.unboxToShort((Object)f$9.apply((Object)BoxesRunTime.boxToShort((short)a$9), (Object)new UInt(d)));
        return s;
    }

    private final void recur$25(Natural next, BoxedUnit sofar, Function2 f$10, BoxedUnit a$10) {
        Natural natural;
        block1: {
            while (true) {
                if ((natural = next) instanceof End) break block1;
                if (!(natural instanceof Digit)) break;
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                sofar = (BoxedUnit)f$10.apply((Object)a$10, (Object)new UInt(d));
                next = tail;
            }
            throw new MatchError((Object)natural);
        }
        End end = (End)natural;
        int d = end.d();
        BoxedUnit boxedUnit = (BoxedUnit)f$10.apply((Object)a$10, (Object)new UInt(d));
    }

    public Natural() {
        ScalaNumericAnyConversions.$init$((ScalaNumericAnyConversions)this);
    }

    public static class Digit
    extends Natural
    implements Product {
        private static final long serialVersionUID = 0L;
        private final int d;
        private final Natural tl;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int d() {
            return this.d;
        }

        public Natural tl() {
            return this.tl;
        }

        @Override
        public int digit() {
            return this.d();
        }

        public Natural tail() {
            return this.tl();
        }

        @Override
        public Natural $plus(int n) {
            Digit digit;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                digit = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) + UInt$.MODULE$.toLong$extension(n);
                digit = new Digit(UInt$.MODULE$.apply(t), this.tail().$plus(UInt$.MODULE$.apply(t >> 32)));
            }
            return digit;
        }

        @Override
        public Natural $minus(int n) {
            Digit digit;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                digit = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) - UInt$.MODULE$.toLong$extension(n);
                digit = new Digit(UInt$.MODULE$.apply(t), this.tail().$minus(UInt$.MODULE$.apply(-(t >> 32))));
            }
            return digit;
        }

        @Override
        public Natural $times(int n) {
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? new End(n) : (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) ? this : Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(this.d()) * UInt$.MODULE$.toLong$extension(n)).$plus(new Digit(UInt$.MODULE$.apply(0), this.tl().$times(n))));
        }

        @Override
        public Natural $div(int n) {
            return (Natural)((Object)this.$div$percent(n)._1());
        }

        @Override
        public Natural $percent(int n) {
            return (Natural)((Object)this.$div$percent(n)._2());
        }

        @Override
        public Tuple2<Natural, Natural> $div$percent(int n) {
            Tuple2 tuple2;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1))) {
                tuple2 = new Tuple2((Object)this, (Object)Natural$.MODULE$.apply((Seq<UInt>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new UInt[]{new UInt(UInt$.MODULE$.apply(0))})));
            } else {
                Natural natural = this.reversed();
                if (!(natural instanceof Digit)) {
                    throw new IllegalArgumentException("bug in reversed");
                }
                Digit digit = (Digit)natural;
                int d = digit.d();
                Natural tail = digit.tl();
                int q = UInt$.MODULE$.$div$extension(d, n);
                int r = UInt$.MODULE$.$percent$extension(d, n);
                Tuple2 tuple22 = this.recur$26(tail, r, new End(q), n);
                tuple2 = tuple22;
            }
            return tuple2;
        }

        public Digit copy(int d, Natural tl) {
            return new Digit(d, tl);
        }

        public int copy$default$1() {
            return this.d();
        }

        public Natural copy$default$2() {
            return this.tl();
        }

        public String productPrefix() {
            return "Digit";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new UInt(this.d());
                    break;
                }
                case 1: {
                    object = this.tl();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Digit;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "d";
                    break;
                }
                case 1: {
                    string = "tl";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        private final Tuple2 recur$26(Natural next, int rem, Natural sofar, int n$1) {
            long r;
            long q;
            block1: {
                Natural natural;
                while (true) {
                    long t = ULong$.MODULE$.$plus$extension(ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(rem) << 32), ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(next.digit())));
                    q = ULong$.MODULE$.toLong$extension(ULong$.MODULE$.$div$extension(t, ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(n$1))));
                    r = ULong$.MODULE$.toLong$extension(ULong$.MODULE$.$percent$extension(t, ULong$.MODULE$.apply(UInt$.MODULE$.toLong$extension(n$1))));
                    natural = next;
                    if (natural instanceof End) break block1;
                    if (!(natural instanceof Digit)) break;
                    Digit digit = (Digit)natural;
                    Natural tail = digit.tl();
                    sofar = new Digit(UInt$.MODULE$.apply(q), sofar);
                    rem = UInt$.MODULE$.apply(r);
                    next = tail;
                }
                throw new MatchError((Object)natural);
            }
            Tuple2 tuple2 = new Tuple2((Object)new Digit(UInt$.MODULE$.apply(q), sofar), (Object)new End(UInt$.MODULE$.apply(r)));
            return tuple2;
        }

        public Digit(int d, Natural tl) {
            this.d = d;
            this.tl = tl;
            Product.$init$((Product)this);
        }
    }

    public static class End
    extends Natural
    implements Product {
        private static final long serialVersionUID = 0L;
        private final int d;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int d() {
            return this.d;
        }

        @Override
        public int digit() {
            return this.d();
        }

        @Override
        public Natural $plus(int n) {
            long t;
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? this : ((t = UInt$.MODULE$.toLong$extension(this.d()) + UInt$.MODULE$.toLong$extension(n)) <= 0xFFFFFFFFL ? new End(UInt$.MODULE$.apply(t)) : new Digit(UInt$.MODULE$.apply(t), new End(UInt$.MODULE$.apply(1))));
        }

        @Override
        public Natural $minus(int n) {
            End end;
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                end = this;
            } else {
                long t = UInt$.MODULE$.toLong$extension(this.d()) - UInt$.MODULE$.toLong$extension(n);
                if (t >= 0L) {
                    end = new End(UInt$.MODULE$.apply((int)t));
                } else {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("illegal subtraction: %s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this, new UInt(n)})));
                }
            }
            return end;
        }

        @Override
        public Natural $times(int n) {
            return UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0)) ? new End(n) : (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(1)) ? this : Natural$.MODULE$.apply(UInt$.MODULE$.toLong$extension(this.d()) * UInt$.MODULE$.toLong$extension(n)));
        }

        @Override
        public Natural $div(int n) {
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            return new End(UInt$.MODULE$.$div$extension(this.d(), n));
        }

        @Override
        public Natural $percent(int n) {
            if (UInt$.MODULE$.$eq$eq$extension(n, UInt$.MODULE$.apply(0))) {
                throw new IllegalArgumentException("/ by zero");
            }
            return new End(UInt$.MODULE$.$percent$extension(this.d(), n));
        }

        @Override
        public Tuple2<Natural, Natural> $div$percent(int n) {
            return new Tuple2((Object)this.$div(n), (Object)this.$percent(n));
        }

        public End copy(int d) {
            return new End(d);
        }

        public int copy$default$1() {
            return this.d();
        }

        public String productPrefix() {
            return "End";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = new UInt(this.d());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof End;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "d";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public End(int d) {
            this.d = d;
            Product.$init$((Product)this);
        }
    }
}

