/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.files;

import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum EntryStatus {
    unknown,
    not_found,
    file,
    dir,
    created_dir;


    public static EntryStatus toEntryStatus(int type) {
        switch (type) {
            case 1: {
                return not_found;
            }
            case 2: {
                return file;
            }
            case 3: {
                return dir;
            }
            case 4: {
                return created_dir;
            }
        }
        return unknown;
    }

    public static EntryStatus toEntryStatus(@Nullable FileStatus st) {
        if (st == null) {
            return not_found;
        }
        if (st.isDirectory()) {
            return dir;
        }
        if (st.isFile()) {
            return file;
        }
        return unknown;
    }
}

