/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.ThreadUtils;

public class ReadAheadInputStream
extends InputStream {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(ReadAheadInputStream.class);
    private ReentrantLock stateChangeLock = new ReentrantLock();
    @GuardedBy(value="stateChangeLock")
    private ByteBuffer activeBuffer;
    @GuardedBy(value="stateChangeLock")
    private ByteBuffer readAheadBuffer;
    @GuardedBy(value="stateChangeLock")
    private boolean endOfStream;
    @GuardedBy(value="stateChangeLock")
    private boolean readInProgress;
    @GuardedBy(value="stateChangeLock")
    private boolean readAborted;
    @GuardedBy(value="stateChangeLock")
    private Throwable readException;
    @GuardedBy(value="stateChangeLock")
    private boolean isClosed;
    @GuardedBy(value="stateChangeLock")
    private boolean isUnderlyingInputStreamBeingClosed;
    @GuardedBy(value="stateChangeLock")
    private boolean isReading;
    private AtomicBoolean isWaiting = new AtomicBoolean(false);
    private final InputStream underlyingInputStream;
    private final ExecutorService executorService = ThreadUtils.newDaemonSingleThreadExecutor("read-ahead");
    private final Condition asyncReadComplete = this.stateChangeLock.newCondition();

    public ReadAheadInputStream(InputStream inputStream, int bufferSizeInBytes) {
        JavaUtils.checkArgument((bufferSizeInBytes > 0 ? 1 : 0) != 0, (String)("bufferSizeInBytes should be greater than 0, but the value is " + bufferSizeInBytes), (Object[])new Object[0]);
        this.activeBuffer = ByteBuffer.allocate(bufferSizeInBytes);
        this.readAheadBuffer = ByteBuffer.allocate(bufferSizeInBytes);
        this.underlyingInputStream = inputStream;
        this.activeBuffer.flip();
        this.readAheadBuffer.flip();
    }

    private boolean isEndOfStream() {
        return !this.activeBuffer.hasRemaining() && !this.readAheadBuffer.hasRemaining() && this.endOfStream;
    }

    private void checkReadException() throws IOException {
        if (this.readAborted) {
            if (this.readException == null) {
                throw new NullPointerException("readException is not captured.");
            }
            Throwable throwable = this.readException;
            if (throwable instanceof IOException) {
                IOException ie = (IOException)throwable;
                throw ie;
            }
            throwable = this.readException;
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            throwable = this.readException;
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throw new IOException(this.readException);
        }
    }

    private void readAsync() throws IOException {
        this.stateChangeLock.lock();
        byte[] arr = this.readAheadBuffer.array();
        try {
            if (this.endOfStream || this.readInProgress) {
                return;
            }
            this.checkReadException();
            this.readAheadBuffer.position(0);
            this.readAheadBuffer.flip();
            this.readInProgress = true;
        }
        finally {
            this.stateChangeLock.unlock();
        }
        this.executorService.execute(() -> {
            this.stateChangeLock.lock();
            try {
                if (this.isClosed) {
                    this.readInProgress = false;
                    return;
                }
                this.isReading = true;
            }
            finally {
                this.stateChangeLock.unlock();
            }
            int read = 0;
            int off = 0;
            int len = arr.length;
            Throwable exception = null;
            try {
                do {
                    if ((read = this.underlyingInputStream.read(arr, off, len)) <= 0) {
                        break;
                    }
                    off += read;
                } while ((len -= read) > 0 && !this.isWaiting.get());
            }
            catch (Throwable ex) {
                exception = ex;
                if (ex instanceof Error) {
                    Error error = (Error)ex;
                    throw error;
                }
            }
            finally {
                this.stateChangeLock.lock();
                this.readAheadBuffer.limit(off);
                if (read < 0 || exception instanceof EOFException) {
                    this.endOfStream = true;
                } else if (exception != null) {
                    this.readAborted = true;
                    this.readException = exception;
                }
                this.readInProgress = false;
                this.signalAsyncReadComplete();
                this.stateChangeLock.unlock();
                this.closeUnderlyingInputStreamIfNecessary();
            }
        });
    }

    private void closeUnderlyingInputStreamIfNecessary() {
        boolean needToCloseUnderlyingInputStream = false;
        this.stateChangeLock.lock();
        try {
            this.isReading = false;
            if (this.isClosed && !this.isUnderlyingInputStreamBeingClosed) {
                needToCloseUnderlyingInputStream = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        if (needToCloseUnderlyingInputStream) {
            try {
                this.underlyingInputStream.close();
            }
            catch (IOException e) {
                logger.warn("{}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.ERROR, (Object)e.getMessage())});
            }
        }
    }

    private void signalAsyncReadComplete() {
        this.stateChangeLock.lock();
        try {
            this.asyncReadComplete.signalAll();
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    private void waitForAsyncReadComplete() throws IOException {
        this.stateChangeLock.lock();
        this.isWaiting.set(true);
        try {
            while (this.readInProgress) {
                this.asyncReadComplete.await();
            }
        }
        catch (InterruptedException e) {
            InterruptedIOException iio = new InterruptedIOException(e.getMessage());
            iio.initCause(e);
            throw iio;
        }
        finally {
            this.isWaiting.set(false);
            this.stateChangeLock.unlock();
        }
        this.checkReadException();
    }

    @Override
    public int read() throws IOException {
        if (this.activeBuffer.hasRemaining()) {
            return this.activeBuffer.get() & 0xFF;
        }
        byte[] oneByteArray = new byte[1];
        return this.read(oneByteArray, 0, 1) == -1 ? -1 : oneByteArray[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || len > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.activeBuffer.hasRemaining()) {
            this.stateChangeLock.lock();
            try {
                this.waitForAsyncReadComplete();
                if (!this.readAheadBuffer.hasRemaining()) {
                    this.readAsync();
                    this.waitForAsyncReadComplete();
                    if (this.isEndOfStream()) {
                        int n = -1;
                        return n;
                    }
                }
                this.swapBuffers();
                this.readAsync();
            }
            finally {
                this.stateChangeLock.unlock();
            }
        }
        len = Math.min(len, this.activeBuffer.remaining());
        this.activeBuffer.get(b, offset, len);
        return len;
    }

    private void swapBuffers() {
        ByteBuffer temp = this.activeBuffer;
        this.activeBuffer = this.readAheadBuffer;
        this.readAheadBuffer = temp;
    }

    @Override
    public int available() throws IOException {
        this.stateChangeLock.lock();
        try {
            int n = (int)Math.min(Integer.MAX_VALUE, (long)this.activeBuffer.remaining() + (long)this.readAheadBuffer.remaining());
            return n;
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        long skipped;
        if (n <= 0L) {
            return 0L;
        }
        if (n <= (long)this.activeBuffer.remaining()) {
            this.activeBuffer.position((int)n + this.activeBuffer.position());
            return n;
        }
        this.stateChangeLock.lock();
        try {
            skipped = this.skipInternal(n);
        }
        finally {
            this.stateChangeLock.unlock();
        }
        return skipped;
    }

    private long skipInternal(long n) throws IOException {
        assert (this.stateChangeLock.isLocked());
        this.waitForAsyncReadComplete();
        if (this.isEndOfStream()) {
            return 0L;
        }
        if ((long)this.available() >= n) {
            int toSkip = (int)n;
            assert ((toSkip -= this.activeBuffer.remaining()) > 0);
            this.activeBuffer.position(0);
            this.activeBuffer.flip();
            this.readAheadBuffer.position(toSkip + this.readAheadBuffer.position());
            this.swapBuffers();
            this.readAsync();
            return n;
        }
        int skippedBytes = this.available();
        long toSkip = n - (long)skippedBytes;
        this.activeBuffer.position(0);
        this.activeBuffer.flip();
        this.readAheadBuffer.position(0);
        this.readAheadBuffer.flip();
        long skippedFromInputStream = this.underlyingInputStream.skip(toSkip);
        this.readAsync();
        return (long)skippedBytes + skippedFromInputStream;
    }

    @Override
    public void close() throws IOException {
        boolean isSafeToCloseUnderlyingInputStream = false;
        this.stateChangeLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (!this.isReading) {
                isSafeToCloseUnderlyingInputStream = true;
                this.isUnderlyingInputStreamBeingClosed = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        try {
            this.executorService.shutdownNow();
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            InterruptedIOException iio = new InterruptedIOException(e.getMessage());
            iio.initCause(e);
            throw iio;
        }
        finally {
            if (isSafeToCloseUnderlyingInputStream) {
                this.underlyingInputStream.close();
            }
        }
    }
}

