/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sinks;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sinks.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.sinks.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.sinks.FileStreamSinkLog$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rw!B\u000f\u001f\u0011\u0003ic!B\u0018\u001f\u0011\u0003\u0001\u0004\"B\u001f\u0002\t\u0003q\u0004bB \u0002\u0005\u0004%\t\u0001\u0011\u0005\u0007\u0013\u0006\u0001\u000b\u0011B!\t\u000b)\u000bA\u0011A&\t\u000bU\fA\u0011\u0001<\t\u000f\u0005\u001d\u0011\u0001\"\u0001\u0002\n!9\u0011\u0011D\u0001\u0005\u0002\u0005ma!B\u0018\u001f\u0001\u0005\u0005\u0002BCA\u0019\u0013\t\u0005\t\u0015!\u0003\u00024!A\u0001+\u0003B\u0001B\u0003%Q\f\u0003\u0006\u0002<%\u0011\t\u0011)A\u0005\u0003{A\u0011\"!\u0013\n\u0005\u0003\u0005\u000b\u0011B)\t\u0015\u0005-\u0013B!A!\u0002\u0013\ti\u0005\u0003\u0004>\u0013\u0011\u0005\u00111\u000b\u0005\tK&\u0011\r\u0011\"\u0003\u0002b!9\u00111M\u0005!\u0002\u00131\u0007\"CA3\u0013\t\u0007I\u0011BA4\u0011\u001d\tI'\u0003Q\u0001\n]D\u0011\"a\u001b\n\u0005\u0004%I!a\u001a\t\u000f\u00055\u0014\u0002)A\u0005o\"I\u0011qN\u0005C\u0002\u0013%\u0011\u0011\u000f\u0005\t\u0003\u007fJ\u0001\u0015!\u0003\u0002t!I\u0011\u0011Q\u0005C\u0002\u0013%\u00111\u0011\u0005\t\u0003\u0017K\u0001\u0015!\u0003\u0002\u0006\"9\u0011QR\u0005\u0005\n\u0005=\u0005bBAL\u0013\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003\u007fKA\u0011IAa\u000391\u0015\u000e\\3TiJ,\u0017-\\*j].T!a\b\u0011\u0002\u000bMLgn[:\u000b\u0005\u0005\u0012\u0013!C:ue\u0016\fW.\u001b8h\u0015\t\u0019C%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001A\u0011a&A\u0007\u0002=\tqa)\u001b7f'R\u0014X-Y7TS:\\7cA\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0014\u0002\u0011%tG/\u001a:oC2L!\u0001P\u001d\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!L\u0001\f[\u0016$\u0018\rZ1uC\u0012K'/F\u0001B!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u0015;sS:<\u0017\u0001D7fi\u0006$\u0017\r^1ESJ\u0004\u0013a\u00035bg6+G/\u00193bi\u0006$B\u0001T(e]B\u0011!'T\u0005\u0003\u001dN\u0012qAQ8pY\u0016\fg\u000eC\u0003Q\u000b\u0001\u0007\u0011+\u0001\u0003qCRD\u0007c\u0001*[;:\u00111\u000b\u0017\b\u0003)^k\u0011!\u0016\u0006\u0003-2\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005e\u001b\u0014a\u00029bG.\fw-Z\u0005\u00037r\u00131aU3r\u0015\tI6\u0007\u0005\u0002_E:\u0011q\f\u0019\t\u0003)NJ!!Y\u001a\u0002\rA\u0013X\rZ3g\u0013\tA5M\u0003\u0002bg!)Q-\u0002a\u0001M\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001B2p]\u001aT!a\u001b\u0015\u0002\r!\fGm\\8q\u0013\ti\u0007NA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006_\u0016\u0001\r\u0001]\u0001\bgFd7i\u001c8g!\t\t8/D\u0001s\u0015\tQD%\u0003\u0002ue\n91+\u0015'D_:4\u0017AE4fi6+G/\u00193bi\u0006dun\u001a)bi\"$ba^?\u0002\u0004\u0005\u0015\u0001C\u0001=|\u001b\u0005I(B\u0001>k\u0003\t17/\u0003\u0002}s\n!\u0001+\u0019;i\u0011\u0015Qh\u00011\u0001\u007f!\tAx0C\u0002\u0002\u0002e\u0014!BR5mKNK8\u000f^3n\u0011\u0015\u0001f\u00011\u0001x\u0011\u0015yg\u00011\u0001q\u0003a\u0019\u0007.Z2l\u000bN\u001c\u0017\r]3e\u001b\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u000b\t\u0003\u0017\t\t\"a\u0005\u0002\u0018A\u0019!'!\u0004\n\u0007\u0005=1G\u0001\u0003V]&$\b\"\u0002>\b\u0001\u0004q\bBBA\u000b\u000f\u0001\u0007q/\u0001\u0007nKR\fG-\u0019;b!\u0006$\b\u000eC\u0003p\u000f\u0001\u0007\u0001/A\u000eb]\u000e,7\u000f^8s\u0013NlU\r^1eCR\fG)\u001b:fGR|'/\u001f\u000b\u0006\u0019\u0006u\u0011q\u0004\u0005\u0006!\"\u0001\ra\u001e\u0005\u0006K\"\u0001\rAZ\n\u0007\u0013\u0005\r\u0012\u0011F\u001c\u0011\u0007\t\u000b)#C\u0002\u0002(\r\u0013aa\u00142kK\u000e$\b\u0003BA\u0016\u0003[i\u0011\u0001I\u0005\u0004\u0003_\u0001#\u0001B*j].\fAb\u001d9be.\u001cVm]:j_:\u0004B!!\u000e\u000285\tA%C\u0002\u0002:\u0011\u0012Ab\u00159be.\u001cVm]:j_:\f!BZ5mK\u001a{'/\\1u!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"E\u0005YA-\u0019;bg>,(oY3t\u0013\u0011\t9%!\u0011\u0003\u0015\u0019KG.\u001a$pe6\fG/\u0001\u000bqCJ$\u0018\u000e^5p]\u000e{G.^7o\u001d\u0006lWm]\u0001\b_B$\u0018n\u001c8t!\u0015q\u0016qJ/^\u0013\r\t\tf\u0019\u0002\u0004\u001b\u0006\u0004H\u0003DA+\u0003/\nI&a\u0017\u0002^\u0005}\u0003C\u0001\u0018\n\u0011\u001d\t\td\u0004a\u0001\u0003gAQ\u0001U\bA\u0002uCq!a\u000f\u0010\u0001\u0004\ti\u0004\u0003\u0004\u0002J=\u0001\r!\u0015\u0005\b\u0003\u0017z\u0001\u0019AA'+\u00051\u0017a\u00035bI>|\u0007oQ8oM\u0002\n\u0001BY1tKB\u000bG\u000f[\u000b\u0002o\u0006I!-Y:f!\u0006$\b\u000eI\u0001\bY><\u0007+\u0019;i\u0003!awn\u001a)bi\"\u0004\u0013!\u0003:fi\u0016tG/[8o+\t\t\u0019\bE\u00033\u0003k\nI(C\u0002\u0002xM\u0012aa\u00149uS>t\u0007c\u0001\u001a\u0002|%\u0019\u0011QP\u001a\u0003\t1{gnZ\u0001\u000be\u0016$XM\u001c;j_:\u0004\u0013a\u00024jY\u0016dunZ\u000b\u0003\u0003\u000b\u00032ALAD\u0013\r\tII\b\u0002\u0012\r&dWm\u0015;sK\u0006l7+\u001b8l\u0019><\u0017\u0001\u00034jY\u0016dun\u001a\u0011\u00023\t\f7/[2Xe&$XMS8c'R\fGo\u001d+sC\u000e\\WM]\u000b\u0003\u0003#\u0003B!a\u0010\u0002\u0014&!\u0011QSA!\u0005e\u0011\u0015m]5d/JLG/\u001a&pEN#\u0018\r^:Ue\u0006\u001c7.\u001a:\u0002\u0011\u0005$GMQ1uG\"$b!a\u0003\u0002\u001c\u0006}\u0005bBAO7\u0001\u0007\u0011\u0011P\u0001\bE\u0006$8\r[%e\u0011\u001d\t\tk\u0007a\u0001\u0003G\u000bA\u0001Z1uCB!\u0011QUA]\u001d\u0011\t9+a.\u000f\t\u0005%\u0016Q\u0017\b\u0005\u0003W\u000b\u0019L\u0004\u0003\u0002.\u0006Efb\u0001+\u00020&\t1&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003K\u0019J!!\u0017\u0013\n\t\u0005m\u0016Q\u0018\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!!\u0017\u0013\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0018")
public class FileStreamSink
implements Sink,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final FileFormat fileFormat;
    private final Seq<String> partitionColumnNames;
    private final scala.collection.immutable.Map<String, String> options;
    private final Configuration hadoopConf;
    private final Path basePath;
    private final Path logPath;
    private final Option<Object> retention;
    private final FileStreamSinkLog fileLog;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean ancestorIsMetadataDirectory(Path path, Configuration hadoopConf) {
        return FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(path, hadoopConf);
    }

    public static void checkEscapedMetadataPath(FileSystem fs, Path metadataPath, SQLConf sqlConf) {
        FileStreamSink$.MODULE$.checkEscapedMetadataPath(fs, metadataPath, sqlConf);
    }

    public static Path getMetadataLogPath(FileSystem fs, Path path, SQLConf sqlConf) {
        return FileStreamSink$.MODULE$.getMetadataLogPath(fs, path, sqlConf);
    }

    public static boolean hasMetadata(Seq<String> path, Configuration hadoopConf, SQLConf sqlConf) {
        return FileStreamSink$.MODULE$.hasMetadata(path, hadoopConf, sqlConf);
    }

    public static String metadataDir() {
        return FileStreamSink$.MODULE$.metadataDir();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String name() {
        return Sink.name$(this);
    }

    @Override
    public StructType schema() {
        return Sink.schema$(this);
    }

    @Override
    public Set<TableCapability> capabilities() {
        return Sink.capabilities$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path basePath() {
        return this.basePath;
    }

    private Path logPath() {
        return this.logPath;
    }

    private Option<Object> retention() {
        return this.retention;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private BasicWriteJobStatsTracker basicWriteJobStatsTracker() {
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.hadoopConf());
        return new BasicWriteJobStatsTracker(serializableHadoopConf, BasicWriteJobStatsTracker$.MODULE$.metrics());
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= BoxesRunTime.unboxToLong((Object)this.fileLog().getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping already committed batch ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)batchId))}))));
            return;
        }
        FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(this.sparkSession.sessionState().conf().streamingFileCommitProtocolClass(), Long.toString(batchId), this.path, FileCommitProtocol$.MODULE$.instantiate$default$4());
        FileCommitProtocol fileCommitProtocol = committer;
        if (fileCommitProtocol instanceof ManifestFileCommitProtocol) {
            ManifestFileCommitProtocol manifestFileCommitProtocol = (ManifestFileCommitProtocol)fileCommitProtocol;
            manifestFileCommitProtocol.setupManifestOptions(this.fileLog(), batchId);
        }
        Seq partitionColumns = (Seq)this.partitionColumnNames.map((Function1 & Serializable)col -> {
            Function2 nameEquality = data.sparkSession().sessionState().conf().resolver();
            return (Attribute)ClassicConversions$.MODULE$.castToImpl(data).logicalPlan().output().find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink.$anonfun$addBatch$4(nameEquality, col, f))).getOrElse((Function0 & Serializable)() -> {
                throw QueryExecutionErrors$.MODULE$.partitionColumnNotFoundInSchemaError(col, data.schema());
            });
        });
        QueryExecution qe = data.queryExecution();
        FileFormatWriter$.MODULE$.write(ClassicConversions$.MODULE$.castToImpl(this.sparkSession), qe.executedPlan(), this.fileFormat, committer, new FileFormatWriter.OutputSpec(this.path, (scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String>)Predef$.MODULE$.Map().empty(), (Seq<Attribute>)qe.analyzed().output()), this.hadoopConf(), (Seq<Attribute>)partitionColumns, (Option<BucketSpec>)None$.MODULE$, (Seq<WriteJobStatsTracker>)new .colon.colon((Object)this.basicWriteJobStatsTracker(), (List)Nil$.MODULE$), this.options, FileFormatWriter$.MODULE$.write$default$11());
    }

    public String toString() {
        return "FileSink[" + this.path + "]";
    }

    public static final /* synthetic */ boolean $anonfun$addBatch$4(Function2 nameEquality$1, String col$1, Attribute f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$1));
    }

    public FileStreamSink(SparkSession sparkSession, String path, FileFormat fileFormat, Seq<String> partitionColumnNames, scala.collection.immutable.Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormat = fileFormat;
        this.partitionColumnNames = partitionColumnNames;
        this.options = options;
        Sink.$init$(this);
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.basePath = new Path(path);
        if (!this.basePath().isAbsolute()) {
            throw QueryExecutionErrors$.MODULE$.notAbsolutePathError(this.basePath());
        }
        this.logPath = FileStreamSink$.MODULE$.getMetadataLogPath(this.basePath().getFileSystem(this.hadoopConf()), this.basePath(), sparkSession.sessionState().conf());
        this.retention = options.get((Object)"retention").map((Function1 & Serializable)str -> BoxesRunTime.boxToLong((long)Utils$.MODULE$.timeStringAsMs(str)));
        this.fileLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), sparkSession, this.logPath().toString(), this.retention());
    }
}

